/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingDescriptor {
    public static final FoldingDescriptor[] EMPTY = new FoldingDescriptor[0];
    private final ASTNode myElement;
    private final TextRange myRange;
    @Nullable
    private final FoldingGroup myGroup;
    private final Set<Object> myDependencies;
    private final boolean myNeverExpands;
    private boolean myCanBeRemovedWhenCollapsed;
    private boolean myGutterMarkEnabledForSingleLine;

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(1);
        }
        this(node, range, null);
    }

    public FoldingDescriptor(@NotNull PsiElement element, @NotNull TextRange range) {
        if (element == null) {
            FoldingDescriptor.$$$reportNull$$$0(2);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(3);
        }
        this((ASTNode)ObjectUtils.assertNotNull((Object)element.getNode()), range, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(4);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(5);
        }
        this(node, range, group, Collections.emptySet());
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(6);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(7);
        }
        this(node, range, group, dependencies, false);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies, boolean neverExpands) {
        if (node == null) {
            FoldingDescriptor.$$$reportNull$$$0(8);
        }
        if (range == null) {
            FoldingDescriptor.$$$reportNull$$$0(9);
        }
        assert (range.getLength() > 0) : range + ", text: " + node.getText() + ", language = " + (Object)((Object)node.getPsi().getLanguage());
        this.myElement = node;
        this.myRange = range;
        this.myGroup = group;
        this.myDependencies = dependencies;
        assert (!this.myDependencies.contains(null));
        this.myNeverExpands = neverExpands;
    }

    @NotNull
    public ASTNode getElement() {
        ASTNode aSTNode = this.myElement;
        if (aSTNode == null) {
            FoldingDescriptor.$$$reportNull$$$0(10);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            FoldingDescriptor.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getPlaceholderText() {
        PsiElement psiElement = this.myElement.getPsi();
        if (psiElement == null) {
            return null;
        }
        Language lang = psiElement.getLanguage();
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(lang);
        if (foldingBuilder != null) {
            return foldingBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)foldingBuilder).getPlaceholderText(this.myElement, this.myRange) : foldingBuilder.getPlaceholderText(this.myElement);
        }
        return null;
    }

    @NotNull
    public Set<Object> getDependencies() {
        Set<Object> set = this.myDependencies;
        if (set == null) {
            FoldingDescriptor.$$$reportNull$$$0(12);
        }
        return set;
    }

    public boolean isNonExpandable() {
        return this.myNeverExpands;
    }

    public boolean canBeRemovedWhenCollapsed() {
        return this.myCanBeRemovedWhenCollapsed;
    }

    public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
        this.myCanBeRemovedWhenCollapsed = canBeRemovedWhenCollapsed;
    }

    public boolean isGutterMarkEnabledForSingleLine() {
        return this.myGutterMarkEnabledForSingleLine;
    }

    public void setGutterMarkEnabledForSingleLine(boolean value) {
        this.myGutterMarkEnabledForSingleLine = value;
    }

    public String toString() {
        return this.myRange + " for AST: " + this.myElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/FoldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/FoldingDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

