/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.Patches;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Desktop;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "defaultBrowserCommand", "", "", "getDefaultBrowserCommand", "()Ljava/util/List;", "generalSettings", "Lcom/intellij/ide/GeneralSettings;", "getGeneralSettings", "()Lcom/intellij/ide/GeneralSettings;", "addArgs", "", "command", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "settings", "Lcom/intellij/ide/browsers/BrowserSpecificSettings;", "additional", "", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/ide/browsers/BrowserSpecificSettings;[Ljava/lang/String;)V", "isDesktopActionSupported", "", "action", "Ljava/awt/Desktop$Action;", "intellij.platform.ide"})
public final class BrowserLauncherApplessKt {
    private static final Logger LOG;

    private static final boolean isDesktopActionSupported(Desktop.Action action) {
        return !Patches.SUN_BUG_ID_6486393 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
    }

    private static final GeneralSettings getGeneralSettings() {
        if (ApplicationManager.getApplication() != null) {
            GeneralSettings generalSettings = GeneralSettings.getInstance();
            if (generalSettings != null) {
                GeneralSettings generalSettings2;
                GeneralSettings it = generalSettings2 = generalSettings;
                boolean bl = false;
                return it;
            }
        }
        return new GeneralSettings();
    }

    private static final List<String> getDefaultBrowserCommand() {
        List list;
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[4];
            objectArray[0] = ExecUtil.getWindowsShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = GeneralCommandLine.inescapableQuote("");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GeneralCommandLine.inescapableQuote(\"\")");
            objectArray[3] = string;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = SystemInfo.isMac ? CollectionsKt.listOf((Object)ExecUtil.getOpenCommandPath()) : (SystemInfo.isUnix && SystemInfo.hasXdgOpen() ? CollectionsKt.listOf((Object)"xdg-open") : null);
        }
        return list;
    }

    private static final void addArgs(GeneralCommandLine command, BrowserSpecificSettings settings, String[] additional) {
        Object specific;
        Object object = settings;
        if (object == null || (object = ((BrowserSpecificSettings)object).getAdditionalParameters()) == null) {
            object = specific = CollectionsKt.emptyList();
        }
        if (specific.size() + additional.length > 0) {
            if (BrowserLauncherAppless.Companion.isOpenCommandUsed(command)) {
                if (BrowserUtil.isOpenCommandSupportArgs()) {
                    command.addParameter("--args");
                } else {
                    LOG.warn("'open' command doesn't allow to pass command line arguments so they will be ignored: " + StringUtil.join((Collection)((Collection)specific), (String)", ") + " " + Arrays.toString(additional));
                    return;
                }
            }
            command.addParameters((List<String>)specific);
            command.addParameters(Arrays.copyOf(additional, additional.length));
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BrowserLauncherAppless.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isDesktopActionSupported(Desktop.Action action) {
        return BrowserLauncherApplessKt.isDesktopActionSupported(action);
    }

    public static final /* synthetic */ GeneralSettings access$getGeneralSettings$p() {
        return BrowserLauncherApplessKt.getGeneralSettings();
    }

    public static final /* synthetic */ List access$getDefaultBrowserCommand$p() {
        return BrowserLauncherApplessKt.getDefaultBrowserCommand();
    }

    public static final /* synthetic */ void access$addArgs(GeneralCommandLine command, BrowserSpecificSettings settings, String[] additional) {
        BrowserLauncherApplessKt.addArgs(command, settings, additional);
    }
}

