/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Alarm;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class HelpTooltip {
    private static final Color BACKGROUND_COLOR = JBColor.namedColor((String)"HelpTooltip.background", (int)0xF7F7F7);
    private static final Color FONT_COLOR = JBColor.namedColor((String)"HelpTooltip.foreground", (int)0x1A1A1A);
    private static final Color SHORTCUT_COLOR = JBColor.namedColor((String)"HelpTooltip.shortcutForeground", (int)0x787878);
    private static final Color BORDER_COLOR = JBColor.namedColor((String)"HelpTooltip.borderColor", (int)0xADADAD);
    private static final String DOTS = "...";
    private static final String PARAGRAPH_SPLITTER = "<p/?>";
    private static final String TOOLTIP_PROPERTY = "JComponent.helpTooltip";
    private String title;
    private String shortcut;
    private String description;
    private LinkLabel link;
    private boolean neverHide;
    private Alignment alignment = Alignment.BOTTOM;
    private BooleanSupplier masterPopupOpenCondition = () -> true;
    private ComponentPopupBuilder myPopupBuilder;
    private Dimension myPopupSize;
    private JBPopup myPopup;
    private final Alarm popupAlarm = new Alarm();
    private boolean isOverPopup;
    private boolean isMultiline;
    private int myDismissDelay;
    private MouseAdapter myMouseListener;
    private static final JBValue VGAP = new JBValue.UIInteger("HelpTooltip.verticalGap", 4);
    private static final JBValue HGAP = new JBValue.UIInteger("HelpTooltip.horizontalGap", 10);
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("HelpTooltip.maxWidth", 250);
    private static final JBValue X_OFFSET = new JBValue.UIInteger("HelpTooltip.xOffset", 0);
    private static final JBValue Y_OFFSET = new JBValue.UIInteger("HelpTooltip.yOffset", 0);
    private static final JBValue FONT_DELTA_SIZE = new JBValue.UIInteger("HelpTooltip.fontSizeDelta", 0);

    public HelpTooltip setTitle(String title) {
        this.title = title;
        return this;
    }

    public HelpTooltip setShortcut(String shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public HelpTooltip setDescription(String description) {
        this.description = description;
        return this;
    }

    public HelpTooltip setLink(String linkText, Runnable linkAction) {
        this.link = LinkLabel.create(linkText, () -> {
            this.hidePopup(true);
            linkAction.run();
        });
        return this;
    }

    public HelpTooltip setNeverHideOnTimeout(boolean neverHide) {
        this.neverHide = neverHide;
        return this;
    }

    public HelpTooltip setLocation(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public void installOn(@NotNull JComponent component) {
        if (component == null) {
            HelpTooltip.$$$reportNull$$$0(0);
        }
        this.myDismissDelay = Registry.intValue((String)(this.isMultiline ? "ide.helptooltip.full.dismissDelay" : "ide.helptooltip.regular.dismissDelay"));
        this.neverHide = this.neverHide || UIUtil.isHelpButton((Component)component);
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HelpTooltip.this.myPopup != null && !HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.myPopup.cancel();
                }
                HelpTooltip.this.scheduleShow((JComponent)e.getComponent(), Registry.intValue((String)"ide.tooltip.initialReshowDelay"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HelpTooltip.this.scheduleHide(HelpTooltip.this.link == null, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (HelpTooltip.this.myPopup == null || HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.scheduleShow((JComponent)e.getComponent(), Registry.intValue((String)"ide.tooltip.reshowDelay"));
                }
            }
        };
        this.initPopupBuilder();
        component.putClientProperty(TOOLTIP_PROPERTY, this);
        this.installMouseListeners(component);
    }

    private void initPopupBuilder() {
        JPanel tipPanel = this.createTipPanel();
        this.myPopupSize = tipPanel.getPreferredSize();
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(tipPanel, null).setBorderColor(BORDER_COLOR).setShowShadow(false);
    }

    private JPanel createTipPanel() {
        JPanel tipPanel = new JPanel();
        tipPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HelpTooltip.this.isOverPopup = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (HelpTooltip.this.link == null || !HelpTooltip.this.link.getBounds().contains(e.getPoint())) {
                    HelpTooltip.this.isOverPopup = false;
                    HelpTooltip.this.hidePopup(false);
                }
            }
        });
        tipPanel.setLayout(new VerticalLayout(VGAP.get()));
        tipPanel.setBackground(BACKGROUND_COLOR);
        if (StringUtil.isNotEmpty((String)this.title)) {
            tipPanel.add((Component)new Header(), "TOP");
        }
        if (StringUtil.isNotEmpty((String)this.description)) {
            String[] pa = this.description.split(PARAGRAPH_SPLITTER);
            this.isMultiline = pa.length > 1;
            for (String p : pa) {
                if (p.isEmpty()) continue;
                tipPanel.add((Component)new Paragraph(p), "TOP");
            }
        }
        if (this.link != null) {
            this.link.setFont(HelpTooltip.modifyFont(this.link.getFont()));
            tipPanel.add((Component)this.link, "TOP");
        }
        this.isMultiline = this.isMultiline || StringUtil.isNotEmpty((String)this.description) && (StringUtil.isNotEmpty((String)this.title) || this.link != null);
        tipPanel.setBorder(HelpTooltip.textBorder(this.isMultiline));
        return tipPanel;
    }

    private void installMouseListeners(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(1);
        }
        owner.addMouseListener(this.myMouseListener);
        owner.addMouseMotionListener(this.myMouseListener);
    }

    private void uninstallMouseListeners(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(2);
        }
        owner.removeMouseListener(this.myMouseListener);
        owner.removeMouseMotionListener(this.myMouseListener);
    }

    public static void dispose(@NotNull Component owner) {
        JComponent component;
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(3);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)(component = (JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.hidePopup(true);
            instance.uninstallMouseListeners(component);
            component.putClientProperty(TOOLTIP_PROPERTY, null);
            instance.masterPopupOpenCondition = null;
        }
    }

    public static void hide(@NotNull Component owner) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(4);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.hidePopup(true);
        }
    }

    public static void setMasterPopup(@NotNull Component owner, JBPopup master) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(5);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null && instance.myPopup != master) {
            instance.masterPopupOpenCondition = () -> master == null || !master.isVisible();
        }
    }

    @ApiStatus.Experimental
    public static void setMasterPopupOpenCondition(@NotNull Component owner, BooleanSupplier condition) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(6);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.masterPopupOpenCondition = condition;
        }
    }

    private void scheduleShow(JComponent owner, int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> {
            if (this.masterPopupOpenCondition.getAsBoolean()) {
                this.myPopup = this.myPopupBuilder.createPopup();
                this.myPopup.show(new RelativePoint((Component)owner, this.alignment.getPointFor(owner, this.myPopupSize)));
                if (!this.neverHide) {
                    this.scheduleHide(true, this.myDismissDelay);
                }
            }
        }, delay);
    }

    private void scheduleHide(boolean force, int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> this.hidePopup(force), delay);
    }

    private void hidePopup(boolean force) {
        this.popupAlarm.cancelAllRequests();
        if (this.myPopup != null && this.myPopup.isVisible() && (!this.isOverPopup || force)) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    private static Border textBorder(boolean isDefault) {
        Insets i = UIManager.getInsets(isDefault ? "HelpTooltip.defaultTextBorderInsets" : "HelpTooltip.smallTextBorderInsets");
        return i != null ? new JBEmptyBorder(i) : JBUI.Borders.empty();
    }

    private static Font modifyFont(Font font) {
        return font.deriveFont((float)font.getSize() + (float)FONT_DELTA_SIZE.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/HelpTooltip";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installOn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "installMouseListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "uninstallMouseListeners";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "dispose";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hide";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setMasterPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setMasterPopupOpenCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Paragraph
    extends JLabel {
        private Paragraph(String text) {
            this.init(text);
        }

        private void init(String text) {
            this.setForeground(FONT_COLOR);
            this.setFont(HelpTooltip.modifyFont(this.getFont()));
            View v = BasicHTML.createHTMLView(this, String.format("<html>%s</html>", text));
            float width = v.getPreferredSpan(0);
            HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
            this.setText(width > (float)MAX_WIDTH.get() ? String.format("<html><div width=%d>%s</div></html>", MAX_WIDTH.get(), text) : String.format("<html>%s</html>", text));
            if (width > (float)MAX_WIDTH.get() && (v = (View)this.getClientProperty("html")) != null) {
                width = 0.0f;
                for (View row : this.getRows(v)) {
                    float rWidth = row.getPreferredSpan(0);
                    if (!(width < rWidth)) continue;
                    width = rWidth;
                }
                v.setSize(width, v.getPreferredSpan(1));
            }
        }

        private Collection<View> getRows(@NotNull View root) {
            if (root == null) {
                Paragraph.$$$reportNull$$$0(0);
            }
            ArrayList<View> rows = new ArrayList<View>();
            this.visit(root, rows);
            return rows;
        }

        private void visit(@NotNull View v, Collection<? super View> result2) {
            String cname;
            if (v == null) {
                Paragraph.$$$reportNull$$$0(1);
            }
            if ((cname = v.getClass().getCanonicalName()) != null && cname.contains("ParagraphView.Row")) {
                result2.add(v);
            }
            for (int i = 0; i < v.getViewCount(); ++i) {
                this.visit(v.getView(i), result2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/HelpTooltip$Paragraph";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class Header
    extends JPanel {
        private final AttributedString titleString;
        private final AttributedString dotString;
        private final AttributedString shortcutString;
        private LineBreakMeasurer lineMeasurer;
        private TextLayout dotLayout;
        private TextLayout shortcutLayout;
        private final int paragraphStart;
        private final int paragraphEnd;

        private Header() {
            this.setOpaque(false);
            Font font = HelpTooltip.modifyFont(this.getFont());
            this.setFont(font);
            Font titleFont = StringUtil.isNotEmpty((String)HelpTooltip.this.description) ? font.deriveFont(1) : font;
            Map<TextAttribute, ?> tfa = titleFont.getAttributes();
            this.titleString = new AttributedString(HelpTooltip.this.title, tfa);
            this.dotString = new AttributedString(HelpTooltip.DOTS, tfa);
            this.shortcutString = StringUtil.isNotEmpty((String)HelpTooltip.this.shortcut) ? new AttributedString(HelpTooltip.this.shortcut, font.getAttributes()) : null;
            AttributedCharacterIterator paragraph = this.titleString.getIterator();
            this.paragraphStart = paragraph.getBeginIndex();
            this.paragraphEnd = paragraph.getEndIndex();
            FontMetrics tfm = this.getFontMetrics(titleFont);
            int titleWidth = UIUtilities.stringWidth((JComponent)this, (FontMetrics)tfm, (String)HelpTooltip.this.title);
            FontMetrics fm = this.getFontMetrics(font);
            boolean limitWidth = StringUtil.isNotEmpty((String)HelpTooltip.this.description) || HelpTooltip.this.link != null;
            HelpTooltip.this.isMultiline = limitWidth && (titleWidth += StringUtil.isNotEmpty((String)HelpTooltip.this.shortcut) ? HGAP.get() + UIUtilities.stringWidth((JComponent)this, (FontMetrics)fm, (String)HelpTooltip.this.shortcut) : 0) > MAX_WIDTH.get();
            this.setPreferredSize(HelpTooltip.this.isMultiline ? new Dimension(MAX_WIDTH.get(), tfm.getHeight() * 2) : new Dimension(titleWidth, fm.getHeight()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setColor(FONT_COLOR);
                GraphicsUtil.setupAntialiasing((Graphics)g2);
                if (this.lineMeasurer == null) {
                    FontRenderContext frc = g2.getFontRenderContext();
                    this.lineMeasurer = new LineBreakMeasurer(this.titleString.getIterator(), frc);
                    LineBreakMeasurer dotMeasurer = new LineBreakMeasurer(this.dotString.getIterator(), frc);
                    this.dotLayout = dotMeasurer.nextLayout(Float.POSITIVE_INFINITY);
                    if (this.shortcutString != null) {
                        LineBreakMeasurer shortcutMeasurer = new LineBreakMeasurer(this.shortcutString.getIterator(), frc);
                        this.shortcutLayout = shortcutMeasurer.nextLayout(Float.POSITIVE_INFINITY);
                    }
                }
                this.lineMeasurer.setPosition(this.paragraphStart);
                float breakWidth = this.getWidth();
                float drawPosY = 0.0f;
                TextLayout layout = null;
                for (int line = 0; this.lineMeasurer.getPosition() < this.paragraphEnd && line < 1; ++line) {
                    layout = this.lineMeasurer.nextLayout(breakWidth);
                    layout.draw(g2, 0.0f, drawPosY += layout.getAscent());
                    drawPosY += layout.getDescent() + layout.getLeading();
                }
                if (this.lineMeasurer.getPosition() < this.paragraphEnd) {
                    if (this.shortcutString != null) {
                        breakWidth -= this.dotLayout.getAdvance() + (float)HGAP.get() + this.shortcutLayout.getAdvance();
                    }
                    layout = this.lineMeasurer.nextLayout(breakWidth);
                    layout.draw(g2, 0.0f, drawPosY += layout.getAscent());
                    if (this.shortcutString != null) {
                        this.dotLayout.draw(g2, layout.getAdvance(), drawPosY);
                        g2.setColor(SHORTCUT_COLOR);
                        this.shortcutLayout.draw(g2, layout.getAdvance() + this.dotLayout.getAdvance() + (float)HGAP.get(), drawPosY);
                    }
                } else if (layout != null && this.shortcutString != null) {
                    g2.setColor(SHORTCUT_COLOR);
                    if (Float.compare((float)this.getWidth() - layout.getAdvance(), this.shortcutLayout.getAdvance() + (float)HGAP.get()) >= 0) {
                        drawPosY = this.shortcutLayout.getAscent();
                        this.shortcutLayout.draw(g2, layout.getAdvance() + (float)HGAP.get(), drawPosY);
                    } else {
                        this.shortcutLayout.draw(g2, 0.0f, drawPosY += this.shortcutLayout.getAscent());
                    }
                }
            }
            finally {
                g2.dispose();
            }
        }
    }

    public static enum Alignment {
        RIGHT{

            @Override
            public Point getPointFor(JComponent owner, Dimension popupSize) {
                Dimension size = owner.getSize();
                return new Point(size.width + JBUI.scale((int)5) - X_OFFSET.get(), JBUI.scale((int)1) + Y_OFFSET.get());
            }
        }
        ,
        BOTTOM{

            @Override
            public Point getPointFor(JComponent owner, Dimension popupSize) {
                Dimension size = owner.getSize();
                return new Point(JBUI.scale((int)1) + X_OFFSET.get(), JBUI.scale((int)5) + size.height - Y_OFFSET.get());
            }
        }
        ,
        HELP_BUTTON{

            @Override
            public Point getPointFor(JComponent owner, Dimension popupSize) {
                Insets i = owner.getInsets();
                return new Point(X_OFFSET.get() - JBUI.scale((int)40), i.top + Y_OFFSET.get() - JBUI.scale((int)6) - popupSize.height);
            }
        };


        public abstract Point getPointFor(JComponent var1, Dimension var2);
    }
}

