/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.PropertyNameUtil;
import com.intellij.configurationStore.Property;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.lang.reflect.Field;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class CodeStyleFieldAccessor<T, V>
extends CodeStylePropertyAccessor<V> {
    private final Object myObject;
    private final Field myField;

    public CodeStyleFieldAccessor(@NotNull Object object, @NotNull Field field) {
        if (object == null) {
            CodeStyleFieldAccessor.$$$reportNull$$$0(0);
        }
        if (field == null) {
            CodeStyleFieldAccessor.$$$reportNull$$$0(1);
        }
        this.myObject = object;
        this.myField = field;
    }

    @Override
    public boolean set(@NotNull V extVal) {
        if (extVal == null) {
            CodeStyleFieldAccessor.$$$reportNull$$$0(2);
        }
        try {
            T value = this.fromExternal(extVal);
            if (value != null) {
                this.myField.set(this.myObject, value);
                return true;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    @Nullable
    public V get() {
        try {
            Object value = this.myField.get(this.myObject);
            return value != null && !this.isEmpty(value) ? (V)this.toExternal(value) : null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @NotNull
    public Class getObjectClass() {
        Class<?> clazz = this.myObject.getClass();
        if (clazz == null) {
            CodeStyleFieldAccessor.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    protected boolean isEmpty(@NotNull T value) {
        if (value == null) {
            CodeStyleFieldAccessor.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Nullable
    protected abstract T fromExternal(@NotNull V var1);

    @NotNull
    protected abstract V toExternal(@NotNull T var1);

    @Override
    public String getPropertyName() {
        String externalName;
        Property descriptor = this.myField.getAnnotation(Property.class);
        if (descriptor != null && !StringUtil.isEmpty((String)(externalName = descriptor.externalName()))) {
            return externalName;
        }
        return PropertyNameUtil.getPropertyName(this.myField.getName());
    }

    @Override
    public boolean isGenericProperty() {
        return this.myObject instanceof CommonCodeStyleSettings || this.myObject instanceof CommonCodeStyleSettings.IndentOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extVal";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/properties/CodeStyleFieldAccessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/properties/CodeStyleFieldAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

