/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.resources;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.model.module.JpsModule;

public class ResourcesBuilder
extends TargetBuilder<ResourceRootDescriptor, ResourcesTarget> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.resources.ResourcesBuilder");
    public static final String BUILDER_NAME = "Resource Compiler";
    private static final List<StandardResourceBuilderEnabler> ourEnablers = Collections.synchronizedList(new ArrayList());

    public ResourcesBuilder() {
        super(ResourcesTargetType.ALL_TYPES);
    }

    public static void registerEnabler(StandardResourceBuilderEnabler enabler) {
        ourEnablers.add(enabler);
    }

    @Override
    public void build(@NotNull ResourcesTarget target, @NotNull DirtyFilesHolder<ResourceRootDescriptor, ResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            ResourcesBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ResourcesBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            ResourcesBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ResourcesBuilder.$$$reportNull$$$0(3);
        }
        if (!ResourcesBuilder.isResourceProcessingEnabled(target.getModule())) {
            return;
        }
        try {
            HashMap skippedRoots = new HashMap();
            holder.processDirtyFiles((t, f, srcRoot) -> {
                Boolean isSkipped = (Boolean)skippedRoots.get(srcRoot);
                if (isSkipped == null) {
                    File outputDir = t.getOutputDir();
                    isSkipped = outputDir == null || FileUtil.filesEqual((File)outputDir, (File)srcRoot.getRootFile());
                    skippedRoots.put(srcRoot, isSkipped);
                }
                if (isSkipped.booleanValue()) {
                    return true;
                }
                try {
                    ResourcesBuilder.copyResource(context, srcRoot, f, outputConsumer);
                    return !context.getCancelStatus().isCanceled();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    context.processMessage(new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, e.getMessage(), FileUtil.toSystemIndependentName((String)f.getPath())));
                    return false;
                }
            });
            context.checkCanceled();
            context.processMessage(new ProgressMessage(""));
        }
        catch (BuildDataCorruptedException | ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProjectBuildException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isResourceProcessingEnabled(JpsModule module) {
        List<StandardResourceBuilderEnabler> list = ourEnablers;
        synchronized (list) {
            for (StandardResourceBuilderEnabler enabler : ourEnablers) {
                if (enabler.isResourceProcessingEnabled(module)) continue;
                return false;
            }
        }
        return true;
    }

    private static void copyResource(CompileContext context, ResourceRootDescriptor rd, File file, BuildOutputConsumer outputConsumer) throws IOException {
        File outputRoot = rd.getTarget().getOutputDir();
        if (outputRoot == null) {
            return;
        }
        String sourceRootPath = FileUtil.toSystemIndependentName((String)rd.getRootFile().getAbsolutePath());
        String relativePath = FileUtil.getRelativePath((String)sourceRootPath, (String)FileUtil.toSystemIndependentName((String)file.getPath()), (char)'/');
        String prefix = rd.getPackagePrefix();
        StringBuilder targetPath = new StringBuilder();
        targetPath.append(FileUtil.toSystemIndependentName((String)outputRoot.getPath()));
        if (prefix.length() > 0) {
            targetPath.append('/').append(prefix.replace('.', '/'));
        }
        targetPath.append('/').append(relativePath);
        context.processMessage(new ProgressMessage("Copying resources... [" + rd.getTarget().getModule().getName() + "]"));
        try {
            File targetFile = new File(targetPath.toString());
            FSOperations.copy(file, targetFile);
            outputConsumer.registerOutputFile(targetFile, Collections.singletonList(file.getPath()));
        }
        catch (Exception e) {
            context.processMessage(new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, CompilerMessage.getTextFromThrowable(e)));
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            ResourcesBuilder.$$$reportNull$$$0(4);
        }
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/resources/ResourcesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/resources/ResourcesBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

