/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLParserFactory;
import org.jetbrains.annotations.Nullable;

public class FormsParsing {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.java.FormsParsing");
    private static final String FORM_TAG = "form";

    private FormsParsing() {
    }

    public static String readBoundClassName(File formFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(formFile));){
            final Ref result = new Ref(null);
            FormsParsing.parse(in, (IXMLBuilder)new IXMLBuilderAdapter(){

                @Override
                public void startElement(String elemName, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    if (!FormsParsing.FORM_TAG.equalsIgnoreCase(elemName)) {
                        1.stop();
                    }
                }

                @Override
                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if ("bind-to-class".equals(key)) {
                        result.set((Object)value);
                        1.stop();
                    }
                }

                @Override
                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    1.stop();
                }
            });
            String string = (String)result.get();
            return string;
        }
    }

    public static void parse(InputStream is, IXMLBuilder builder) {
        try {
            FormsParsing.parse((IXMLReader)new MyXMLReader(is), builder);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void parse(IXMLReader r, IXMLBuilder builder) {
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            parser.setReader(r);
            parser.setBuilder(builder);
            parser.setValidator((IXMLValidator)new EmptyValidator());
            parser.setResolver((IXMLEntityResolver)new EmptyEntityResolver());
            try {
                parser.parse();
            }
            catch (XMLException e) {
                if (e.getException() instanceof ParserStoppedException) {
                    return;
                }
                LOG.debug((Throwable)e);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static class ParserStoppedException
    extends RuntimeException {
        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class IXMLBuilderAdapter
    implements IXMLBuilder {
        public void startBuilding(String systemID, int lineNr) throws Exception {
        }

        public void newProcessingInstruction(String target, Reader reader) throws Exception {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
        }

        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        }

        public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        }

        @Nullable
        public Object getResult() throws Exception {
            return null;
        }

        protected static void stop() {
            throw new ParserStoppedException();
        }
    }

    private static class MyXMLReader
    extends StdXMLReader {
        private String publicId;
        private String systemId;

        MyXMLReader(Reader documentReader) {
            super(documentReader);
        }

        MyXMLReader(InputStream stream) throws IOException {
            super(stream);
        }

        public Reader openStream(String publicId, String systemId) throws IOException {
            this.publicId = StringUtil.isEmpty((String)publicId) ? null : publicId;
            this.systemId = StringUtil.isEmpty((String)systemId) ? null : systemId;
            return new StringReader(" ");
        }
    }

    private static class EmptyEntityResolver
    implements IXMLEntityResolver {
        private EmptyEntityResolver() {
        }

        public void addInternalEntity(String name, String value) {
        }

        public void addExternalEntity(String name, String publicID, String systemID) {
        }

        public Reader getEntity(IXMLReader xmlReader, String name) throws XMLParseException {
            return new StringReader("");
        }

        public boolean isExternalEntity(String name) {
            return false;
        }
    }

    private static class EmptyValidator
    extends NonValidator {
        private IXMLEntityResolver myParameterEntityResolver;

        private EmptyValidator() {
        }

        public void setParameterEntityResolver(IXMLEntityResolver resolver) {
            this.myParameterEntityResolver = resolver;
        }

        public IXMLEntityResolver getParameterEntityResolver() {
            return this.myParameterEntityResolver;
        }

        public void parseDTD(String publicID, IXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
            if (!external) {
                int cnt = 1;
                char ch = reader.read();
                while (ch != ']' || --cnt != 0) {
                    if (ch == '[') {
                        ++cnt;
                    }
                    ch = reader.read();
                }
            } else {
                char ch;
                int origLevel = reader.getStreamLevel();
                do {
                    ch = reader.read();
                } while (reader.getStreamLevel() >= origLevel);
                reader.unread(ch);
                return;
            }
        }

        public void elementStarted(String name, String systemId, int lineNr) {
        }

        public void elementEnded(String name, String systemId, int lineNr) {
        }

        public void attributeAdded(String key, String value, String systemId, int lineNr) {
        }

        public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        }

        public void PCDataAdded(String systemId, int lineNr) {
        }
    }
}

