/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.events;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;

public class ProjectScanning
implements MavenLoggedEventParser {
    private static final String NAME = "Scanning for projects";
    boolean inScan = false;
    boolean waitForComplete = false;
    private boolean completed;

    @Override
    public boolean supportsType(LogMessageType type) {
        return type == LogMessageType.INFO;
    }

    @Override
    public boolean checkLogLine(@NotNull ExternalSystemTaskId id, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (id == null) {
            ProjectScanning.$$$reportNull$$$0(0);
        }
        if (logLine == null) {
            ProjectScanning.$$$reportNull$$$0(1);
        }
        if (logEntryReader == null) {
            ProjectScanning.$$$reportNull$$$0(2);
        }
        if (messageConsumer == null) {
            ProjectScanning.$$$reportNull$$$0(3);
        }
        if (this.completed) {
            return false;
        }
        String line = logLine.getLine();
        if (this.inScan && line.startsWith("--")) {
            messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)NAME, (Object)id, System.currentTimeMillis(), NAME, (EventResult)new SuccessResultImpl()));
            this.completed = true;
            this.inScan = false;
        }
        if (line.equals("Scanning for projects...")) {
            messageConsumer.accept((BuildEvent)new StartEventImpl((Object)NAME, (Object)id, System.currentTimeMillis(), NAME));
            this.inScan = true;
        }
        return this.inScan;
    }

    @Override
    public void finish(@NotNull ExternalSystemTaskId taskId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (taskId == null) {
            ProjectScanning.$$$reportNull$$$0(4);
        }
        if (messageConsumer == null) {
            ProjectScanning.$$$reportNull$$$0(5);
        }
        if (this.inScan) {
            messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)NAME, (Object)taskId, System.currentTimeMillis(), NAME, (EventResult)new FailureResultImpl("Failed", null)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntryReader";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/events/ProjectScanning";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLogLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "finish";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

