/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.events;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;

public class ArtifactDownloadScanning
implements MavenLoggedEventParser {
    private static final String DOWNLOADING = "Downloading";
    private static final String DOWNLOADED = "Downloaded";
    private final Set<String> startedToDownload = ContainerUtil.newHashSet();

    @Override
    public boolean supportsType(@Nullable LogMessageType type) {
        return type == null;
    }

    @Override
    public boolean checkLogLine(@NotNull ExternalSystemTaskId id, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (id == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(0);
        }
        if (logLine == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(1);
        }
        if (logEntryReader == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(2);
        }
        if (messageConsumer == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(3);
        }
        String line = logLine.getLine();
        if (logLine.getLine().startsWith(DOWNLOADING)) {
            int resourceIdx = line.indexOf(58);
            if (resourceIdx < 0) {
                return false;
            }
            String resourceName = line.substring(resourceIdx + 1).trim();
            messageConsumer.accept((BuildEvent)new StartEventImpl((Object)this.getMessage(resourceName), (Object)id, System.currentTimeMillis(), this.getMessage(resourceName)));
            this.startedToDownload.add(resourceName);
            return true;
        }
        if (line.startsWith(DOWNLOADED)) {
            int openBracketIdx = line.indexOf("(");
            if (openBracketIdx < 0) {
                return false;
            }
            int resourceIdx = line.indexOf(58);
            if (resourceIdx < 0) {
                return false;
            }
            String resourceName = line.substring(resourceIdx + 1, openBracketIdx - 1).trim();
            if (this.startedToDownload.remove(resourceName)) {
                messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)this.getMessage(resourceName), (Object)id, System.currentTimeMillis(), this.getMessage(resourceName), (EventResult)new SuccessResultImpl()));
                return true;
            }
        }
        return false;
    }

    @Override
    public void finish(@NotNull ExternalSystemTaskId taskId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (taskId == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(4);
        }
        if (messageConsumer == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(5);
        }
        for (String resource : this.startedToDownload) {
            messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)this.getMessage(resource), (Object)taskId, System.currentTimeMillis(), this.getMessage(resource), (EventResult)new FailureResultImpl("Cannot download artifact", null)));
        }
        this.startedToDownload.clear();
    }

    @NotNull
    private String getMessage(String resourceName) {
        String string = "Download " + resourceName;
        if (string == null) {
            ArtifactDownloadScanning.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntryReader";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/events/ArtifactDownloadScanning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/events/ArtifactDownloadScanning";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLogLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

