/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output;

import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogOutputParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.events.ArtifactDownloadScanning;
import org.jetbrains.idea.maven.externalSystemIntegration.output.events.CommonErrorParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.events.JavaBuildErrorNotification;
import org.jetbrains.idea.maven.externalSystemIntegration.output.events.KotlinBuildErrorNotification;
import org.jetbrains.idea.maven.externalSystemIntegration.output.events.ProjectScanning;
import org.jetbrains.idea.maven.externalSystemIntegration.output.events.WarningNotifier;
import org.jetbrains.idea.maven.utils.MavenUtil;

@ApiStatus.Experimental
public class MavenOutputParserProvider
implements ExternalSystemOutputParserProvider {
    public ProjectSystemId getExternalSystemId() {
        return MavenUtil.SYSTEM_ID;
    }

    public List<BuildOutputParser> getBuildOutputParsers(ExternalSystemTask task) {
        return ContainerUtil.list((Object[])new BuildOutputParser[]{MavenOutputParserProvider.createMavenOutputParser(task.getId())});
    }

    public static MavenLogOutputParser createMavenOutputParser(ExternalSystemTaskId taskId) {
        return new MavenLogOutputParser(taskId, ContainerUtil.list((Object[])new MavenLoggedEventParser[]{new ArtifactDownloadScanning(), new JavaBuildErrorNotification(), new KotlinBuildErrorNotification(), new ProjectScanning(), new WarningNotifier(), new CommonErrorParser()}));
    }
}

