/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.build;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.JpsProjectTaskRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.build.MavenArtifactBuilder;
import org.jetbrains.idea.maven.execution.build.MavenArtifactProperties;
import org.jetbrains.idea.maven.execution.build.MavenArtifactPropertiesProvider;
import org.jetbrains.idea.maven.execution.build.MavenExecutionEnvironmentProvider;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectTaskRunner
extends ProjectTaskRunner {
    private static final Pattern ERRORS_NUMBER_PATTERN = Pattern.compile("^\\[INFO] (\\d+) errors\\s*$");
    private static final Pattern WARNING_PATTERN = Pattern.compile("^\\[WARNING]");

    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(2);
        }
        Map taskMap = JpsProjectTaskRunner.groupBy(tasks);
        MavenProjectTaskRunner.buildModuleFiles(project, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleFilesBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildModules(project, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleResourcesBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildModules(project, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ModuleBuildTask.class, Collections.emptyList()));
        MavenProjectTaskRunner.buildArtifacts(project, callback, MavenProjectTaskRunner.getFromGroupedMap(taskMap, ProjectModelBuildTask.class, Collections.emptyList()));
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("MavenProjectTaskRunner#canRun(ProjectTask)");
    }

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        ExecuteRunConfigurationTask task;
        RunProfile runProfile;
        ProjectModelBuildTask buildTask;
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (projectTask == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (!MavenRunner.getInstance(project).getSettings().isDelegateBuildToMaven()) {
            return false;
        }
        if (projectTask instanceof ModuleBuildTask) {
            Module module = ((ModuleBuildTask)projectTask).getModule();
            return MavenUtil.isMavenModule(module);
        }
        if (projectTask instanceof ProjectModelBuildTask && (buildTask = (ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact) {
            Artifact artifact = (Artifact)buildTask.getBuildableElement();
            MavenArtifactProperties properties = null;
            for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
                ArtifactProperties artifactProperties;
                if (!(provider instanceof MavenArtifactPropertiesProvider) || !((artifactProperties = artifact.getProperties(provider)) instanceof MavenArtifactProperties)) continue;
                properties = (MavenArtifactProperties)artifactProperties;
                break;
            }
            if (properties == null || properties.getModuleName() == null) {
                return false;
            }
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(properties.getModuleName());
            if (!MavenUtil.isMavenModule(module)) {
                return false;
            }
            MavenArtifactBuilder[] mavenArtifactBuilderArray = (MavenArtifactBuilder[])MavenArtifactBuilder.EP_NAME.getExtensions();
            int n = mavenArtifactBuilderArray.length;
            for (int i = 0; i < n; ++i) {
                MavenArtifactBuilder artifactBuilder = mavenArtifactBuilderArray[i];
                if (!artifactBuilder.isApplicable(buildTask)) continue;
                return true;
            }
        }
        if (projectTask instanceof ExecuteRunConfigurationTask && (runProfile = (task = (ExecuteRunConfigurationTask)projectTask).getRunProfile()) instanceof ModuleBasedConfiguration) {
            RunConfigurationModule module = ((ModuleBasedConfiguration)runProfile).getConfigurationModule();
            if (!MavenUtil.isMavenModule(module.getModule())) {
                return false;
            }
            for (MavenExecutionEnvironmentProvider environmentProvider : (MavenExecutionEnvironmentProvider[])MavenExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
                if (!environmentProvider.isApplicable(task)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (task == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(7);
        }
        for (MavenExecutionEnvironmentProvider environmentProvider : (MavenExecutionEnvironmentProvider[])MavenExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
            if (!environmentProvider.isApplicable(task)) continue;
            return environmentProvider.createExecutionEnvironment(project, task, executor);
        }
        return null;
    }

    private static <T extends ProjectTask> List<? extends T> getFromGroupedMap(Map<Class<? extends ProjectTask>, List<ProjectTask>> map, Class<T> key, List<? extends T> defaultValue) {
        List<ProjectTask> result = map.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private static void buildModules(@NotNull Project project, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ModuleBuildTask> moduleBuildTasks) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (moduleBuildTasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(9);
        }
        if (moduleBuildTasks.isEmpty()) {
            return;
        }
        MavenRunner mavenRunner = MavenRunner.getInstance(project);
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
        MavenExplicitProfiles explicitProfiles = mavenProjectsManager.getExplicitProfiles();
        HashMap<MavenProject, List> rootProjectsToModules = new HashMap<MavenProject, List>();
        boolean buildOnlyResources = false;
        for (ModuleBuildTask moduleBuildTask : moduleBuildTasks) {
            MavenProject mavenProject = mavenProjectsManager.findProject(moduleBuildTask.getModule());
            if (mavenProject == null) continue;
            buildOnlyResources = buildOnlyResources || moduleBuildTask instanceof ModuleResourcesBuildTask;
            MavenProject rootProject = mavenProjectsManager.findRootProject(mavenProject);
            rootProjectsToModules.computeIfAbsent(rootProject, p -> new ArrayList()).add(mavenProject);
        }
        boolean clean = moduleBuildTasks.stream().anyMatch(task -> !(task instanceof ModuleFilesBuildTask) && !task.isIncrementalBuild());
        boolean bl = moduleBuildTasks.stream().allMatch(task -> task instanceof ModuleFilesBuildTask);
        boolean includeDependentModules = moduleBuildTasks.stream().anyMatch(ModuleBuildTask::isIncludeDependentModules);
        String goal = MavenProjectTaskRunner.getGoal(buildOnlyResources, bl);
        ArrayList<MavenRunnerParameters> commands = new ArrayList<MavenRunnerParameters>();
        for (Map.Entry entry : rootProjectsToModules.entrySet()) {
            ParametersList parameters = new ParametersList();
            if (clean) {
                parameters.add("clean");
            }
            parameters.add(goal);
            List mavenProjects = (List)entry.getValue();
            if (!includeDependentModules) {
                if (mavenProjects.size() > 1) {
                    parameters.add("--projects");
                    parameters.add(mavenProjects.stream().map(MavenProject::getMavenId).map(mavenId -> mavenId.getGroupId() + ":" + mavenId.getArtifactId()).collect(Collectors.joining(",")));
                } else {
                    parameters.add("--non-recursive");
                }
            }
            VirtualFile pomFile = (mavenProjects.size() > 1 ? (MavenProject)entry.getKey() : (MavenProject)mavenProjects.get(0)).getFile();
            commands.add(new MavenRunnerParameters(true, pomFile.getParent().getPath(), pomFile.getName(), parameters.getList(), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles()));
        }
        MavenProjectTaskRunner.runBatch(project, mavenRunner, "Maven Build", commands, callback);
    }

    @NotNull
    private static String getGoal(boolean buildOnlyResources, boolean compileOnly) {
        if (buildOnlyResources) {
            if ("resources:resources" == null) {
                MavenProjectTaskRunner.$$$reportNull$$$0(10);
            }
            return "resources:resources";
        }
        String string = compileOnly ? "compile" : "install";
        if (string == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static void runBatch(@NotNull Project project, final @NotNull MavenRunner mavenRunner, @NotNull String title, final @NotNull List<MavenRunnerParameters> commands, final @Nullable ProjectTaskNotification callback) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(12);
        }
        if (mavenRunner == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(13);
        }
        if (title == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(14);
        }
        if (commands == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            final AtomicInteger errors = new AtomicInteger();
            final AtomicInteger warnings = new AtomicInteger();
            final MavenConsole console = MavenConsole.createGuiMavenConsole(project, title, project.getBasePath(), ToolWindowId.BUILD, 0L);
            console.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.processTerminated(event);
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    Matcher warningMatcher;
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    String line = event.getText();
                    Matcher errorsMatcher = ERRORS_NUMBER_PATTERN.matcher(line);
                    if (errorsMatcher.matches()) {
                        try {
                            errors.addAndGet(Integer.parseInt(errorsMatcher.group(1)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((warningMatcher = WARNING_PATTERN.matcher(line)).find()) {
                        warnings.incrementAndGet();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            FileDocumentManager.getInstance().saveAllDocuments();
            new Task.Backgroundable(project, TasksBundle.message("maven.tasks.executing", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    mavenRunner.runBatch(commands, null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), indicator, console);
                }

                public boolean shouldStartInBackground() {
                    return mavenRunner.getSettings().isRunMavenInBackground();
                }

                public void processSentToBackground() {
                    mavenRunner.getSettings().setRunMavenInBackground(true);
                }

                public void onCancel() {
                    if (callback != null) {
                        callback.finished(new ProjectTaskResult(true, errors.get(), warnings.get()));
                    }
                }

                public void onSuccess() {
                    if (callback != null) {
                        callback.finished(new ProjectTaskResult(false, errors.get(), warnings.get()));
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (callback != null) {
                        callback.finished(new ProjectTaskResult(false, errors.get(), warnings.get()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        });
    }

    private static void buildModuleFiles(@NotNull Project project, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ModuleFilesBuildTask> moduleFilesBuildTasks) {
        if (project == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(16);
        }
        if (moduleFilesBuildTasks == null) {
            MavenProjectTaskRunner.$$$reportNull$$$0(17);
        }
        MavenProjectTaskRunner.buildModules(project, callback, moduleFilesBuildTasks);
    }

    private static void buildArtifacts(Project project, ProjectTaskNotification callback, List<? extends ProjectModelBuildTask> tasks) {
        for (ProjectModelBuildTask projectModelBuildTask : tasks) {
            if (!(projectModelBuildTask.getBuildableElement() instanceof Artifact)) continue;
            for (MavenArtifactBuilder artifactBuilder : (MavenArtifactBuilder[])MavenArtifactBuilder.EP_NAME.getExtensions()) {
                if (!artifactBuilder.isApplicable(projectModelBuildTask)) continue;
                artifactBuilder.build(project, projectModelBuildTask, callback);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuildTasks";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenRunner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilesBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/build/MavenProjectTaskRunner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildModules";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runBatch";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

