/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.Compressor;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.artifactResolver.MavenArtifactResolvedM31RtMarker;
import org.jetbrains.idea.maven.artifactResolver.MavenArtifactResolvedM3RtMarker;
import org.jetbrains.idea.maven.artifactResolver.common.MavenModuleMap;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenExternalParameters {
    private static final Logger LOG = Logger.getInstance(MavenExternalParameters.class);
    public static final String MAVEN_LAUNCHER_CLASS = "org.codehaus.classworlds.Launcher";
    @NonNls
    private static final String MAVEN_OPTS = "MAVEN_OPTS";

    @Deprecated
    public static JavaParameters createJavaParameters(@Nullable Project project, @NotNull MavenRunnerParameters parameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings) throws ExecutionException {
        if (parameters == null) {
            MavenExternalParameters.$$$reportNull$$$0(0);
        }
        return MavenExternalParameters.createJavaParameters(project, parameters, coreSettings, runnerSettings, null);
    }

    public static JavaParameters createJavaParameters(@Nullable Project project, @NotNull MavenRunnerParameters parameters) throws ExecutionException {
        if (parameters == null) {
            MavenExternalParameters.$$$reportNull$$$0(1);
        }
        return MavenExternalParameters.createJavaParameters(project, parameters, null, null, null);
    }

    public static JavaParameters createJavaParameters(@Nullable Project project, @NotNull MavenRunnerParameters parameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable MavenRunConfiguration runConfiguration) throws ExecutionException {
        if (parameters == null) {
            MavenExternalParameters.$$$reportNull$$$0(2);
        }
        JavaParameters params = new JavaParameters();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (coreSettings == null) {
            MavenGeneralSettings mavenGeneralSettings = coreSettings = project == null ? new MavenGeneralSettings() : MavenProjectsManager.getInstance(project).getGeneralSettings();
        }
        if (runnerSettings == null) {
            runnerSettings = project == null ? new MavenRunnerSettings() : MavenRunner.getInstance(project).getState();
        }
        params.setWorkingDirectory(parameters.getWorkingDirFile());
        Sdk jdk = MavenExternalParameters.getJdk(project, runnerSettings, project != null && MavenRunner.getInstance(project).getState() == runnerSettings);
        params.setJdk(jdk);
        String mavenHome = MavenExternalParameters.resolveMavenHome(coreSettings, project, runConfiguration);
        String mavenVersion = MavenUtil.getMavenVersion(mavenHome);
        String sdkConfigLocation = "Settings | Build, Execution, Deployment | Build Tools | Maven | Runner | JRE";
        MavenServerManager.verifyMavenSdkRequirements(jdk, mavenVersion, sdkConfigLocation);
        params.getProgramParametersList().addProperty("idea.version" + MavenUtil.getIdeaVersionToPassToMavenProcess());
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.3") >= 0) {
            params.getVMParametersList().addProperty("maven.multiModuleProjectDirectory", MavenServerUtil.findMavenBasedir((File)parameters.getWorkingDirFile()).getPath());
        }
        MavenExternalParameters.addVMParameters(params.getVMParametersList(), mavenHome, runnerSettings);
        File confFile = MavenUtil.getMavenConfFile(new File(mavenHome));
        if (!confFile.isFile()) {
            throw new ExecutionException("Configuration file is not exists in maven home: " + confFile.getAbsolutePath());
        }
        if (project != null && parameters.isResolveToWorkspace()) {
            try {
                String resolverJar = MavenExternalParameters.getArtifactResolverJar(mavenVersion);
                confFile = MavenExternalParameters.patchConfFile(confFile, resolverJar);
                File modulesPathsFile = MavenExternalParameters.dumpModulesPaths(project);
                params.getVMParametersList().addProperty("idea.modules.paths.file", modulesPathsFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                throw new ExecutionException("Failed to run maven configuration", (Throwable)e);
            }
        }
        params.getVMParametersList().addProperty("classworlds.conf", confFile.getPath());
        for (String path : MavenExternalParameters.getMavenClasspathEntries(mavenHome)) {
            params.getClassPath().add(path);
        }
        params.setEnv(new HashMap<String, String>(runnerSettings.getEnvironmentProperties()));
        params.setPassParentEnvs(runnerSettings.isPassParentEnv());
        params.setMainClass(MAVEN_LAUNCHER_CLASS);
        EncodingManager encodingManager = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        params.setCharset(encodingManager.getDefaultCharset());
        MavenExternalParameters.addMavenParameters(params.getProgramParametersList(), mavenHome, coreSettings, runnerSettings, parameters);
        return params;
    }

    private static File patchConfFile(File conf, String library) throws IOException {
        File tmpConf = FileUtil.createTempFile((String)"idea-", (String)"-mvn.conf");
        tmpConf.deleteOnExit();
        MavenExternalParameters.patchConfFile(conf, tmpConf, library);
        return tmpConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchConfFile(File originalConf, File dest, String library) throws IOException {
        try (Scanner sc = new Scanner(originalConf);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dest)));){
            boolean patched = false;
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                out.append(line);
                out.newLine();
                if (patched || !"[plexus.core]".equals(line)) continue;
                out.append("load ").append(library);
                out.newLine();
                patched = true;
            }
        }
    }

    private static String getArtifactResolverJar(@Nullable String mavenVersion) throws IOException {
        Class marker;
        if (mavenVersion != null && mavenVersion.compareTo("3.1.0") >= 0) {
            marker = MavenArtifactResolvedM31RtMarker.class;
        } else if (mavenVersion != null && mavenVersion.compareTo("3.0.0") >= 0) {
            marker = MavenArtifactResolvedM3RtMarker.class;
        } else {
            try {
                marker = Class.forName("org.jetbrains.idea.maven.artifactResolver.MavenArtifactResolvedM2RtMarker");
            }
            catch (ClassNotFoundException e) {
                LOG.error("Cannot find Maven2 artifact resolved, falling back to Maven3", (Throwable)e);
                marker = MavenArtifactResolvedM3RtMarker.class;
            }
        }
        File classDirOrJar = new File(PathUtil.getJarPathForClass(marker));
        if (!classDirOrJar.isDirectory()) {
            return classDirOrJar.getAbsolutePath();
        }
        File tempFile = FileUtil.createTempFile((String)"idea-", (String)"-artifactResolver.jar", (boolean)true);
        try (Compressor.Zip zip = new Compressor.Zip(tempFile);){
            zip.addDirectory(classDirOrJar);
            String m2Module = PathUtil.getJarPathForClass(MavenModuleMap.class);
            String commonClassesPath = MavenModuleMap.class.getPackage().getName().replace('.', '/');
            zip.addDirectory(commonClassesPath, new File(m2Module, commonClassesPath));
        }
        return tempFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File dumpModulesPaths(@NotNull Project project) throws IOException {
        if (project == null) {
            MavenExternalParameters.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Properties res = new Properties();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            MavenProject mavenProject;
            if (!manager.isMavenizedModule(module) || (mavenProject = manager.findProject(module)) == null || manager.isIgnored(mavenProject)) continue;
            res.setProperty(mavenProject.getMavenId().getGroupId() + ':' + mavenProject.getMavenId().getArtifactId() + ":pom" + ':' + mavenProject.getMavenId().getVersion(), mavenProject.getFile().getPath());
            res.setProperty(mavenProject.getMavenId().getGroupId() + ':' + mavenProject.getMavenId().getArtifactId() + ':' + mavenProject.getPackaging() + ':' + mavenProject.getMavenId().getVersion(), mavenProject.getOutputDirectory());
            res.setProperty(mavenProject.getMavenId().getGroupId() + ':' + mavenProject.getMavenId().getArtifactId() + ":test-jar" + ':' + mavenProject.getMavenId().getVersion(), mavenProject.getTestOutputDirectory());
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "sources");
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "test-sources");
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "javadoc");
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "test-javadoc");
        }
        File file = new File(PathManager.getSystemPath(), "Maven/idea-projects-state-" + project.getLocationHash() + ".properties");
        FileUtil.ensureExists((File)file.getParentFile());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            res.store(out, null);
        }
        return file;
    }

    private static void addArtifactFileMapping(@NotNull Properties res, @NotNull MavenProject mavenProject, @NotNull String classifier) {
        File file;
        if (res == null) {
            MavenExternalParameters.$$$reportNull$$$0(4);
        }
        if (mavenProject == null) {
            MavenExternalParameters.$$$reportNull$$$0(5);
        }
        if (classifier == null) {
            MavenExternalParameters.$$$reportNull$$$0(6);
        }
        if ((file = new File(mavenProject.getBuildDirectory(), mavenProject.getFinalName() + '-' + classifier + ".jar")).exists()) {
            res.setProperty(mavenProject.getMavenId().getGroupId() + ':' + mavenProject.getMavenId().getArtifactId() + ':' + classifier + ':' + mavenProject.getMavenId().getVersion(), file.getPath());
        }
    }

    @NotNull
    private static Sdk getJdk(@Nullable Project project, MavenRunnerSettings runnerSettings, boolean isGlobalRunnerSettings) throws ExecutionException {
        String name = runnerSettings.getJreName();
        if (name.equals("#JAVA_INTERNAL")) {
            Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            if (sdk == null) {
                MavenExternalParameters.$$$reportNull$$$0(7);
            }
            return sdk;
        }
        if (name.equals("#USE_PROJECT_JDK")) {
            if (project != null) {
                Module[] modules;
                Sdk res = ProjectRootManager.getInstance((Project)project).getProjectSdk();
                if (res != null) {
                    Sdk sdk = res;
                    if (sdk == null) {
                        MavenExternalParameters.$$$reportNull$$$0(8);
                    }
                    return sdk;
                }
                for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                    Sdk sdk2 = sdk;
                    if (sdk2 == null) {
                        MavenExternalParameters.$$$reportNull$$$0(9);
                    }
                    return sdk2;
                }
            }
            if (project == null) {
                Sdk recent = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
                if (recent != null) {
                    Sdk sdk = recent;
                    if (sdk == null) {
                        MavenExternalParameters.$$$reportNull$$$0(10);
                    }
                    return sdk;
                }
                Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
                if (sdk == null) {
                    MavenExternalParameters.$$$reportNull$$$0(11);
                }
                return sdk;
            }
            throw new ProjectJdkSettingsOpenerExecutionException("Project JDK is not specified. <a href=''>Configure</a>", project);
        }
        if (name.equals("#JAVA_HOME")) {
            String javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new ExecutionException(RunnerBundle.message("maven.java.home.undefined", new Object[0]));
            }
            Sdk sdk = JavaSdk.getInstance().createJdk("", javaHome);
            if (sdk == null) {
                MavenExternalParameters.$$$reportNull$$$0(12);
            }
            return sdk;
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!projectJdk.getName().equals(name)) continue;
            Sdk sdk = projectJdk;
            if (sdk == null) {
                MavenExternalParameters.$$$reportNull$$$0(13);
            }
            return sdk;
        }
        if (isGlobalRunnerSettings) {
            throw new ExecutionException(RunnerBundle.message("maven.java.not.found.default.config", name));
        }
        throw new ExecutionException(RunnerBundle.message("maven.java.not.found", name));
    }

    public static void addVMParameters(ParametersList parametersList, String mavenHome, MavenRunnerSettings runnerSettings) {
        parametersList.addParametersString(System.getenv(MAVEN_OPTS));
        parametersList.addParametersString(runnerSettings.getVmOptions());
        parametersList.addProperty("maven.home", mavenHome);
    }

    private static void addMavenParameters(ParametersList parametersList, String mavenHome, MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings, MavenRunnerParameters parameters) {
        MavenExternalParameters.encodeCoreAndRunnerSettings(coreSettings, mavenHome, parametersList);
        if (runnerSettings.isSkipTests()) {
            parametersList.addProperty("skipTests", "true");
        }
        for (Map.Entry<String, String> entry : runnerSettings.getMavenProperties().entrySet()) {
            if (entry.getKey().length() <= 0) continue;
            parametersList.addProperty(entry.getKey(), entry.getValue());
        }
        for (String goal : parameters.getGoals()) {
            parametersList.add(goal);
        }
        if (parameters.getPomFileName() != null && !FileUtil.namesEqual((String)"pom.xml", (String)parameters.getPomFileName())) {
            parametersList.add("-f");
            parametersList.add(parameters.getPomFileName());
        }
        MavenExternalParameters.addOption(parametersList, "P", MavenExternalParameters.encodeProfiles(parameters.getProfilesMap()));
    }

    private static void addOption(ParametersList cmdList, @NonNls String key, @NonNls String value) {
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            cmdList.add("-" + key);
            cmdList.add(value);
        }
    }

    @NotNull
    public static String resolveMavenHome(@NotNull MavenGeneralSettings coreSettings) throws ExecutionException {
        if (coreSettings == null) {
            MavenExternalParameters.$$$reportNull$$$0(14);
        }
        String string = MavenExternalParameters.resolveMavenHome(coreSettings, null, null);
        if (string == null) {
            MavenExternalParameters.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String resolveMavenHome(@NotNull MavenGeneralSettings coreSettings, @Nullable Project project, @Nullable MavenRunConfiguration runConfiguration) throws ExecutionException {
        String string;
        File file;
        if (coreSettings == null) {
            MavenExternalParameters.$$$reportNull$$$0(16);
        }
        if ((file = MavenUtil.resolveMavenHomeDirectory(coreSettings.getMavenHome())) == null) {
            throw MavenExternalParameters.createExecutionException(RunnerBundle.message("external.maven.home.no.default", new Object[0]), RunnerBundle.message("external.maven.home.no.default.with.fix", new Object[0]), coreSettings, project, runConfiguration);
        }
        if (!file.exists()) {
            throw MavenExternalParameters.createExecutionException(RunnerBundle.message("external.maven.home.does.not.exist", file.getPath()), RunnerBundle.message("external.maven.home.does.not.exist.with.fix", file.getPath()), coreSettings, project, runConfiguration);
        }
        if (!MavenUtil.isValidMavenHome(file)) {
            throw MavenExternalParameters.createExecutionException(RunnerBundle.message("external.maven.home.invalid", file.getPath()), RunnerBundle.message("external.maven.home.invalid.with.fix", file.getPath()), coreSettings, project, runConfiguration);
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        if (string == null) {
            MavenExternalParameters.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static ExecutionException createExecutionException(String text, String textWithFix, @NotNull MavenGeneralSettings coreSettings, @Nullable Project project, @Nullable MavenRunConfiguration runConfiguration) {
        Project runCfgProject;
        Project notNullProject;
        if (coreSettings == null) {
            MavenExternalParameters.$$$reportNull$$$0(18);
        }
        if ((notNullProject = project) == null) {
            if (runConfiguration == null) {
                return new ExecutionException(text);
            }
            notNullProject = runConfiguration.getProject();
            if (notNullProject == null) {
                return new ExecutionException(text);
            }
        }
        if (coreSettings == MavenProjectsManager.getInstance(notNullProject).getGeneralSettings()) {
            return new ProjectSettingsOpenerExecutionException(textWithFix, notNullProject);
        }
        if (runConfiguration != null && (runCfgProject = runConfiguration.getProject()) != null && ((RunManagerImpl)RunManager.getInstance((Project)runCfgProject)).getSettings((RunConfiguration)runConfiguration) != null) {
            return new RunConfigurationOpenerExecutionException(textWithFix, runConfiguration);
        }
        return new ExecutionException(text);
    }

    private static List<String> getMavenClasspathEntries(String mavenHome) {
        File mavenHomeBootAsFile = new File(new File(mavenHome, "core"), "boot");
        if (!mavenHomeBootAsFile.exists()) {
            mavenHomeBootAsFile = new File(mavenHome, "boot");
        }
        ArrayList<String> classpathEntries = new ArrayList<String>();
        File[] files = mavenHomeBootAsFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().contains("classworlds")) continue;
                classpathEntries.add(file.getAbsolutePath());
            }
        }
        return classpathEntries;
    }

    private static void encodeCoreAndRunnerSettings(MavenGeneralSettings coreSettings, String mavenHome, ParametersList cmdList) {
        boolean atLeastMaven3;
        if (coreSettings.isWorkOffline()) {
            cmdList.add("--offline");
        }
        if (!(atLeastMaven3 = MavenUtil.isMaven3(mavenHome))) {
            MavenExternalParameters.addIfNotEmpty(cmdList, coreSettings.getPluginUpdatePolicy().getCommandLineOption());
            if (!coreSettings.isUsePluginRegistry()) {
                cmdList.add("--no-plugin-registry");
            }
        }
        if (coreSettings.getOutputLevel() == MavenExecutionOptions.LoggingLevel.DEBUG) {
            cmdList.add("--debug");
        }
        if (coreSettings.isNonRecursive()) {
            cmdList.add("--non-recursive");
        }
        if (coreSettings.isPrintErrorStackTraces()) {
            cmdList.add("--errors");
        }
        if (coreSettings.isAlwaysUpdateSnapshots()) {
            cmdList.add("--update-snapshots");
        }
        if (StringUtil.isNotEmpty((String)coreSettings.getThreads())) {
            cmdList.add("-T", coreSettings.getThreads());
        }
        MavenExternalParameters.addIfNotEmpty(cmdList, coreSettings.getFailureBehavior().getCommandLineOption());
        MavenExternalParameters.addIfNotEmpty(cmdList, coreSettings.getChecksumPolicy().getCommandLineOption());
        MavenExternalParameters.addOption(cmdList, "s", coreSettings.getUserSettingsFile());
        if (!StringUtil.isEmptyOrSpaces((String)coreSettings.getLocalRepository())) {
            cmdList.addProperty("maven.repo.local", coreSettings.getLocalRepository());
        }
    }

    private static void addIfNotEmpty(ParametersList parametersList, @Nullable String value) {
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            parametersList.add(value);
        }
    }

    private static String encodeProfiles(Map<String, Boolean> profiles) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Boolean> entry : profiles.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            if (!entry.getValue().booleanValue()) {
                stringBuilder.append("!");
            }
            stringBuilder.append(entry.getKey());
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenExternalParameters";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenExternalParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMavenHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dumpModulesPaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addArtifactFileMapping";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveMavenHome";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class WithHyperlinkExecutionException
    extends ExecutionException
    implements HyperlinkListener,
    NotificationListener {
        WithHyperlinkExecutionException(String s) {
            super(s);
        }

        protected abstract void hyperlinkClicked();

        @Override
        public final void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.hyperlinkClicked();
            }
        }

        public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                WithHyperlinkExecutionException.$$$reportNull$$$0(0);
            }
            if (event == null) {
                WithHyperlinkExecutionException.$$$reportNull$$$0(1);
            }
            this.hyperlinkUpdate(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenExternalParameters$WithHyperlinkExecutionException";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunConfigurationOpenerExecutionException
    extends WithHyperlinkExecutionException {
        private final MavenRunConfiguration myRunConfiguration;

        RunConfigurationOpenerExecutionException(String s, MavenRunConfiguration runConfiguration) {
            super(s);
            this.myRunConfiguration = runConfiguration;
        }

        @Override
        protected void hyperlinkClicked() {
            Project project = this.myRunConfiguration.getProject();
            EditConfigurationsDialog dialog = new EditConfigurationsDialog(project);
            dialog.show();
        }
    }

    private static class ProjectJdkSettingsOpenerExecutionException
    extends WithHyperlinkExecutionException {
        private final Project myProject;

        ProjectJdkSettingsOpenerExecutionException(String s, Project project) {
            super(s);
            this.myProject = project;
        }

        @Override
        protected void hyperlinkClicked() {
            ProjectSettingsService.getInstance((Project)this.myProject).openProjectSettings();
        }
    }

    private static class ProjectSettingsOpenerExecutionException
    extends WithHyperlinkExecutionException {
        private final Project myProject;

        ProjectSettingsOpenerExecutionException(String s, Project project) {
            super(s);
            this.myProject = project;
        }

        @Override
        protected void hyperlinkClicked() {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, "Maven");
        }
    }
}

