/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class ZipUtils {
    private static final int CENTRAL_DIRECTORY_FILE_HEADER_MAGIC = 33639248;
    private static final int CENTRAL_DIRECTORY_FILE_HEADER_SIZE = 46;
    private static final String DIGEST_ALGORITHM = "SHA-1";

    public static HashMap<String, Long> readCrcs(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        return ZipUtils.readCrcs(buffer);
    }

    public static HashMap<String, Long> readCrcs(ByteBuffer buf) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        HashMap<String, Long> crcs = new HashMap<String, Long>();
        while (buf.remaining() >= 46 && buf.getInt() == 33639248) {
            buf.position(buf.position() + 12);
            long crc32 = (long)buf.getInt() & 0xFFFFFFFFL;
            buf.position(buf.position() + 8);
            short pathLength = buf.getShort();
            short extraLength = buf.getShort();
            short commentLength = buf.getShort();
            buf.position(buf.position() + 12);
            String name = new String(buf.array(), buf.position(), (int)pathLength);
            buf.position(buf.position() + pathLength + extraLength + commentLength);
            crcs.put(name, crc32);
        }
        return crcs;
    }

    public static String digest(ByteBuffer buffer) {
        MessageDigest messageDigest;
        if (!buffer.hasArray()) {
            throw new DeployerException("Unable to digest a non array backed ByteBuffer");
        }
        try {
            messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DeployerException("MessageDigest:SHA-1 unavailable.", e);
        }
        byte[] digestBytes = messageDigest.digest(buffer.array());
        return BaseEncoding.base16().lowerCase().encode(digestBytes);
    }
}

