/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDump;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Version;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Installer {
    public static final String INSTALLER_BINARY_NAME = "installer";
    public static final String INSTALLER_DIRECTORY = "/data/local/tmp/.studio/bin";
    public static final String INSTALLER_PATH = "/data/local/tmp/.studio/bin/installer";
    public static final String ANDROID_EXECUTABLE_PATH = "/tools/base/deploy/installer/android";
    private final AdbClient adb;
    private final String installersFolder;

    public Installer(AdbClient adb) {
        this(null, adb);
    }

    public Installer(String installersFolder, AdbClient adb) {
        this.adb = adb;
        this.installersFolder = installersFolder;
    }

    public Map<String, ApkDump> dump(String packageName) throws IOException {
        String[] cmd = this.buildCmd(new String[]{"dump", packageName});
        this.retryShell(cmd, null);
        String remoteDirectory = "/data/local/tmp/.studio/dumps/" + packageName;
        File directory = Files.createTempDirectory(".dumps", new FileAttribute[0]).toFile();
        this.adb.pull(remoteDirectory, directory.toString());
        File packageDumps = new File(directory, packageName);
        HashMap<String, ApkDump> dumps = new HashMap<String, ApkDump>();
        File[] files = packageDumps.listFiles();
        if (files == null) {
            throw new IOException("Cannot list files on " + packageDumps.toString());
        }
        for (File file : files) {
            if (!file.isFile() || !file.isFile() || !file.getName().endsWith(".remotecd")) continue;
            String name = file.getName().replaceFirst("\\.remotecd$", "");
            File signatureFile = new File(file.getParent(), name + ".remoteblock");
            byte[] contentDirectory = Files.readAllBytes(file.toPath());
            byte[] signature = signatureFile.exists() ? Files.readAllBytes(signatureFile.toPath()) : null;
            dumps.put(name, new ApkDump(name, contentDirectory, signature));
        }
        return dumps;
    }

    public void swap(Deploy.SwapRequest request) {
        byte[] data = request.toByteArray();
        String[] cmd = this.buildCmd(new String[]{"swap", String.valueOf(data.length)});
        this.retryShell(cmd, data);
    }

    public void retryShell(String[] cmd, byte[] data) {
        byte[] output = this.adb.shell(cmd, data);
        if (new String(output, Charsets.UTF_8).startsWith("/system/bin/sh: /data/local/tmp/.studio/bin/installer:")) {
            this.prepare();
            this.adb.shell(cmd, data);
        }
    }

    public void prepare() {
        File installerFile = null;
        List<String> abis = this.adb.getAbis();
        for (String abi : abis) {
            String installerJarPath = abi + "/" + INSTALLER_BINARY_NAME;
            try {
                InputStream inputStream = this.getResource(installerJarPath);
                Throwable throwable = null;
                try {
                    if (inputStream == null) continue;
                    System.out.println("Pushed installer '" + installerJarPath + "'");
                    installerFile = File.createTempFile(".studio_installer", abi);
                    Files.copy(inputStream, Paths.get(installerFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new DeployerException("Unable to extract installer binary to push to device.", e);
            }
        }
        if (installerFile == null) {
            throw new DeployerException("Cannot find suitable installer for abis: " + Arrays.toString(abis.toArray()));
        }
        this.adb.shell(new String[]{"mkdir", "-p", INSTALLER_DIRECTORY}, null);
        this.adb.push(installerFile.getAbsolutePath(), INSTALLER_PATH);
        this.adb.shell(new String[]{"chmod", "+x", INSTALLER_PATH}, null);
    }

    InputStream getResource(String path) throws FileNotFoundException {
        InputStream stream = null;
        stream = this.installersFolder == null ? Installer.class.getResourceAsStream("/tools/base/deploy/installer/android/" + path) : new FileInputStream(this.installersFolder + "/" + path);
        return stream;
    }

    private String[] buildCmd(String[] parameters) {
        Object[] base = new String[]{INSTALLER_PATH, "-version=" + Version.hash()};
        return (String[])ObjectArrays.concat((Object[])base, (Object[])parameters, String.class);
    }
}

