/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.deploy.swapper.DexArchiveDatabase;
import com.android.tools.deploy.swapper.InMemoryDexArchiveDatabase;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.InstallerNotifier;
import com.android.tools.deployer.Logger;
import com.android.utils.ILogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class DeployerRunner {
    private static final ILogger LOGGER = Logger.getLogger(DeployerRunner.class);
    private static final String DB_PATH = "/tmp/studio.db";
    private final DexArchiveDatabase db;

    /*
     * Exception decompiling
     */
    static InMemoryDexArchiveDatabase readDB() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void saveDB(InMemoryDexArchiveDatabase db) {
        try (FileOutputStream file = new FileOutputStream(DB_PATH);
             ObjectOutputStream out = new ObjectOutputStream(file);){
            out.writeObject(db);
        }
        catch (IOException e) {
            throw new DeployerException("Unable to save database", e);
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        InMemoryDexArchiveDatabase db = null;
        try {
            db = DeployerRunner.readDB();
            DeployerRunner runner = new DeployerRunner(db);
            runner.run(args);
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.out);
        }
        finally {
            DeployerRunner.saveDB(db);
            AndroidDebugBridge.terminate();
        }
    }

    public DeployerRunner(DexArchiveDatabase db) {
        this.db = db;
    }

    public void run(String[] args) throws IOException {
        if (args.length < 2) {
            DeployerRunner.printUsage();
            return;
        }
        String packageName = args[0];
        ArrayList<String> apks = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            apks.add(args[i]);
        }
        IDevice device = this.getDevice();
        if (device == null) {
            LOGGER.error(null, "%s", new Object[]{"No device found."});
            return;
        }
        AdbClient adb = new AdbClient(device);
        Installer installer = new Installer(adb);
        Deployer deployer = new Deployer(packageName, apks, new InstallerNotifier(), adb, this.db, installer);
        Deployer.RunResponse response = deployer.fullSwap();
        if (response.status != Deployer.RunResponse.Status.OK) {
            LOGGER.info("%s", new Object[]{response.errorMessage});
            return;
        }
        for (String apkName : response.result.keySet()) {
            Deployer.RunResponse.Analysis analysis = response.result.get(apkName);
            for (String key : analysis.diffs.keySet()) {
                ApkDiffer.ApkEntryStatus status = analysis.diffs.get(key);
                switch (status) {
                    case CREATED: {
                        LOGGER.info("%s has been CREATED.", new Object[]{key});
                        break;
                    }
                    case DELETED: {
                        LOGGER.info("%s has been DELETED.", new Object[]{key});
                        break;
                    }
                    case MODIFIED: {
                        LOGGER.info("%s has been MODIFIED.", new Object[]{key});
                    }
                }
            }
        }
    }

    private IDevice getDevice() {
        AndroidDebugBridge.init((boolean)false);
        AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
        while (!bridge.hasInitialDeviceList()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IDevice[] devices = bridge.getDevices();
        if (devices.length < 1) {
            return null;
        }
        return devices[0];
    }

    private static void printUsage() {
        LOGGER.info("Usage: DeployerRunner packageName [packageBase,packageSplit1,...]", new Object[0]);
    }
}

