/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Logger;
import com.android.tools.deployer.ZipUtils;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ApkFull {
    private static final ILogger LOGGER = Logger.getLogger(ApkFull.class);
    private static final int EOCD_SIGNATURE = 101010256;
    private static final int CD_SIGNATURE = 33639248;
    private static final byte[] SIGNATURE_BLOCK_MAGIC = "APK Sig Block 42".getBytes();
    private final String path;
    private HashMap<String, Long> crcs = null;
    private String digest = null;
    private final ApkArchiveMap map;

    public ApkFull(String apkPath) {
        File file = new File(apkPath);
        this.path = file.getAbsolutePath();
        try (RandomAccessFile raf = new RandomAccessFile(this.path, "r");
             FileChannel fileChannel = raf.getChannel();){
            MappedByteBuffer mmap = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            this.map = this.parse(mmap);
        }
        catch (IOException e) {
            throw new DeployerException("Unable to open apk archive: " + this.path, e);
        }
    }

    public HashMap<String, Long> getCrcs() {
        if (this.crcs != null) {
            return this.crcs;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.path, "r");
            this.crcs = this.readCrcs(raf, this.map);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Unable to retrieve CRCs for apk '%s'.", new Object[]{this.path});
        }
        return this.crcs;
    }

    public String getDigest() {
        if (this.digest != null) {
            return this.digest;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.path, "r");
            this.digest = this.generateDigest(raf, this.map);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Unable to generate digest for apk '%s'.", new Object[]{this.path});
        }
        return this.digest;
    }

    public boolean exists() {
        return Files.exists(Paths.get(this.path, new String[0]), new LinkOption[0]);
    }

    public String getPath() {
        return this.path;
    }

    private ApkArchiveMap parse(ByteBuffer bytes) {
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        ApkArchiveMap map = this.readCentralDirectoryRecord(bytes);
        bytes.position((int)map.cdOffset);
        if (bytes.getInt() != 33639248) {
            throw new DeployerException("Central Directory signature invalid.");
        }
        this.readSignatureBlock(bytes, map);
        return map;
    }

    private void readSignatureBlock(ByteBuffer buffer, ApkArchiveMap map) {
        buffer.position((int)map.cdOffset - SIGNATURE_BLOCK_MAGIC.length);
        byte[] signatureBlockMagicNumber = new byte[SIGNATURE_BLOCK_MAGIC.length];
        buffer.get(signatureBlockMagicNumber);
        if (!Arrays.equals(signatureBlockMagicNumber, SIGNATURE_BLOCK_MAGIC)) {
            return;
        }
        buffer.position(buffer.position() - SIGNATURE_BLOCK_MAGIC.length - 8);
        long lowerSignatureBlockSize = buffer.getLong();
        buffer.position((int)((long)(buffer.position() + 8) - lowerSignatureBlockSize));
        long upperSignatureBlocSize = buffer.getLong();
        if (lowerSignatureBlockSize != upperSignatureBlocSize) {
            return;
        }
        map.signatureBlockOffset = buffer.position() - 8;
        map.signatureBlockSize = lowerSignatureBlockSize;
    }

    private ApkArchiveMap readCentralDirectoryRecord(ByteBuffer buffer) {
        ApkArchiveMap map = new ApkArchiveMap();
        buffer.position(buffer.capacity() - 22);
        while (buffer.getInt() != 101010256) {
            int position = buffer.position() - 4 - 1;
            buffer.position(position);
        }
        map.eocdOffset = buffer.position() - 4;
        map.eocdSize = (long)buffer.capacity() - map.eocdOffset;
        buffer.position(buffer.position() + 8);
        map.cdSize = buffer.getInt();
        map.cdOffset = buffer.getInt();
        return map;
    }

    private HashMap<String, Long> readCrcs(RandomAccessFile randomAccessFile, ApkArchiveMap map) throws IOException {
        byte[] cdContent = new byte[(int)map.cdSize];
        randomAccessFile.seek(map.cdOffset);
        randomAccessFile.readFully(cdContent);
        ByteBuffer buffer = ByteBuffer.wrap(cdContent);
        return ZipUtils.readCrcs(buffer);
    }

    private String generateDigest(RandomAccessFile randomAccessFile, ApkArchiveMap map) throws IOException {
        byte[] sigContent;
        if (map.signatureBlockOffset != -1L) {
            sigContent = new byte[(int)map.signatureBlockSize];
            randomAccessFile.seek(map.signatureBlockOffset);
            randomAccessFile.readFully(sigContent);
        } else {
            sigContent = new byte[(int)map.cdSize];
            randomAccessFile.seek(map.cdOffset);
            randomAccessFile.readFully(sigContent);
        }
        ByteBuffer buffer = ByteBuffer.wrap(sigContent);
        return ZipUtils.digest(buffer);
    }

    public String retrieveOnDeviceName() {
        try {
            ZipFile zipFile = new ZipFile(this.path);
            ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
            InputStream stream = zipFile.getInputStream(manifestEntry);
            String splitValue = this.getSplitValue(stream);
            splitValue = splitValue == null ? "base" : "split_" + splitValue;
            return splitValue + ".apk";
        }
        catch (IOException e) {
            throw new DeployerException("Unable to retrieve on device name for " + this.path, e);
        }
    }

    private String getSplitValue(InputStream decompressedManifest) throws IOException {
        BinaryResourceFile file = BinaryResourceFile.fromInputStream(decompressedManifest);
        List<Chunk> chunks = file.getChunks();
        if (chunks.size() == 0) {
            throw new DeployerException("Invalid APK, empty manifest");
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            throw new DeployerException("APK manifest chunk[0] != XmlChunk");
        }
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        List<Chunk> contentChunks = this.sortByOffset(xmlChunk.getChunks());
        for (Chunk chunk : contentChunks) {
            XmlStartElementChunk startChunk;
            if (!(chunk instanceof XmlStartElementChunk) || !(startChunk = (XmlStartElementChunk)chunk).getName().equals("manifest")) continue;
            for (XmlAttribute attribute : startChunk.getAttributes()) {
                if (!attribute.name().equals("split")) continue;
                return attribute.rawValue();
            }
            return null;
        }
        return null;
    }

    private List<Chunk> sortByOffset(Map<Integer, Chunk> contentChunks) {
        ArrayList offsets = Lists.newArrayList(contentChunks.keySet());
        Collections.sort(offsets);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(offsets.size());
        for (Integer offset : offsets) {
            chunks.add(contentChunks.get(offset));
        }
        return chunks;
    }

    ApkArchiveMap getMap() {
        return this.map;
    }

    public class ApkArchiveMap {
        public static final long UNINITIALIZED = -1L;
        long cdOffset = -1L;
        long cdSize = -1L;
        long signatureBlockOffset = -1L;
        long signatureBlockSize = -1L;
        long eocdOffset = -1L;
        long eocdSize = -1L;
    }
}

