/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ZipUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class ApkDump {
    private final byte[] contentDirectory;
    private final byte[] signature;
    private final String name;
    private String digest = null;
    private HashMap<String, Long> crcs = null;

    public ApkDump(String name, byte[] contentDirectory, byte[] signature) {
        this.name = name;
        this.contentDirectory = contentDirectory;
        this.signature = signature;
    }

    public HashMap<String, Long> getCrcs() {
        if (this.crcs != null) {
            return this.crcs;
        }
        this.crcs = this.readCrcs();
        return this.crcs;
    }

    public String getDigest() {
        if (this.digest != null) {
            return this.digest;
        }
        this.digest = this.generateDigest();
        return this.digest;
    }

    private String generateDigest() {
        byte[] data = this.signature != null ? this.signature : this.contentDirectory;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return ZipUtils.digest(buffer);
    }

    private HashMap<String, Long> readCrcs() {
        ByteBuffer buffer = ByteBuffer.wrap(this.contentDirectory);
        return ZipUtils.readCrcs(buffer);
    }
}

