/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApkDump;
import com.android.tools.deployer.ApkFull;
import com.android.tools.deployer.DeployerException;
import java.util.HashMap;

public class ApkDiffer {
    public HashMap<String, ApkEntryStatus> diff(ApkFull local, ApkDump remote) throws DeployerException {
        HashMap<String, Long> localCrcs = local.getCrcs();
        HashMap<String, Long> remoteCrcs = remote.getCrcs();
        HashMap<String, ApkEntryStatus> diffs = new HashMap<String, ApkEntryStatus>();
        for (String key : localCrcs.keySet()) {
            long localCrc;
            if (!remoteCrcs.containsKey(key)) {
                diffs.put(key, ApkEntryStatus.DELETED);
                continue;
            }
            long remoteCrc = remoteCrcs.get(key);
            if (remoteCrc == (localCrc = localCrcs.get(key).longValue())) continue;
            diffs.put(key, ApkEntryStatus.MODIFIED);
        }
        for (String key : remoteCrcs.keySet()) {
            if (localCrcs.containsKey(key)) continue;
            diffs.put(key, ApkEntryStatus.CREATED);
        }
        return diffs;
    }

    public static enum ApkEntryStatus {
        CREATED,
        MODIFIED,
        DELETED;

    }
}

