/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.swapper.DexArchiveDatabase;
import com.android.tools.deploy.swapper.DexArchiveDatabaseException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SQLiteDexArchiveDatabase
extends DexArchiveDatabase {
    public static final int MAX_DEXFILES_ENTRY = 200;
    private static final String CURRENT_SCHEMA_VERSION_NUMBER = "0.1";
    private final String schemaVersion;
    private Connection connection;

    public SQLiteDexArchiveDatabase(File file) {
        this(file, CURRENT_SCHEMA_VERSION_NUMBER);
    }

    public SQLiteDexArchiveDatabase(File file, String schemaVersionNumber) {
        this.schemaVersion = schemaVersionNumber;
        try {
            Class.forName("org.sqlite.JDBC");
            boolean newFile = !file.exists();
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", file.getPath()));
            if (newFile) {
                this.fillTables();
            } else {
                this.dropOldTables();
            }
            this.executeStatements("PRAGMA foreign_keys=ON;");
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DexArchiveDatabaseException(e);
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DexArchiveDatabaseException(e);
        }
    }

    private void dropOldTables() throws SQLException {
        try (Statement s = this.connection.createStatement();
             ResultSet result = s.executeQuery("SELECT value from metadata WHERE name = \"schema-version\";");){
            String version;
            if (result.next() && (version = result.getString("value")).equals(this.schemaVersion)) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.executeStatements("PRAGMA writable_schema = 1;", "delete from sqlite_master where type in ('table', 'index', 'trigger');", "PRAGMA writable_schema = 0;", "VACUUM;");
        this.fillTables();
    }

    private final void fillTables() throws SQLException {
        this.executeStatements("CREATE TABLE metadata (name VARCHAR(255) UNIQUE NOT NULL, value VARCHAR(255) NOT NULL, PRIMARY KEY (name));", "INSERT INTO metadata (name, value) values (\"schema-version\", \"" + this.schemaVersion + "\");", "CREATE TABLE dexfiles (id INTEGER PRIMARY KEY AUTOINCREMENT, name VARCHAR(255) NOT NULL, checksum LONG NOT NULL);", "CREATE INDEX dexfiles_checksum_index ON dexfiles(checksum);", "CREATE TABLE archives (dexfileId INTEGER, checksum VARCHAR(255), CONSTRAINT fk_archives_dexfileId FOREIGN KEY(dexfileId) REFERENCES dexfiles(id) ON DELETE CASCADE);", "CREATE INDEX archives_checksum_index ON archives(checksum);", "CREATE TABLE classes (dexfileId INTEGER, name TEXT, checksum LONG, CONSTRAINT fk_classes_dexfileId FOREIGN KEY(dexfileId) REFERENCES dexfiles(id) ON DELETE CASCADE);", "CREATE INDEX classes_dexfileId_name_index ON classes(dexfileId);");
    }

    private void flushOldCache() throws SQLException {
        this.executeUpdate("DELETE FROM dexfiles WHERE id < (SELECT * FROM (SELECT id from dexfiles ORDER BY id DESC LIMIT 200) ORDER BY id LIMIT 1);");
    }

    private void executeStatements(String ... statements) throws SQLException {
        Statement s = this.connection.createStatement();
        if (statements.length == 1) {
            s.execute(statements[0]);
        } else {
            for (String statement : statements) {
                s.addBatch(statement);
            }
            s.executeBatch();
        }
        s.close();
    }

    private int executeUpdate(String query) throws SQLException {
        Statement s = this.connection.createStatement();
        int updated = s.executeUpdate(query);
        s.close();
        return updated;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Long> getClassesChecksum(int dexFileIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<DexArchiveDatabase.DexFileEntry> getDexFiles(String archiveChecksum) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getDexFileIndex(long dexFileChecksum) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int addDexFile(long dexFileChecksum, String name) {
        try {
            int updated = this.executeUpdate("INSERT INTO dexfiles(name, checksum) VALUES (\"" + name + "\", " + dexFileChecksum + ");");
            assert (updated == 1);
            int index = this.getDexFileIndex(dexFileChecksum);
            this.flushOldCache();
            return index;
        }
        catch (SQLException e) {
            throw new DexArchiveDatabaseException(e);
        }
    }

    @Override
    public void fillEntriesChecksum(int dexFileIndex, Map<String, Long> classesChecksums) {
        String values = classesChecksums.entrySet().stream().map(e -> String.format("(%d, \"%s\", %d)", dexFileIndex, e.getKey(), e.getValue())).collect(Collectors.joining(","));
        try {
            int updated = this.executeUpdate("INSERT INTO classes (dexfileId, name, checksum) VALUES " + values + ";");
            assert (updated == classesChecksums.size());
            this.flushOldCache();
        }
        catch (SQLException e2) {
            throw new DexArchiveDatabaseException(e2);
        }
    }

    @Override
    public void fillDexFileList(String archiveChecksum, List<Integer> dexFilesIndex) {
        String values = dexFilesIndex.stream().map(e -> String.format("(%d, \"%s\")", e, archiveChecksum)).collect(Collectors.joining(","));
        try {
            int updated = this.executeUpdate("INSERT INTO archives (dexfileId, checksum) VALUES " + values + ";");
            assert (updated == dexFilesIndex.size());
            this.flushOldCache();
        }
        catch (SQLException e2) {
            throw new DexArchiveDatabaseException(e2);
        }
    }
}

