/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.swapper.DexFile;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

public final class OnHostDexFile
extends DexFile {
    private final byte[] code;
    private Map<String, Long> classesChecksum;

    public OnHostDexFile(long checksum, String name, byte[] code) {
        super(checksum, name);
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillChecksumIfNeeded() {
        block8: {
            if (this.classesChecksum != null) {
                return;
            }
            this.classesChecksum = new HashMap<String, Long>();
            try {
                ChecksumGatheringConsumer consumer = new ChecksumGatheringConsumer();
                D8Command.Builder newBuilder = D8Command.builder();
                newBuilder.addDexProgramData(this.code, Origin.unknown());
                newBuilder.setDisableDesugaring(true);
                newBuilder.setProgramConsumer((ProgramConsumer)consumer);
                D8.run((D8Command)((D8Command)newBuilder.build()));
                if (consumer.done) break block8;
                ChecksumGatheringConsumer checksumGatheringConsumer = consumer;
                synchronized (checksumGatheringConsumer) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            catch (CompilationFailedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Map<String, Long> getClasssesChecksum() {
        this.fillChecksumIfNeeded();
        return this.classesChecksum;
    }

    @Override
    public byte[] getCode() {
        return this.code;
    }

    private class ChecksumGatheringConsumer
    implements DexFilePerClassFileConsumer {
        private boolean done = false;

        private ChecksumGatheringConsumer() {
        }

        public synchronized void finished(DiagnosticsHandler handler) {
            this.done = true;
            this.notify();
        }

        public synchronized void accept(String name, byte[] dexData, Set<String> descriptors, DiagnosticsHandler handler) {
            CRC32 crc = new CRC32();
            crc.update(dexData);
            OnHostDexFile.this.classesChecksum.put(name, crc.getValue());
        }
    }
}

