/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.swapper.DexArchiveDatabase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InMemoryDexArchiveDatabase
extends DexArchiveDatabase
implements Serializable {
    private List<InMemoryDexFileEntry> dexFilesTable = new ArrayList<InMemoryDexFileEntry>();
    private Map<Long, Integer> dexFileHashToIndex = new HashMap<Long, Integer>();
    private Map<String, List<Integer>> archiveTable = new HashMap<String, List<Integer>>();

    @Override
    public Map<String, Long> getClassesChecksum(int dexFileIndex) {
        return this.dexFilesTable.get(dexFileIndex).classesChecksum;
    }

    @Override
    public List<DexArchiveDatabase.DexFileEntry> getDexFiles(String archiveChecksum) {
        if (!this.archiveTable.containsKey(archiveChecksum)) {
            return null;
        }
        return this.archiveTable.get(archiveChecksum).stream().map(index -> this.dexFilesTable.get((int)index)).collect(Collectors.toList());
    }

    @Override
    public int addDexFile(long dexFileChecksum, String name) {
        int index = this.dexFilesTable.size();
        this.dexFilesTable.add(new InMemoryDexFileEntry(index, dexFileChecksum, name));
        this.dexFileHashToIndex.put(dexFileChecksum, index);
        return index;
    }

    @Override
    public int getDexFileIndex(long dexFileChecksum) {
        return this.dexFileHashToIndex.get(dexFileChecksum);
    }

    @Override
    public void fillEntriesChecksum(int dexFileIndex, Map<String, Long> classesChecksum) {
        this.dexFilesTable.get(dexFileIndex).classesChecksum.putAll(classesChecksum);
    }

    @Override
    public void fillDexFileList(String archiveChecksum, List<Integer> dexFilesIndex) {
        this.archiveTable.put(archiveChecksum, dexFilesIndex);
    }

    private static final class InMemoryDexFileEntry
    extends DexArchiveDatabase.DexFileEntry
    implements Serializable {
        private final Map<String, Long> classesChecksum = new HashMap<String, Long>();

        public InMemoryDexFileEntry(int index, long checksum, String name) {
            super(index, checksum, name);
        }
    }
}

