/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deploy.swapper;

import com.android.tools.deploy.swapper.DexArchiveDatabase;
import com.android.tools.deploy.swapper.DexFile;
import com.android.tools.deploy.swapper.OnHostDexFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class DexArchive {
    private final String checksum;
    private final Map<String, DexFile> dexFiles;

    public static DexArchive buildFromDatabase(DexArchiveDatabase db, String checksum) {
        return db.retrieveCache(checksum);
    }

    public static DexArchive buildFromHostFileSystem(ZipInputStream zis, String checksum) throws IOException {
        HashMap<String, DexFile> dexFiles = new HashMap<String, DexFile>();
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            if (!entry.getName().endsWith(".dex")) {
                zis.closeEntry();
            } else {
                int len;
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream dexContent = new ByteArrayOutputStream();
                while ((len = zis.read(buffer)) > 0) {
                    dexContent.write(buffer, 0, len);
                }
                byte[] code = dexContent.toByteArray();
                dexFiles.put(entry.getName(), new OnHostDexFile(entry.getCrc(), entry.getName(), code));
                zis.closeEntry();
            }
            entry = zis.getNextEntry();
        }
        zis.close();
        return new DexArchive(checksum, dexFiles);
    }

    public DexArchive(String checksum, Map<String, DexFile> dexFiles) {
        this.checksum = checksum;
        this.dexFiles = dexFiles;
    }

    public Map<String, DexFile> getDexFiles() {
        return this.dexFiles;
    }

    public void cache(DexArchiveDatabase db) {
        Set<Map.Entry<String, DexFile>> entrySet = this.getDexFiles().entrySet();
        ArrayList<Integer> dexFilesIndex = new ArrayList<Integer>(entrySet.size());
        for (Map.Entry<String, DexFile> e : entrySet) {
            dexFilesIndex.add(e.getValue().cache(db));
        }
        db.fillDexFileList(this.checksum, dexFilesIndex);
    }
}

