/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigIntellijNameUtil {
    private static final String IDE_PREFIX = "ij_";
    private static final String GENERIC_PROPERTY_PREFIX = "any_";

    private EditorConfigIntellijNameUtil() {
    }

    public static List<String> toEditorConfigNames(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(1);
        }
        ArrayList names = ContainerUtil.newArrayList();
        CodeStylePropertyAccessor accessor = mapper.getAccessor(propertyName);
        if (accessor.isGenericProperty()) {
            names.add("ij_any_" + propertyName);
        }
        String langPrefix = mapper.getLanguageDomainId() + "_";
        names.add(IDE_PREFIX + langPrefix + propertyName);
        return names;
    }

    @Nullable
    public static String toIntellijName(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String editorConfigName) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(2);
        }
        if (editorConfigName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(3);
        }
        if (mapper.containsProperty(editorConfigName)) {
            return editorConfigName;
        }
        if (editorConfigName.startsWith(IDE_PREFIX)) {
            String withoutSuffix = editorConfigName.substring(IDE_PREFIX.length());
            if (mapper.containsProperty(withoutSuffix)) {
                return withoutSuffix;
            }
            int nextUnderscorePos = withoutSuffix.indexOf(95);
            if (nextUnderscorePos > 0 && nextUnderscorePos < withoutSuffix.length() && editorConfigName.contains(withoutSuffix = withoutSuffix.substring(nextUnderscorePos + 1))) {
                return withoutSuffix;
            }
        }
        return null;
    }

    static String getIdeLangPrefix(@NotNull AbstractCodeStylePropertyMapper mapper) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(4);
        }
        return IDE_PREFIX + mapper.getLanguageDomainId() + "_";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigName";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigIntellijNameUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toEditorConfigNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "toIntellijName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdeLangPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

