/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.EditorConfigStatusUIContributor;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.ParserCallback;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigIndentOptionsProvider
extends FileIndentOptionsProvider {
    public static final String indentSizeKey = "indent_size";
    public static final String continuationSizeKey = "continuation_indent_size";
    public static final String tabWidthKey = "tab_width";
    public static final String indentStyleKey = "indent_style";

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        if (settings == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if (Utils.isFullIntellijSettingsSupport()) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = psiFile.getProject();
        if (project.isDisposed() || !Utils.isEnabled(settings)) {
            return null;
        }
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(project, file, (ParserCallback)EditorConfigNavigationActionsFactory.getInstance(psiFile.getVirtualFile()));
        return EditorConfigIndentOptionsProvider.applyCodeStyleSettings(project, outPairs, file, settings);
    }

    private static CommonCodeStyleSettings.IndentOptions applyCodeStyleSettings(Project project, List<EditorConfig.OutPair> outPairs, VirtualFile file, CodeStyleSettings settings) {
        String indentSize = Utils.configValueForKey(outPairs, indentSizeKey);
        String continuationIndentSize = Utils.configValueForKey(outPairs, continuationSizeKey);
        String tabWidth = Utils.configValueForKey(outPairs, tabWidthKey);
        String indentStyle = Utils.configValueForKey(outPairs, indentStyleKey);
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)settings.getIndentOptions(file.getFileType()).clone();
        if (EditorConfigIndentOptionsProvider.applyIndentOptions(project, indentOptions, indentSize, continuationIndentSize, tabWidth, indentStyle, file.getCanonicalPath())) {
            indentOptions.setOverrideLanguageOptions(true);
            return indentOptions;
        }
        return null;
    }

    private static boolean applyIndentOptions(Project project, CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize, String continuationIndentSize, String tabWidth, String indentStyle, String filePath) {
        boolean changed = false;
        String calculatedIndentSize = EditorConfigIndentOptionsProvider.calculateIndentSize(tabWidth, indentSize, indentOptions);
        String calculatedContinuationSize = EditorConfigIndentOptionsProvider.calculateContinuationIndentSize(calculatedIndentSize, continuationIndentSize);
        String calculatedTabWidth = EditorConfigIndentOptionsProvider.calculateTabWidth(tabWidth, indentSize);
        if (!calculatedIndentSize.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyIndentSize(indentOptions, calculatedIndentSize)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
            }
        }
        if (!calculatedContinuationSize.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyContinuationIndentSize(indentOptions, calculatedContinuationSize)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
            }
        }
        if (!calculatedTabWidth.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyTabWidth(indentOptions, calculatedTabWidth)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedTabWidth, tabWidthKey, filePath);
            }
        }
        if (!indentStyle.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyIndentStyle(indentOptions, indentStyle)) {
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, indentStyle, indentStyleKey, filePath);
            }
        }
        return changed;
    }

    private static String calculateIndentSize(String tabWidth, String indentSize, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (options == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        return indentSize.equals("tab") ? (tabWidth.isEmpty() ? String.valueOf(options.TAB_SIZE) : tabWidth) : indentSize;
    }

    private static String calculateContinuationIndentSize(String indentSize, String continuationIndentSize) {
        return continuationIndentSize.isEmpty() ? indentSize : continuationIndentSize;
    }

    private static String calculateTabWidth(String tabWidth, String indentSize) {
        if (tabWidth.isEmpty() && indentSize.equals("tab")) {
            return "";
        }
        if (tabWidth.isEmpty()) {
            return indentSize;
        }
        return tabWidth;
    }

    private static boolean applyIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize) {
        try {
            indentOptions.INDENT_SIZE = Integer.parseInt(indentSize);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyContinuationIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String continuationIndentSize) {
        try {
            indentOptions.CONTINUATION_INDENT_SIZE = Integer.parseInt(continuationIndentSize);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyTabWidth(CommonCodeStyleSettings.IndentOptions indentOptions, String tabWidth) {
        try {
            indentOptions.TAB_SIZE = Integer.parseInt(tabWidth);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyIndentStyle(CommonCodeStyleSettings.IndentOptions indentOptions, String indentStyle) {
        if (indentStyle.equals("tab") || indentStyle.equals("space")) {
            indentOptions.USE_TAB_CHARACTER = indentStyle.equals("tab");
            return true;
        }
        return false;
    }

    @Nullable
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            EditorConfigIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        return new EditorConfigStatusUIContributor(indentOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateIndentSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentStatusBarUiContributor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

