/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;
import org.jetbrains.plugins.groovy.refactoring.util.AnySupers;

public class GroovyMethodInliner
implements InlineHandler.Inliner {
    private final GrMethod myMethod;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.inline.GroovyMethodInliner");

    public GroovyMethodInliner(GrMethod method) {
        this.myMethod = method;
    }

    @Nullable
    public MultiMap<PsiElement, String> getConflicts(@NotNull PsiReference reference, @NotNull PsiElement referenced) {
        PsiElement element;
        if (reference == null) {
            GroovyMethodInliner.$$$reportNull$$$0(0);
        }
        if (referenced == null) {
            GroovyMethodInliner.$$$reportNull$$$0(1);
        }
        if (!((element = reference.getElement()) instanceof GrExpression) || !(element.getParent() instanceof GrCallExpression)) {
            MultiMap map2 = new MultiMap();
            map2.putValue((Object)element, (Object)GroovyRefactoringBundle.message("cannot.inline.reference.0", element.getText()));
            return map2;
        }
        GrCallExpression call = (GrCallExpression)element.getParent();
        Collection<GroovyInlineMethodUtil.ReferenceExpressionInfo> infos = GroovyInlineMethodUtil.collectReferenceInfo(this.myMethod);
        return GroovyMethodInliner.collectConflicts(call, infos);
    }

    @NotNull
    private static MultiMap<PsiElement, String> collectConflicts(@NotNull GrCallExpression call, @NotNull Collection<GroovyInlineMethodUtil.ReferenceExpressionInfo> infos) {
        if (call == null) {
            GroovyMethodInliner.$$$reportNull$$$0(2);
        }
        if (infos == null) {
            GroovyMethodInliner.$$$reportNull$$$0(3);
        }
        MultiMap conflicts = new MultiMap();
        for (GroovyInlineMethodUtil.ReferenceExpressionInfo info : infos) {
            if (!PsiUtil.isAccessible(call, info.declaration)) {
                String className;
                if (info.declaration instanceof PsiMethod) {
                    className = info.containingClass.getName();
                    String signature = GroovyRefactoringUtil.getMethodSignature((PsiMethod)info.declaration);
                    String name = CommonRefactoringUtil.htmlEmphasize((String)(className + "." + signature));
                    conflicts.putValue((Object)info.declaration, (Object)GroovyRefactoringBundle.message("method.is.not.accessible.form.context.0", name));
                } else if (info.declaration instanceof PsiField && (!(info.declaration instanceof GrField) || ((GrField)info.declaration).getGetters().length <= 0)) {
                    className = info.containingClass.getName();
                    String name = CommonRefactoringUtil.htmlEmphasize((String)(className + "." + info.getPresentation()));
                    conflicts.putValue((Object)info.declaration, (Object)GroovyRefactoringBundle.message("field.is.not.accessible.form.context.0", name));
                }
            }
            AnySupers visitor2 = new AnySupers();
            info.expression.accept(visitor2);
            if (!visitor2.containsSupers()) continue;
            conflicts.putValue((Object)info.expression, (Object)GroovyRefactoringBundle.message("super.reference.is.used", new Object[0]));
        }
        MultiMap multiMap = conflicts;
        if (multiMap == null) {
            GroovyMethodInliner.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    public void inlineUsage(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
        PsiElement element;
        if (usage == null) {
            GroovyMethodInliner.$$$reportNull$$$0(5);
        }
        if (referenced == null) {
            GroovyMethodInliner.$$$reportNull$$$0(6);
        }
        if (!((element = usage.getElement()) instanceof GrExpression) || !(element.getParent() instanceof GrCallExpression)) {
            return;
        }
        Editor editor = GroovyMethodInliner.getCurrentEditorIfApplicable(element);
        GrCallExpression call = (GrCallExpression)element.getParent();
        RangeMarker marker = GroovyMethodInliner.inlineReferenceImpl(call, this.myMethod, GroovyMethodInliner.isOnExpressionOrReturnPlace(call), GroovyInlineMethodUtil.isTailMethodCall(call), editor);
        if (marker != null) {
            Project project = referenced.getProject();
            TextRange range = TextRange.create((Segment)marker);
            GroovyRefactoringUtil.highlightOccurrencesByRanges(project, editor, new TextRange[]{range});
            WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
            if (editor != null) {
                editor.getCaretModel().moveToOffset(marker.getEndOffset());
            }
        }
    }

    @Nullable
    private static Editor getCurrentEditorIfApplicable(@NotNull PsiElement element) {
        Project project;
        Editor editor;
        if (element == null) {
            GroovyMethodInliner.$$$reportNull$$$0(7);
        }
        if ((editor = FileEditorManager.getInstance((Project)(project = element.getProject())).getSelectedTextEditor()) != null && editor.getDocument() == PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) {
            return editor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static RangeMarker inlineReferenceImpl(@NotNull GrCallExpression call, @NotNull GrMethod method, boolean resultOfCallExplicitlyUsed, boolean isTailMethodCall, @Nullable Editor editor) {
        if (call == null) {
            GroovyMethodInliner.$$$reportNull$$$0(8);
        }
        if (method == null) {
            GroovyMethodInliner.$$$reportNull$$$0(9);
        }
        try {
            void var24_34;
            GrStatement[] statements;
            GrExpression element;
            GrExpression replaced;
            GrMethod _method;
            GrExpression result2;
            GrExpression invoked;
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(call.getProject());
            Project project = call.getProject();
            GrVariableDeclaration qualifierDeclaration = null;
            GrReferenceExpression innerQualifier = null;
            GrExpression qualifier = null;
            if (call instanceof GrMethodCallExpression && ((GrMethodCallExpression)call).getInvokedExpression() != null && (invoked = ((GrMethodCallExpression)call).getInvokedExpression()) instanceof GrReferenceExpression && ((GrReferenceExpression)invoked).getQualifierExpression() != null) {
                qualifier = ((GrReferenceExpression)invoked).getQualifierExpression();
                if (PsiUtil.isSuperReference(qualifier)) {
                    qualifier = null;
                } else if (!GroovyInlineMethodUtil.isSimpleReference(qualifier)) {
                    String qualName = GroovyMethodInliner.generateQualifierName(call, method, project, qualifier);
                    qualifier = (GrExpression)PsiUtil.skipParentheses(qualifier, false);
                    qualifierDeclaration = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, qualifier, null, qualName);
                    innerQualifier = (GrReferenceExpression)factory.createExpressionFromText(qualName);
                } else {
                    innerQualifier = (GrReferenceExpression)qualifier;
                }
            }
            if ((result2 = GroovyMethodInliner.getAloneResultExpression(_method = GroovyMethodInliner.prepareNewMethod(call, method, qualifier))) != null) {
                GrExpression expression = call.replaceWithExpression(result2, false);
                TextRange range = expression.getTextRange();
                return editor != null ? editor.getDocument().createRangeMarker(range.getStartOffset(), range.getEndOffset(), true) : null;
            }
            GrMethod newMethod = GroovyMethodInliner.prepareNewMethod(call, method, innerQualifier);
            String resultName = InlineMethodConflictSolver.suggestNewName("result", newMethod, call, new String[0]);
            List<GrStatement> returnStatements = ControlFlowUtils.collectReturns(newMethod.getBlock());
            int returnCount = returnStatements.size();
            PsiType methodType = method.getInferredReturnType();
            GrOpenBlock body = newMethod.getBlock();
            assert (body != null);
            if (resultOfCallExplicitlyUsed && !isTailMethodCall) {
                GrExpression resultExpr = null;
                if (PsiType.VOID.equals((Object)methodType)) {
                    resultExpr = factory.createExpressionFromText("null");
                } else if (returnCount == 1) {
                    GrExpression returnExpression = ControlFlowUtils.extractReturnExpression((GrStatement)returnStatements.iterator().next());
                    if (returnExpression != null) {
                        resultExpr = factory.createExpressionFromText(returnExpression.getText());
                    }
                } else if (returnCount > 1) {
                    resultExpr = factory.createExpressionFromText(resultName);
                }
                if (resultExpr == null) {
                    resultExpr = factory.createExpressionFromText("null");
                }
                replaced = call.replaceWithExpression(resultExpr, false);
            } else {
                replaced = call;
            }
            GrExpression enclosingExpr = GroovyRefactoringUtil.addBlockIntoParent(replaced);
            GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)enclosingExpr, GrVariableDeclarationOwner.class);
            assert (owner != null);
            for (element = enclosingExpr; element != null && element.getParent() != owner; element = element.getParent()) {
            }
            assert (element instanceof GrStatement);
            GrStatement anchor = element;
            if (!resultOfCallExplicitlyUsed) assert (anchor == enclosingExpr);
            if (qualifierDeclaration != null) {
                owner.addVariableDeclarationBefore(qualifierDeclaration, anchor);
            }
            if (returnCount > 1 && !PsiType.VOID.equals((Object)methodType) && !isTailMethodCall) {
                Object type2 = methodType != null && methodType.equalsToText("java.lang.Object") ? null : methodType;
                GrVariableDeclaration grVariableDeclaration = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, "", (PsiType)type2, resultName);
                GrStatement statement = ((GrStatementOwner)((Object)owner)).addStatementBefore(grVariableDeclaration, anchor);
                JavaCodeStyleManager.getInstance((Project)statement.getProject()).shortenClassReferences((PsiElement)statement);
                for (GrStatement returnStatement : returnStatements) {
                    GrExpression value = ControlFlowUtils.extractReturnExpression(returnStatement);
                    if (value != null) {
                        GrExpression assignment = factory.createExpressionFromText(resultName + " = " + value.getText());
                        returnStatement.replaceWithStatement(assignment);
                        continue;
                    }
                    returnStatement.replaceWithStatement(factory.createExpressionFromText(resultName + " = null"));
                }
            }
            if (!isTailMethodCall && resultOfCallExplicitlyUsed && returnCount == 1) {
                ((GrStatement)returnStatements.iterator().next()).removeStatement();
            } else if (!isTailMethodCall && (PsiType.VOID.equals((Object)methodType) || returnCount == 1)) {
                for (GrStatement grStatement : returnStatements) {
                    if (grStatement instanceof GrReturnStatement) {
                        GrExpression returnValue = ((GrReturnStatement)grStatement).getReturnValue();
                        if (returnValue != null && GroovyRefactoringUtil.hasSideEffect(returnValue)) {
                            grStatement.replaceWithStatement(returnValue);
                            continue;
                        }
                    } else if (GroovyRefactoringUtil.hasSideEffect(grStatement)) continue;
                    grStatement.removeStatement();
                }
            }
            for (GrStatement statement : statements = body.getStatements()) {
                ((GrStatementOwner)((Object)owner)).addStatementBefore(statement, anchor);
            }
            if (resultOfCallExplicitlyUsed && !isTailMethodCall) {
                TextRange textRange = replaced.getTextRange();
                RangeMarker marker = editor != null ? editor.getDocument().createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset(), true) : null;
                GroovyMethodInliner.reformatOwner(owner);
                return marker;
            }
            if (isTailMethodCall && enclosingExpr.getParent() instanceof GrReturnStatement) {
                GrReturnStatement grReturnStatement = (GrReturnStatement)enclosingExpr.getParent();
            } else {
                GrExpression grExpression = enclosingExpr;
            }
            var24_34.removeStatement();
            GroovyMethodInliner.reformatOwner(owner);
            return null;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static String generateQualifierName(@NotNull GrCallExpression call, @Nullable GrMethod method, final @NotNull Project project, @NotNull GrExpression qualifier) {
        if (call == null) {
            GroovyMethodInliner.$$$reportNull$$$0(10);
        }
        if (project == null) {
            GroovyMethodInliner.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            GroovyMethodInliner.$$$reportNull$$$0(12);
        }
        String[] possibleNames = GroovyNameSuggestionUtil.suggestVariableNames(qualifier, new NameValidator(){

            @Override
            public String validateName(String name, boolean increaseNumber) {
                return name;
            }

            @Override
            public Project getProject() {
                return project;
            }
        });
        String qualName = possibleNames[0];
        String string = qualName = InlineMethodConflictSolver.suggestNewName(qualName, method, call, new String[0]);
        if (string == null) {
            GroovyMethodInliner.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void reformatOwner(@Nullable GrVariableDeclarationOwner owner) throws IncorrectOperationException {
        if (owner == null) {
            return;
        }
        PsiFile file = owner.getContainingFile();
        Project project = file.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        if (document != null) {
            manager.doPostponedOperationsAndUnblockDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, owner.getTextRange());
        }
    }

    @NotNull
    private static GrMethod prepareNewMethod(@NotNull GrCallExpression call, @NotNull GrMethod method, @Nullable GrExpression qualifier) throws IncorrectOperationException {
        if (call == null) {
            GroovyMethodInliner.$$$reportNull$$$0(14);
        }
        if (method == null) {
            GroovyMethodInliner.$$$reportNull$$$0(15);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        if (method instanceof GrReflectedMethod) {
            method = ((GrReflectedMethod)method).getBaseMethod();
        }
        GrMethod newMethod = factory.createMethodFromText(method.getText(), call);
        if (qualifier != null) {
            Collection<GroovyInlineMethodUtil.ReferenceExpressionInfo> infos = GroovyInlineMethodUtil.collectReferenceInfo(method);
            GroovyInlineMethodUtil.addQualifiersToInnerReferences(newMethod, infos, qualifier);
        }
        ArrayList<PsiNamedElement> innerDefinitions = new ArrayList<PsiNamedElement>();
        GroovyMethodInliner.collectInnerDefinitions(newMethod.getBlock(), innerDefinitions);
        for (PsiNamedElement namedElement : innerDefinitions) {
            String newName;
            String name = namedElement.getName();
            if (name == null || (newName = qualifier instanceof GrReferenceExpression ? InlineMethodConflictSolver.suggestNewName(name, method, call, ((GrReferenceExpression)qualifier).getReferenceName()) : InlineMethodConflictSolver.suggestNewName(name, method, call, new String[0])).equals(namedElement.getName())) continue;
            Collection refs = ReferencesSearch.search((PsiElement)namedElement).findAll();
            for (PsiReference ref : refs) {
                PsiElement element = ref.getElement();
                if (!(element instanceof GrReferenceExpression)) continue;
                GrExpression newExpr = factory.createExpressionFromText(newName);
                ((GrReferenceExpression)element).replaceWithExpression(newExpr, false);
            }
            namedElement.setName(newName);
        }
        GroovyInlineMethodUtil.replaceParametersWithArguments(call, newMethod);
        GrMethod grMethod = newMethod;
        if (grMethod == null) {
            GroovyMethodInliner.$$$reportNull$$$0(16);
        }
        return grMethod;
    }

    private static void collectInnerDefinitions(@Nullable PsiElement element, ArrayList<PsiNamedElement> defintions) {
        if (element == null) {
            return;
        }
        for (PsiElement child : element.getChildren()) {
            if (child instanceof GrVariable && !(child instanceof GrParameter)) {
                defintions.add((PsiNamedElement)((GrVariable)child));
            }
            if (child instanceof GrClosableBlock) continue;
            GroovyMethodInliner.collectInnerDefinitions(child, defintions);
        }
    }

    @Nullable
    static GrExpression getAloneResultExpression(@NotNull GrMethod method) {
        if (method == null) {
            GroovyMethodInliner.$$$reportNull$$$0(17);
        }
        GrOpenBlock body = method.getBlock();
        assert (body != null);
        GrStatement[] statements = body.getStatements();
        if (statements.length == 1) {
            if (statements[0] instanceof GrExpression) {
                return (GrExpression)statements[0];
            }
            if (statements[0] instanceof GrReturnStatement) {
                GrExpression value = ((GrReturnStatement)statements[0]).getReturnValue();
                if (value == null && !PsiType.VOID.equals((Object)PsiUtil.getSmartReturnType(method))) {
                    return GroovyPsiElementFactory.getInstance(method.getProject()).createExpressionFromText("null");
                }
                return value;
            }
        }
        return null;
    }

    private static boolean isOnExpressionOrReturnPlace(@NotNull GrCallExpression call) {
        PsiElement parent2;
        if (call == null) {
            GroovyMethodInliner.$$$reportNull$$$0(18);
        }
        if (!((parent2 = call.getParent()) instanceof GrVariableDeclarationOwner)) {
            return true;
        }
        GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)parent2;
        if (owner instanceof GrClosableBlock || owner instanceof GrOpenBlock && owner.getParent() instanceof GrMethod) {
            GrStatement[] statements = ((GrCodeBlock)owner).getStatements();
            assert (statements.length > 0);
            GrStatement last = statements[statements.length - 1];
            if (last == call) {
                return true;
            }
            if (last instanceof GrReturnStatement && call == ((GrReturnStatement)last).getReturnValue()) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyMethodInliner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/inline/GroovyMethodInliner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectConflicts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "generateQualifierName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareNewMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConflicts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectConflicts";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inlineUsage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorIfApplicable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inlineReferenceImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateQualifierName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareNewMethod";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAloneResultExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isOnExpressionOrReturnPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

