/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class InitialInfo
implements ExtractInfoHelper {
    private final ParameterInfo[] myParameterInfos;
    private final VariableInfo[] myOutputNames;
    private final PsiType myOutputType;
    private final PsiElement[] myInnerElements;
    private final Project myProject;
    private final GrStatement[] myStatements;
    private final boolean myHasReturnValue;
    private final String[] myArgumentNames;
    private final StringPartInfo myStringPartInfo;
    private final GrVariable myVariable;

    public InitialInfo(VariableInfo[] inputInfos, VariableInfo[] outputInfos, PsiElement[] innerElements, GrStatement[] statements, ArrayList<GrStatement> returnStatements, StringPartInfo stringPartInfo, Project project, GrVariable variable) {
        this.myInnerElements = innerElements;
        this.myStatements = statements;
        this.myOutputNames = outputInfos;
        this.myStringPartInfo = stringPartInfo;
        this.myVariable = variable;
        boolean bl = this.myHasReturnValue = ContainerUtil.find(returnStatements, statement -> statement instanceof GrReturnStatement && ((GrReturnStatement)statement).getReturnValue() != null) != null;
        assert (this.myStringPartInfo != null || this.myStatements.length > 0);
        this.myProject = project;
        this.myParameterInfos = new ParameterInfo[inputInfos.length];
        this.myArgumentNames = new String[inputInfos.length];
        for (int i = 0; i < inputInfos.length; ++i) {
            VariableInfo info = inputInfos[i];
            PsiType type2 = info.getType();
            this.myParameterInfos[i] = new ParameterInfo(info.getName(), i, type2);
            this.myArgumentNames[i] = info.getName();
        }
        PsiType outputType = this.inferOutputType(outputInfos, statements, returnStatements, this.myHasReturnValue, stringPartInfo);
        this.myOutputType = outputType != null ? outputType : PsiType.VOID;
    }

    @Nullable
    private PsiType inferOutputType(VariableInfo[] outputInfos, GrStatement[] statements, ArrayList<GrStatement> returnStatements, boolean hasReturnValue, StringPartInfo stringPartInfo) {
        if (stringPartInfo != null) {
            return stringPartInfo.getLiteral().getType();
        }
        PsiPrimitiveType outputType = PsiType.VOID;
        if (outputInfos.length > 0) {
            outputType = outputInfos.length == 1 ? outputInfos[0].getType() : JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeFromText("java.util.List", this.getContext());
        } else if (ExtractUtil.isSingleExpression(statements)) {
            outputType = ((GrExpression)statements[0]).getType();
        } else if (hasReturnValue) {
            assert (!returnStatements.isEmpty());
            ArrayList<PsiType> types = new ArrayList<PsiType>(returnStatements.size());
            for (GrStatement statement : returnStatements) {
                if (statement instanceof GrReturnStatement) {
                    GrExpression returnValue = ((GrReturnStatement)statement).getReturnValue();
                    if (returnValue == null) continue;
                    types.add(returnValue.getType());
                    continue;
                }
                if (!(statement instanceof GrExpression)) continue;
                types.add(((GrExpression)statement).getType());
            }
            outputType = TypesUtil.getLeastUpperBoundNullable(types, this.getContext().getManager());
        }
        return outputType;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            InitialInfo.$$$reportNull$$$0(0);
        }
        return project;
    }

    @Override
    @NotNull
    public ParameterInfo[] getParameterInfos() {
        if (this.myParameterInfos == null) {
            InitialInfo.$$$reportNull$$$0(1);
        }
        return this.myParameterInfos;
    }

    @Override
    @NotNull
    public VariableInfo[] getOutputVariableInfos() {
        if (this.myOutputNames == null) {
            InitialInfo.$$$reportNull$$$0(2);
        }
        return this.myOutputNames;
    }

    @Override
    @NotNull
    public String[] getArgumentNames() {
        if (this.myArgumentNames == null) {
            InitialInfo.$$$reportNull$$$0(3);
        }
        return this.myArgumentNames;
    }

    @Override
    @NotNull
    public PsiType getOutputType() {
        PsiType psiType = this.myOutputType;
        if (psiType == null) {
            InitialInfo.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiElement[] getInnerElements() {
        if (this.myInnerElements == null) {
            InitialInfo.$$$reportNull$$$0(5);
        }
        return this.myInnerElements;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        if (this.myStatements == null) {
            InitialInfo.$$$reportNull$$$0(6);
        }
        return this.myStatements;
    }

    @Override
    public boolean hasReturnValue() {
        return this.myHasReturnValue;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement getContext() {
        return this.myStatements.length > 0 ? this.myStatements[0] : this.myStringPartInfo.getLiteral();
    }

    @Override
    public boolean isForceReturn() {
        return false;
    }

    @Override
    @Nullable
    public StringPartInfo getStringPartInfo() {
        return this.myStringPartInfo;
    }

    @Override
    @Nullable
    public GrVariable getVar() {
        return this.myVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/refactoring/extract/InitialInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterInfos";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariableInfos";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

