/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GrParameterInfo
implements JavaParameterInfo {
    @NotNull
    private String myName;
    @NotNull
    private String myDefaultValue;
    @NotNull
    private String myDefaultInitializer;
    private final int myPosition;
    @Nullable
    private CanonicalTypes.Type myTypeWrapper;
    private boolean myUseAnySingleVariable;

    public GrParameterInfo(GrParameter parameter, int position) {
        this.myDefaultValue = "";
        this.myDefaultInitializer = "";
        this.myPosition = position;
        this.myName = parameter.getName();
        PsiType type2 = parameter.getDeclaredType();
        this.myTypeWrapper = type2 != null ? CanonicalTypes.createTypeWrapper((PsiType)type2) : (parameter.hasModifierProperty("def") ? CanonicalTypes.createTypeWrapper((PsiType)JavaPsiFacade.getElementFactory((Project)parameter.getProject()).createTypeFromText("def", null)) : null);
        GrExpression defaultInitializer = parameter.getInitializerGroovy();
        if (defaultInitializer != null) {
            this.setInitializer(defaultInitializer.getText());
        }
        this.myUseAnySingleVariable = false;
    }

    public GrParameterInfo(@NotNull String name, @Nullable String defaultValue, @Nullable String defaultInitializer, @Nullable PsiType type2, int position, boolean useAnySingleVariable) {
        if (name == null) {
            GrParameterInfo.$$$reportNull$$$0(0);
        }
        this.myDefaultValue = "";
        this.myDefaultInitializer = "";
        this.myName = name;
        this.myPosition = position;
        this.myUseAnySingleVariable = useAnySingleVariable;
        this.setType(type2);
        this.setDefaultValue(defaultValue);
        this.setInitializer(defaultInitializer);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GrParameterInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getOldIndex() {
        return this.myPosition;
    }

    @NotNull
    public String getDefaultValue() {
        String string = this.forceOptional() ? this.getDefaultInitializer() : this.myDefaultValue;
        if (string == null) {
            GrParameterInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        return this.myTypeWrapper != null ? this.myTypeWrapper.getType(context, manager) : null;
    }

    @NotNull
    public String getTypeText() {
        String string = this.myTypeWrapper != null ? this.myTypeWrapper.getTypeText() : "";
        if (string == null) {
            GrParameterInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public CanonicalTypes.Type getTypeWrapper() {
        return this.myTypeWrapper;
    }

    public PsiExpression getValue(PsiCallExpression callExpression) {
        return JavaPsiFacade.getElementFactory((Project)callExpression.getProject()).createExpressionFromText(this.getDefaultValue(), (PsiElement)callExpression);
    }

    public boolean isVarargType() {
        return this.getTypeText().endsWith("...") || this.getTypeText().endsWith("[]");
    }

    public boolean isUseAnySingleVariable() {
        return this.myUseAnySingleVariable;
    }

    public void setUseAnySingleVariable(boolean useAnyVar) {
        this.myUseAnySingleVariable = useAnyVar;
    }

    public boolean isOptional() {
        return !this.getDefaultInitializer().isEmpty();
    }

    @NotNull
    public String getDefaultInitializer() {
        String string = this.myDefaultInitializer;
        if (string == null) {
            GrParameterInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean hasNoType() {
        return this.getTypeText().isEmpty();
    }

    public boolean forceOptional() {
        return this.myPosition < 0 && StringUtil.isEmpty((String)this.myDefaultValue);
    }

    public void setName(String newName) {
        this.myName = StringUtil.notNullize((String)newName);
    }

    public void setType(@Nullable PsiType type2) {
        this.myTypeWrapper = type2 == null ? null : CanonicalTypes.createTypeWrapper((PsiType)type2);
    }

    public void setInitializer(@Nullable String initializer) {
        this.myDefaultInitializer = StringUtil.notNullize((String)initializer);
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.myDefaultValue = StringUtil.notNullize((String)defaultValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

