/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureDialog;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodDescriptor;

public class GrChangeSignatureHandler
implements ChangeSignatureHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            GrChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        GrChangeSignatureHandler.invokeOnElement(project, editor, element);
    }

    private static void invokeOnElement(Project project, Editor editor, PsiElement element) {
        if (element instanceof PsiMethod) {
            GrChangeSignatureHandler.invoke((PsiMethod)element, project);
        } else {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("error.wrong.caret.position.method.name", new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            GrChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            GrChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        GrChangeSignatureHandler.invokeOnElement(project, editor, elements[0]);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return null;
    }

    private static void invoke(PsiMethod method, Project project) {
        PsiMethod newMethod;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        if (method instanceof GrReflectedMethod) {
            method = ((GrReflectedMethod)method).getBaseMethod();
        }
        if ((newMethod = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)method, (String)RefactoringBundle.message((String)"to.refactor"))) == null) {
            return;
        }
        if (!newMethod.equals(method)) {
            ChangeSignatureUtil.invokeChangeSignatureOn((PsiMethod)newMethod, (Project)project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        if (!(method instanceof GrMethod)) {
            return;
        }
        GrChangeSignatureDialog dialog = new GrChangeSignatureDialog(project, new GrMethodDescriptor((GrMethod)method), true, null);
        dialog.show();
    }

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiElement element;
        PsiElement targetMember;
        if (file == null) {
            GrChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GrChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if ((targetMember = this.findTargetMember(element = file.findElementAt(editor.getCaretModel().getOffset()))) != null) {
            return targetMember;
        }
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        if (reference != null) {
            return reference.resolve();
        }
        return null;
    }

    @Nullable
    public PsiElement findTargetMember(@Nullable PsiElement element) {
        PsiElement parent2;
        if (element == null) {
            return null;
        }
        GrParameterList parameterList = (GrParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, GrParameterList.class);
        if (parameterList != null && (parent2 = parameterList.getParent()) instanceof PsiMethod) {
            return parent2;
        }
        if (element.getParent() instanceof GrMethod && ((GrMethod)element.getParent()).getNameIdentifierGroovy() == element) {
            return element.getParent();
        }
        GrCall expression = (GrCall)PsiTreeUtil.getParentOfType((PsiElement)element, GrCall.class);
        if (expression != null) {
            return expression.resolveMethod();
        }
        PsiReference ref = element.getReference();
        if (ref == null) {
            return null;
        }
        return ref.resolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

