/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public class GroovyNameSuggestionUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil");

    private GroovyNameSuggestionUtil() {
    }

    public static String[] suggestVariableNames(GrExpression expr, NameValidator validator) {
        return GroovyNameSuggestionUtil.suggestVariableNames(expr, validator, false);
    }

    public static String[] suggestVariableNames(@NotNull GrExpression expr, NameValidator validator, boolean forStaticVariable) {
        if (expr == null) {
            GroovyNameSuggestionUtil.$$$reportNull$$$0(0);
        }
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        PsiType type2 = expr.getType();
        GroovyNameSuggestionUtil.generateNameByExpr(expr, possibleNames, validator, forStaticVariable);
        if (type2 != null && !PsiType.VOID.equals((Object)type2)) {
            GroovyNameSuggestionUtil.generateVariableNameByTypeInner(type2, possibleNames, validator);
        }
        possibleNames.remove("");
        if (possibleNames.isEmpty()) {
            possibleNames.add(validator.validateName("var", true));
        }
        return ArrayUtil.toStringArray(possibleNames);
    }

    public static String[] suggestVariableNameByType(PsiType type2, NameValidator validator) {
        if (type2 == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        GroovyNameSuggestionUtil.generateVariableNameByTypeInner(type2, possibleNames, validator);
        return ArrayUtil.toStringArray(possibleNames);
    }

    private static void generateVariableNameByTypeInner(PsiType type2, Set<String> possibleNames, NameValidator validator) {
        String unboxed = PsiTypesUtil.unboxIfPossible((String)type2.getCanonicalText());
        if (unboxed != null && !unboxed.equals(type2.getCanonicalText())) {
            String name = GroovyNameSuggestionUtil.generateNameForBuiltInType(unboxed);
            if (GroovyNamesUtil.isIdentifier(name = validator.validateName(name, true))) {
                possibleNames.add(name);
            }
        } else if (type2 instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type2).getConjuncts()) {
                GroovyNameSuggestionUtil.generateByType(psiType, possibleNames, validator);
            }
        } else {
            GroovyNameSuggestionUtil.generateByType(type2, possibleNames, validator);
        }
    }

    private static void generateNameByExpr(GrExpression expr, Set<String> possibleNames, NameValidator validator, boolean forStaticVariable) {
        Object value;
        if (expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).getReferenceName() != null) {
            GrReferenceExpression refExpr;
            String name;
            if (PsiUtil.isThisReference(expr)) {
                possibleNames.add(validator.validateName("thisInstance", true));
            }
            if (PsiUtil.isSuperReference(expr)) {
                possibleNames.add(validator.validateName("superInstance", true));
            }
            if ((name = (refExpr = (GrReferenceExpression)expr).getReferenceName()) != null && name.toUpperCase().equals(name)) {
                possibleNames.add(validator.validateName(name.toLowerCase(), true));
            } else {
                GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, name);
            }
            if (expr.getText().equals(name)) {
                possibleNames.remove(name);
            }
        }
        if (expr instanceof GrMethodCallExpression) {
            GroovyNameSuggestionUtil.generateNameByExpr(((GrMethodCallExpression)expr).getInvokedExpression(), possibleNames, validator, forStaticVariable);
        }
        if (expr instanceof GrLiteral && (value = ((GrLiteral)expr).getValue()) instanceof String) {
            GroovyNameSuggestionUtil.generateNameByString(possibleNames, (String)value, validator, forStaticVariable, expr.getProject());
        }
    }

    private static void generateNameByString(Set<String> possibleNames, String value, NameValidator validator, boolean forStaticVariable, Project project) {
        if (!PsiNameHelper.getInstance((Project)project).isIdentifier(value)) {
            return;
        }
        if (forStaticVariable) {
            StringBuilder buffer = new StringBuilder(value.length() + 10);
            char[] chars = new char[value.length()];
            value.getChars(0, value.length(), chars, 0);
            boolean wasLow = Character.isLowerCase(chars[0]);
            buffer.append(Character.toUpperCase(chars[0]));
            for (int i = 1; i < chars.length; ++i) {
                if (Character.isUpperCase(chars[i])) {
                    if (wasLow) {
                        buffer.append('_');
                        wasLow = false;
                    }
                } else {
                    wasLow = true;
                }
                buffer.append(Character.toUpperCase(chars[i]));
            }
            possibleNames.add(validator.validateName(buffer.toString(), true));
        } else {
            possibleNames.add(validator.validateName(value, true));
        }
    }

    private static void generateByType(PsiType type2, Set<String> possibleNames, NameValidator validator) {
        String typeName = type2.getPresentableText();
        GroovyNameSuggestionUtil.generateNamesForCollectionType(type2, possibleNames, validator);
        GroovyNameSuggestionUtil.generateNamesForArrayType(type2, possibleNames, validator);
        GroovyNameSuggestionUtil.generateNamesForExceptions(type2, possibleNames, validator);
        typeName = GroovyNameSuggestionUtil.cleanTypeName(typeName);
        if (typeName.equals("String")) {
            possibleNames.add(validator.validateName("s", true));
        }
        if (typeName.equals("Closure")) {
            possibleNames.add(validator.validateName("cl", true));
        }
        if (typeName.toUpperCase().equals(typeName)) {
            possibleNames.add(validator.validateName(GroovyNamesUtil.deleteNonLetterFromString(typeName.toLowerCase()), true));
        } else if (!typeName.equals(typeName.toLowerCase())) {
            GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, typeName);
            possibleNames.remove(typeName);
        }
    }

    private static void generateNamesForExceptions(PsiType type2, Set<String> possibleNames, NameValidator validator) {
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Error")) {
            possibleNames.add(validator.validateName("error", true));
        } else if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Exception")) {
            possibleNames.add(validator.validateName("e", true));
        }
    }

    private static void generateNamesForArrayType(PsiType type2, Set<String> possibleNames, NameValidator validator) {
        int arrayDim = type2.getArrayDimensions();
        if (arrayDim == 0) {
            return;
        }
        PsiType deepType = type2.getDeepComponentType();
        String candidateName = GroovyNameSuggestionUtil.cleanTypeName(deepType.getPresentableText());
        if (deepType instanceof PsiClassType) {
            PsiClass clazz = ((PsiClassType)deepType).resolve();
            if (clazz == null) {
                return;
            }
            candidateName = GroovyNamesUtil.fromLowerLetter(clazz.getName());
        }
        candidateName = StringUtil.pluralize((String)GroovyNamesUtil.fromLowerLetter(candidateName));
        GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, candidateName);
        ArrayList<String> camelizedName = GroovyNamesUtil.camelizeString(candidateName);
        candidateName = camelizedName.get(camelizedName.size() - 1);
        candidateName = "arrayOf" + GroovyNameSuggestionUtil.fromUpperLetter(candidateName);
        possibleNames.add(validator.validateName(candidateName, true));
    }

    private static void generateNamesForCollectionType(PsiType type2, Set<String> possibleNames, NameValidator validator) {
        PsiType componentType = GroovyNameSuggestionUtil.getCollectionComponentType(type2, validator.getProject());
        if (!(type2 instanceof PsiClassType) || componentType == null) {
            return;
        }
        PsiClass clazz = ((PsiClassType)type2).resolve();
        if (clazz == null) {
            return;
        }
        String collectionName = clazz.getName();
        assert (collectionName != null);
        String componentName = GroovyNameSuggestionUtil.cleanTypeName(componentType.getPresentableText());
        if (componentType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)componentType;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) {
                return;
            }
            componentName = psiClass.getName();
        }
        assert (componentName != null);
        String candidateName = StringUtil.pluralize((String)GroovyNamesUtil.fromLowerLetter(componentName));
        GroovyNameSuggestionUtil.generateCamelNames(possibleNames, validator, candidateName);
        ArrayList<String> camelizedName = GroovyNamesUtil.camelizeString(candidateName);
        candidateName = camelizedName.get(camelizedName.size() - 1);
        candidateName = collectionName.toLowerCase() + "Of" + GroovyNameSuggestionUtil.fromUpperLetter(candidateName);
        possibleNames.add(validator.validateName(candidateName, true));
    }

    @NotNull
    private static String cleanTypeName(@NotNull String typeName) {
        if (typeName == null) {
            GroovyNameSuggestionUtil.$$$reportNull$$$0(1);
        }
        if (typeName.contains(".")) {
            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        if (typeName.contains("<")) {
            typeName = typeName.substring(0, typeName.indexOf("<"));
        }
        String string = typeName;
        if (string == null) {
            GroovyNameSuggestionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void generateCamelNames(Set<String> possibleNames, NameValidator validator, String typeName) {
        ArrayList<String> camelTokens = GroovyNamesUtil.camelizeString(typeName);
        Collections.reverse(camelTokens);
        if (!camelTokens.isEmpty()) {
            String possibleName = "";
            for (String camelToken : camelTokens) {
                possibleName = camelToken + GroovyNameSuggestionUtil.fromUpperLetter(possibleName);
                String candidate = validator.validateName(possibleName, true);
                if (candidate.equals("class")) {
                    candidate = validator.validateName("clazz", true);
                }
                if (possibleNames.contains(candidate) || !GroovyNamesUtil.isIdentifier(candidate)) continue;
                possibleNames.add(candidate);
            }
        }
    }

    private static String generateNameForBuiltInType(String unboxed) {
        return unboxed.toLowerCase().substring(0, 1);
    }

    private static String fromUpperLetter(String str) {
        if (str.isEmpty()) {
            return "";
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @Nullable
    private static PsiType getCollectionComponentType(PsiType type2, Project project) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
        PsiClass clazz = result2.getElement();
        if (clazz == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass collectionClass = facade.findClass("java.util.Collection", type2.getResolveScope());
        if (collectionClass == null || collectionClass.getTypeParameters().length != 1) {
            return null;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)collectionClass, (PsiClass)clazz, (PsiSubstitutor)result2.getSubstitutor());
        if (substitutor == null) {
            return null;
        }
        PsiType componentType = substitutor.substitute(collectionClass.getTypeParameters()[0]);
        return componentType instanceof PsiIntersectionType ? null : componentType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GroovyNameSuggestionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cleanTypeName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

