/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyDependentReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReferenceBase;
import org.jetbrains.plugins.groovy.lang.resolve.api.UnknownArgument;
import org.jetbrains.plugins.groovy.lang.resolve.impl.CallReferenceImplKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001eB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007j\u0004\u0018\u0001`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrOperatorReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyDependentReference;", "element", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;)V", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "receiver", "Lcom/intellij/psi/PsiType;", "getReceiver", "()Lcom/intellij/psi/PsiType;", "collectDependencies", "", "Lcom/intellij/psi/PsiPolyVariantReference;", "doResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.groovy.psi"})
public final class GrOperatorReference
extends GroovyMethodCallReferenceBase<GrOperatorExpression>
implements GroovyDependentReference {
    @NotNull
    private final String methodName;
    private static final Map<IElementType, String> binaryOperatorMethodNames;
    public static final Companion Companion;

    @NotNull
    public TextRange getRangeInElement() {
        GrOperatorExpression grOperatorExpression = (GrOperatorExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grOperatorExpression, (String)"element");
        PsiElement psiElement = grOperatorExpression.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.operationToken");
        TextRange textRange = psiElement.getTextRangeInParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.operationToken.textRangeInParent");
        return textRange;
    }

    @Override
    @Nullable
    public PsiType getReceiver() {
        GrOperatorExpression grOperatorExpression = (GrOperatorExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grOperatorExpression, (String)"element");
        return grOperatorExpression.getLeftType();
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @Nullable
    public List<Argument> getArguments() {
        GrOperatorExpression element;
        GrOperatorExpression grOperatorExpression = (GrOperatorExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grOperatorExpression, (String)"element");
        GrOperatorExpression grOperatorExpression2 = element = grOperatorExpression;
        GrExpression operand = grOperatorExpression2 instanceof GrBinaryExpression ? ((GrBinaryExpression)element).getRightOperand() : (grOperatorExpression2 instanceof GrAssignmentExpression ? ((GrAssignmentExpression)element).getRValue() : null);
        Argument argument = operand == null ? (Argument)UnknownArgument.INSTANCE : (Argument)new ExpressionArgument(operand);
        return CollectionsKt.listOf((Object)argument);
    }

    @Override
    @NotNull
    public Collection<GroovyResolveResult> doResolve(boolean incomplete) {
        return CallReferenceImplKt.resolveImpl2(this, incomplete);
    }

    @Override
    @NotNull
    public Collection<? extends PsiPolyVariantReference> collectDependencies() {
        SmartList result2 = new SmartList();
        ((GrOperatorExpression)this.getElement()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(result2){
            final /* synthetic */ SmartList $result;

            public void visitElement(@NotNull PsiElement element) {
                GrExpression operand;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof GrOperatorExpression) {
                    super.visitElement(element);
                } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                    super.visitElement((PsiElement)operand);
                }
            }

            protected void elementFinished(@NotNull PsiElement element) {
                block1: {
                    Object object;
                    Object object2;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    PsiElement psiElement = element;
                    if (!(psiElement instanceof GrOperatorExpression)) {
                        psiElement = null;
                    }
                    if ((object2 = (GrOperatorExpression)psiElement) == null || (object2 = object2.getReference()) == null) break block1;
                    Object it = object = object2;
                    boolean bl = false;
                    this.$result.add(it);
                }
            }
            {
                this.$result = $captured_local_variable$0;
            }
        });
        return (Collection)result2;
    }

    public GrOperatorReference(@NotNull GrOperatorExpression element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super((PsiElement)element);
        String string = binaryOperatorMethodNames.get(element.getOperator());
        if (string == null) {
            String string2 = element.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.text");
            String string3 = string2;
            GrOperatorReference grOperatorReference = this;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        this.methodName = string;
    }

    static {
        Companion = new Companion(null);
        binaryOperatorMethodNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)GroovyElementTypes.T_PLUS, (Object)"plus"), TuplesKt.to((Object)GroovyElementTypes.T_MINUS, (Object)"minus"), TuplesKt.to((Object)GroovyElementTypes.T_DIV, (Object)"div"), TuplesKt.to((Object)GroovyElementTypes.T_STAR, (Object)"multiply"), TuplesKt.to((Object)GroovyElementTypes.T_REM, (Object)"mod"), TuplesKt.to((Object)GroovyElementTypes.T_POW, (Object)"power"), TuplesKt.to((Object)GroovyElementTypes.T_BAND, (Object)"and"), TuplesKt.to((Object)GroovyElementTypes.T_BOR, (Object)"or"), TuplesKt.to((Object)GroovyElementTypes.T_XOR, (Object)"xor"), TuplesKt.to((Object)((Object)GroovyElementTypes.LEFT_SHIFT_SIGN), (Object)"leftShift"), TuplesKt.to((Object)((Object)GroovyElementTypes.RIGHT_SHIFT_SIGN), (Object)"rightShift"), TuplesKt.to((Object)((Object)GroovyElementTypes.RIGHT_SHIFT_UNSIGNED_SIGN), (Object)"rightShiftUnsigned"), TuplesKt.to((Object)GroovyElementTypes.T_EQ, (Object)"equals"), TuplesKt.to((Object)GroovyElementTypes.T_NEQ, (Object)"equals"), TuplesKt.to((Object)GroovyElementTypes.T_LT, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_LE, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_GT, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_GE, (Object)"compareTo"), TuplesKt.to((Object)GroovyElementTypes.T_COMPARE, (Object)"compareTo")});
    }

    @JvmStatic
    public static final boolean hasOperatorReference(@NotNull GrOperatorExpression expression) {
        return Companion.hasOperatorReference(expression);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrOperatorReference$Companion;", "", "()V", "binaryOperatorMethodNames", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "hasOperatorReference", "", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "intellij.groovy.psi"})
    public static final class Companion {
        @JvmStatic
        public final boolean hasOperatorReference(@NotNull GrOperatorExpression expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Map map2 = binaryOperatorMethodNames;
            IElementType iElementType = expression.getOperator();
            Map map3 = map2;
            return map3.containsKey(iElementType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

