/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ConstructorCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.FunctionalExpressionConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ListConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.SafeCastConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpressionConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "leftType", "Lcom/intellij/psi/PsiType;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "(Lcom/intellij/psi/PsiType;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "toString", "", "intellij.groovy.psi"})
public final class ExpressionConstraint
extends GrConstraintFormula {
    private final PsiType leftType;
    private final GrExpression expression;

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<ConstraintFormula> constraints) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)session), (String)"session");
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        GrExpression grExpression = this.expression;
        if (grExpression instanceof GrMethodCall) {
            GroovyResolveResult groovyResolveResult = ((GrMethodCall)this.expression).advancedResolve();
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return true;
            }
            GroovyMethodResult result2 = groovyMethodResult;
            constraints.add(new MethodCallConstraint(this.leftType, result2, this.expression));
        } else if (grExpression instanceof GrNewExpression) {
            constraints.add(new ConstructorCallConstraint(this.leftType, (GrNewExpression)this.expression));
        } else if (grExpression instanceof GrFunctionalExpression) {
            if (this.leftType != null) {
                constraints.add(new FunctionalExpressionConstraint((GrFunctionalExpression)this.expression, this.leftType));
            }
        } else if (grExpression instanceof GrSafeCastExpression) {
            if (this.leftType != null) {
                constraints.add(new SafeCastConstraint(this.leftType, (GrSafeCastExpression)this.expression));
            }
        } else if (grExpression instanceof GrListOrMap) {
            constraints.add(new ListConstraint(this.leftType, (GrListOrMap)this.expression));
        } else if (grExpression instanceof GrReferenceExpression) {
            GroovyResolveResult result3;
            GroovyReference groovyReference = ((GrReferenceExpression)this.expression).getRValueReference();
            GroovyResolveResult groovyResolveResult = result3 = groovyReference != null ? groovyReference.advancedResolve() : null;
            if (result3 instanceof GroovyMethodResult) {
                Collection collection = constraints;
                MethodCallConstraint methodCallConstraint = new MethodCallConstraint(this.leftType, (GroovyMethodResult)result3, this.expression);
                collection.add(methodCallConstraint);
            } else if (this.leftType != null) {
                Collection collection = constraints;
                TypeConstraint typeConstraint = new TypeConstraint(this.leftType, ((GrReferenceExpression)this.expression).getType(), this.expression);
                collection.add(typeConstraint);
            }
        } else if (grExpression instanceof GrAssignmentExpression) {
            GroovyResolveResult groovyResolveResult;
            GroovyReference groovyReference;
            GrExpression grExpression2 = ((GrAssignmentExpression)this.expression).getLValue();
            if (!(grExpression2 instanceof GrReferenceExpression)) {
                grExpression2 = null;
            }
            if (!(((groovyReference = (GrReferenceExpression)grExpression2) != null && (groovyReference = groovyReference.getLValueReference()) != null ? groovyReference.advancedResolve() : (groovyResolveResult = null)) instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return true;
            }
            GroovyMethodResult result4 = groovyMethodResult;
            constraints.add(new MethodCallConstraint(null, result4, this.expression));
        } else if (this.leftType != null) {
            constraints.add(new TypeConstraint(this.leftType, this.expression.getType(), this.expression));
        }
        return true;
    }

    @NotNull
    public String toString() {
        PsiType psiType = this.leftType;
        return this.expression.getText() + " -> " + (psiType != null ? psiType.getPresentableText() : null);
    }

    public ExpressionConstraint(@Nullable PsiType leftType, @NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.leftType = leftType;
        this.expression = expression;
    }
}

