/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.caches;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.MostlySingularMultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.AnnotationHint;
import org.jetbrains.plugins.groovy.lang.resolve.caches.DeclarationHolder;
import org.jetbrains.plugins.groovy.lang.resolve.caches.ElementWithState;
import org.jetbrains.plugins.groovy.lang.resolve.caches.FileDeclarationsCache;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J#\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/caches/FileCacheBuilderProcessor;", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "Lcom/intellij/psi/scope/ElementClassHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/AnnotationHint;", "annotationResolve", "", "(Z)V", "declarations", "Lcom/intellij/util/containers/MostlySingularMultiMap;", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/caches/ElementWithState;", "buildCache", "Lorg/jetbrains/plugins/groovy/lang/resolve/caches/DeclarationHolder;", "execute", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "getHint", "T", "hintKey", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "isAnnotationResolve", "shouldProcess", "kind", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "intellij.groovy.psi"})
public final class FileCacheBuilderProcessor
implements PsiScopeProcessor,
ElementClassHint,
AnnotationHint {
    private final MostlySingularMultiMap<String, ElementWithState> declarations;
    private final boolean annotationResolve;

    @NotNull
    public final DeclarationHolder buildCache() {
        return new FileDeclarationsCache(this.declarations);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
        if (psiNamedElement == null) {
            return true;
        }
        PsiNamedElement namedElement = psiNamedElement;
        String string = (String)state.get(GroovyImports.getImportedNameKey());
        if (string == null) {
            string = namedElement.getName();
        }
        if (string == null) {
            return true;
        }
        String name = string;
        this.declarations.add((Object)name, (Object)new ElementWithState(element, state));
        return true;
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        Intrinsics.checkParameterIsNotNull(hintKey, (String)"hintKey");
        Key<T> key = hintKey;
        return (T)(Intrinsics.areEqual(key, AnnotationHint.HINT_KEY) || Intrinsics.areEqual(key, (Object)ElementClassHint.KEY) ? (Object)this : null);
    }

    @Override
    public boolean isAnnotationResolve() {
        return this.annotationResolve;
    }

    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return !this.annotationResolve || kind == ElementClassHint.DeclarationKind.CLASS;
    }

    public FileCacheBuilderProcessor(boolean annotationResolve) {
        this.annotationResolve = annotationResolve;
        this.declarations = new MostlySingularMultiMap();
    }
}

