/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SingletonInstancesCache;
import java.util.List;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodDescriptor;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;

public class PluginXmlClosureMemberContributor
extends ClosureMissingMethodContributor {
    @Override
    public boolean processMembers(GrClosableBlock closure, PsiScopeProcessor processor, GrReferenceExpression refExpr, ResolveState state) {
        PsiElement parent2 = closure.getParent();
        if (parent2 instanceof GrArgumentList) {
            parent2 = parent2.getParent();
        }
        if (!(parent2 instanceof GrMethodCall)) {
            return true;
        }
        PsiMethod psiMethod = ((GrMethodCall)parent2).resolveMethod();
        if (psiMethod == null) {
            return true;
        }
        List<GroovyMethodInfo> infos = GroovyMethodInfo.getInfos(psiMethod);
        if (infos.isEmpty()) {
            return true;
        }
        int index = PsiUtil.getArgumentIndex((GrMethodCall)parent2, closure);
        if (index == -1) {
            return true;
        }
        for (GroovyMethodInfo info : infos) {
            GroovyMethodDescriptor.ClosureArgument[] closureArguments = info.getDescriptor().myClosureArguments;
            if (closureArguments == null) continue;
            for (GroovyMethodDescriptor.ClosureArgument argument : closureArguments) {
                ClosureMissingMethodContributor instance;
                if (argument.index != index || argument.methodContributor == null || (instance = (ClosureMissingMethodContributor)SingletonInstancesCache.getInstance((String)argument.methodContributor, (ClassLoader)info.getPluginClassLoader())).processMembers(closure, processor, refExpr, state)) continue;
                return false;
            }
        }
        return true;
    }
}

