/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.ByteArraySequenceExternalizer;

public class GroovyTraitMethodsFileIndex
extends SingleEntryFileBasedIndexExtension<ByteArraySequence> {
    private static final Logger LOG = Logger.getInstance(GroovyTraitMethodsFileIndex.class);
    private static final ID<Integer, ByteArraySequence> INDEX_ID = ID.create((String)"groovy.trait.methods");
    private static final String HELPER_SUFFIX = "$Trait$Helper.class";
    private final FileBasedIndex.InputFilter myFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            return StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)GroovyTraitMethodsFileIndex.HELPER_SUFFIX);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitMethodsFileIndex$1", "acceptInput"));
        }
    };
    private final SingleEntryIndexer<ByteArraySequence> myIndexer = new SingleEntryIndexer<ByteArraySequence>(false){

        protected ByteArraySequence computeValue(@NotNull FileContent inputData) {
            if (inputData == null) {
                2.$$$reportNull$$$0(0);
            }
            return GroovyTraitMethodsFileIndex.serialize(GroovyTraitMethodsFileIndex.index(inputData.getFile(), inputData.getContent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitMethodsFileIndex$2", "computeValue"));
        }
    };

    @NotNull
    public ID<Integer, ByteArraySequence> getName() {
        ID<Integer, ByteArraySequence> iD = INDEX_ID;
        if (iD == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 24;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myFilter;
        if (inputFilter == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(1);
        }
        return inputFilter;
    }

    @NotNull
    public SingleEntryIndexer<ByteArraySequence> getIndexer() {
        SingleEntryIndexer<ByteArraySequence> singleEntryIndexer = this.myIndexer;
        if (singleEntryIndexer == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(2);
        }
        return singleEntryIndexer;
    }

    @NotNull
    public DataExternalizer<ByteArraySequence> getValueExternalizer() {
        ByteArraySequenceExternalizer byteArraySequenceExternalizer = ByteArraySequenceExternalizer.INSTANCE;
        if (byteArraySequenceExternalizer == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(3);
        }
        return byteArraySequenceExternalizer;
    }

    @Contract(value="null -> null")
    private static ByteArraySequence serialize(@Nullable PsiJavaFileStub stub) {
        if (stub == null) {
            return null;
        }
        BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream();
        ApplicationManager.getApplication().runReadAction(() -> SerializationManagerEx.getInstanceEx().serialize((Stub)stub, (OutputStream)buffer));
        return buffer.toByteArraySequence();
    }

    @Nullable
    private static PsiJavaFileStub index(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(4);
        }
        if (content == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(5);
        }
        try {
            PsiJavaFileStubImpl root = new PsiJavaFileStubImpl("", true);
            new ClassReader(content).accept((ClassVisitor)new GrTraitMethodVisitor(file, (StubElement)root), ClsFileImpl.EMPTY_ATTRIBUTES, 1);
            new StubTree((PsiFileStub)root);
            return root;
        }
        catch (OutOfOrderInnerClassException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(file.getPath());
            }
            return null;
        }
        catch (Exception e) {
            LOG.info(file.getPath(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Collection<PsiMethod> getStaticTraitMethods(@NotNull ClsClassImpl trait) {
        PsiFile psiFile;
        if (trait == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(6);
        }
        if (!((psiFile = trait.getContainingFile()) instanceof PsiJavaFile)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                GroovyTraitMethodsFileIndex.$$$reportNull$$$0(7);
            }
            return list;
        }
        VirtualFile traitFile = psiFile.getVirtualFile();
        if (traitFile == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                GroovyTraitMethodsFileIndex.$$$reportNull$$$0(8);
            }
            return list;
        }
        VirtualFile helperFile = traitFile.getParent().findChild(trait.getName() + HELPER_SUFFIX);
        if (helperFile == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                GroovyTraitMethodsFileIndex.$$$reportNull$$$0(9);
            }
            return list;
        }
        int key = GroovyTraitMethodsFileIndex.getFileKey((VirtualFile)helperFile);
        List byteSequences = FileBasedIndex.getInstance().getValues(INDEX_ID, (Object)key, trait.getResolveScope());
        if (byteSequences.isEmpty()) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                GroovyTraitMethodsFileIndex.$$$reportNull$$$0(10);
            }
            return list;
        }
        SerializationManagerEx manager = SerializationManagerEx.getInstanceEx();
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        for (ByteArraySequence byteSequence : byteSequences) {
            Stub root;
            try {
                root = manager.deserialize((InputStream)new ByteArrayInputStream(byteSequence.getBytes()));
                ((PsiJavaFileStubImpl)root).setPsi((PsiFile)((PsiJavaFile)psiFile));
            }
            catch (SerializerNotFoundException e) {
                LOG.warn((Throwable)e);
                continue;
            }
            for (Object childStub : ((Stub)root.getChildrenStubs().get(0)).getChildrenStubs()) {
                if (!(childStub instanceof PsiMethodStub)) continue;
                result2.add((PsiMethod)((PsiMethodStub)childStub).getPsi());
            }
        }
        ArrayList<PsiMethod> arrayList = result2;
        if (arrayList == null) {
            GroovyTraitMethodsFileIndex.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitMethodsFileIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitMethodsFileIndex";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticTraitMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStaticTraitMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GrTraitMethodVisitor
    extends StubBuildingVisitor<VirtualFile> {
        GrTraitMethodVisitor(VirtualFile file, StubElement root) {
            super((Object)file, null, root, 0, null);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, "gr_trait_helper", null, null, null);
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Nullable
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Nullable
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Type[] args;
            if ((access & 0x1000) == 0 && (access & 8) != 0 && name != null && (args = Type.getArgumentTypes((String)desc)).length > 0 && args[0].getSort() == 10 && "java.lang.Class".equals(args[0].getClassName())) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            return null;
        }
    }
}

