/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrImportUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.noncode.MixinMemberContributor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

public class GdkMethodUtil {
    public static final Set<String> COLLECTION_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"each", "eachWithIndex", "any", "every", "reverseEach", "collect", "collectAll", "find", "findAll", "retainAll", "removeAll", "split", "groupBy", "groupEntriesBy", "findLastIndexOf", "findIndexValues", "findIndexOf"});
    @NonNls
    private static final String WITH = "with";
    @NonNls
    private static final String IDENTITY = "identity";
    @NonNls
    public static final String EACH_WITH_INDEX = "eachWithIndex";
    @NonNls
    public static final String INJECT = "inject";
    @NonNls
    public static final String EACH_PERMUTATION = "eachPermutation";
    @NonNls
    public static final String WITH_DEFAULT = "withDefault";
    @NonNls
    public static final String SORT = "sort";
    @NonNls
    public static final String WITH_STREAM = "withStream";
    @NonNls
    public static final String WITH_STREAMS = "withStreams";
    @NonNls
    public static final String WITH_OBJECT_STREAMS = "withObjectStreams";

    private GdkMethodUtil() {
    }

    public static boolean processCategoryMethods(PsiElement place, PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiClass categoryClass) {
        if (state == null) {
            GdkMethodUtil.$$$reportNull$$$0(0);
        }
        if (categoryClass == null) {
            GdkMethodUtil.$$$reportNull$$$0(1);
        }
        for (final PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
            GrDelegatingScopeProcessorWithHints delegate = new GrDelegatingScopeProcessorWithHints(psiScopeProcessor, null, ClassHint.RESOLVE_KINDS_METHOD){

                @Override
                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState delegateState) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (delegateState == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof PsiMethod && GdkMethodUtil.isCategoryMethod((PsiMethod)element, null, null, null)) {
                        PsiMethod method = (PsiMethod)element;
                        return psiScopeProcessor.execute((PsiElement)GrGdkMethodImpl.createGdkMethod(method, false, GdkMethodUtil.generateOriginInfo(method)), delegateState);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "delegateState";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GdkMethodUtil$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (categoryClass.processDeclarations((PsiScopeProcessor)delegate, state, null, place)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInWithContext(PsiElement resolveContext) {
        PsiMethod method;
        PsiElement pparent;
        PsiElement parent2;
        return resolveContext instanceof GrExpression && (parent2 = resolveContext.getParent()) instanceof GrReferenceExpression && ((GrReferenceExpression)parent2).getQualifier() == resolveContext && (pparent = parent2.getParent()) instanceof GrMethodCall && (method = ((GrMethodCall)pparent).resolveMethod()) instanceof GrGdkMethod && GdkMethodUtil.isWithName(method.getName());
    }

    public static boolean isWithName(String name) {
        return WITH.equals(name) || IDENTITY.equals(name) || "tap".equals(name);
    }

    @Nullable
    public static String generateOriginInfo(PsiMethod method) {
        PsiClass cc = method.getContainingClass();
        if (cc == null) {
            return null;
        }
        return "via " + cc.getName();
    }

    public static boolean processMixinToMetaclass(GrStatementOwner run, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        GrStatement[] statements;
        if (!ResolveUtilKt.shouldProcessMethods(processor)) {
            return true;
        }
        for (GrStatement statement : statements = run.getStatements()) {
            if (statement == lastParent) break;
            Trinity<PsiClassType, GrReferenceExpression, PsiClass> result2 = GdkMethodUtil.getMixinTypes(statement);
            if (result2 != null) {
                PsiClassType subjectType = (PsiClassType)result2.first;
                GrReferenceExpression qualifier = (GrReferenceExpression)result2.second;
                PsiClass mixin = (PsiClass)result2.third;
                for (PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
                    if (mixin.processDeclarations((PsiScopeProcessor)new MixinMemberContributor.MixinProcessor(psiScopeProcessor, (PsiType)subjectType, qualifier), state, null, place)) continue;
                    return false;
                }
                continue;
            }
            Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> closureResult = GdkMethodUtil.getClosureMixins(statement);
            if (closureResult == null) continue;
            PsiClassType subjectType = (PsiClassType)closureResult.first;
            GrReferenceExpression qualifier = (GrReferenceExpression)closureResult.second;
            List methods = (List)closureResult.third;
            MixinMemberContributor.MixinProcessor mixinProcessor = new MixinMemberContributor.MixinProcessor(processor, (PsiType)subjectType, qualifier);
            for (GrMethod method : methods) {
                ResolveUtil.processElement((PsiScopeProcessor)mixinProcessor, (PsiNamedElement)method, state);
            }
        }
        return true;
    }

    @NotNull
    private static GrMethod createMethod(@NotNull GrSignature signature, @NotNull String name, @NotNull GrAssignmentExpression statement, @NotNull PsiClass closure) {
        if (signature == null) {
            GdkMethodUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GdkMethodUtil.$$$reportNull$$$0(3);
        }
        if (statement == null) {
            GdkMethodUtil.$$$reportNull$$$0(4);
        }
        if (closure == null) {
            GdkMethodUtil.$$$reportNull$$$0(5);
        }
        GrLightMethodBuilder builder = new GrLightMethodBuilder(statement.getManager(), name);
        GrClosureParameter[] parameters = signature.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            GrClosureParameter parameter = parameters[i];
            String parameterName = parameter.getName() != null ? parameter.getName() : "p" + i;
            PsiType type2 = parameter.getType() != null ? parameter.getType() : TypesUtil.getJavaLangObject(statement);
            builder.addParameter(parameterName, type2, parameter.isOptional());
        }
        builder.setNavigationElement(statement.getLValue());
        builder.setReturnType(signature.getReturnType());
        builder.setContainingClass(closure);
        GrLightMethodBuilder grLightMethodBuilder = builder;
        if (grLightMethodBuilder == null) {
            GdkMethodUtil.$$$reportNull$$$0(6);
        }
        return grLightMethodBuilder;
    }

    private static Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> getClosureMixins(GrStatement statement) {
        if (!(statement instanceof GrAssignmentExpression)) {
            return null;
        }
        GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
        return (Trinity)CachedValuesManager.getCachedValue((PsiElement)statement, () -> {
            Pair<PsiClassType, GrReferenceExpression> original = GdkMethodUtil.getTypeToMixIn(assignment);
            if (original == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            Pair<List<GrSignature>, String> signatures = GdkMethodUtil.getTypeToMix(assignment);
            if (signatures == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            String name = (String)signatures.second;
            ArrayList methods = ContainerUtil.newArrayList();
            PsiClass closure = JavaPsiFacade.getInstance((Project)statement.getProject()).findClass("groovy.lang.Closure", statement.getResolveScope());
            if (closure == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            for (GrSignature signature : (List)signatures.first) {
                methods.add(GdkMethodUtil.createMethod(signature, name, assignment, closure));
            }
            return CachedValueProvider.Result.create((Object)Trinity.create((Object)original.first, (Object)original.second, (Object)methods), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getTypeToMixIn(GrAssignmentExpression assignment) {
        PsiElement resolved;
        GrExpression metaClassRef;
        GrExpression lvalue = assignment.getLValue();
        if (lvalue instanceof GrReferenceExpression && (metaClassRef = (GrExpression)((GrReferenceExpression)lvalue).getQualifier()) instanceof GrReferenceExpression && (GrImportUtil.acceptName((GrReferenceElement)((Object)metaClassRef), "metaClass") || GrImportUtil.acceptName((GrReferenceElement)((Object)metaClassRef), "getMetaClass")) && (resolved = ((GrReferenceElement)((Object)metaClassRef)).resolve()) instanceof PsiMethod && GdkMethodUtil.isMetaClassMethod((PsiMethod)resolved)) {
            return GdkMethodUtil.getPsiClassFromReference((GrExpression)((GrReferenceExpression)metaClassRef).getQualifier());
        }
        return null;
    }

    @Nullable
    private static Pair<List<GrSignature>, String> getTypeToMix(GrAssignmentExpression assignment) {
        GrExpression mixinRef = assignment.getRValue();
        if (mixinRef == null) {
            return null;
        }
        PsiType type2 = mixinRef.getType();
        if (type2 instanceof GrClosureType) {
            GrExpression lValue = assignment.getLValue();
            assert (lValue instanceof GrReferenceExpression);
            String name = ((GrReferenceExpression)lValue).getReferenceName();
            return Pair.create(((GrClosureType)type2).getSignatures(), (Object)name);
        }
        return null;
    }

    @Nullable
    private static Trinity<PsiClassType, GrReferenceExpression, PsiClass> getMixinTypes(GrStatement statement) {
        if (!(statement instanceof GrMethodCall)) {
            return null;
        }
        return (Trinity)CachedValuesManager.getCachedValue((PsiElement)statement, () -> {
            GrMethodCall call = (GrMethodCall)statement;
            Pair<PsiClassType, GrReferenceExpression> original = GdkMethodUtil.getTypeToMixIn(call);
            if (original == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            PsiClass mix = GdkMethodUtil.getTypeToMix(call);
            if (mix == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)new Trinity(original.first, original.second, (Object)mix), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static PsiClass getTypeToMix(GrMethodCall call) {
        PsiElement resolved;
        if (!GdkMethodUtil.isSingleExpressionArg(call)) {
            return null;
        }
        GrExpression mixinRef = call.getExpressionArguments()[0];
        if (GdkMethodUtil.isClassRef(mixinRef)) {
            mixinRef = (GrExpression)((GrReferenceExpression)mixinRef).getQualifier();
        }
        if (mixinRef instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)mixinRef).resolve()) instanceof PsiClass) {
            return (PsiClass)resolved;
        }
        return null;
    }

    private static boolean isSingleExpressionArg(@NotNull GrMethodCall call) {
        if (call == null) {
            GdkMethodUtil.$$$reportNull$$$0(7);
        }
        return call.getExpressionArguments().length == 1 && !PsiImplUtil.hasNamedArguments(call.getArgumentList()) && !call.hasClosureArguments();
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getTypeToMixIn(GrMethodCall methodCall) {
        PsiElement resolved;
        GrExpression invoked = methodCall.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpression)) {
            return null;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)invoked;
        if (GrImportUtil.acceptName(referenceExpression, "mixin") && (resolved = referenceExpression.resolve()) instanceof PsiMethod && GdkMethodUtil.isMixinMethod((PsiMethod)resolved)) {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            Pair<PsiClassType, GrReferenceExpression> type2 = GdkMethodUtil.getPsiClassFromReference(qualifier);
            if (type2 != null) {
                return type2;
            }
            if (qualifier != null && GdkMethodUtil.isMetaClass(qualifier.getType())) {
                if (qualifier instanceof GrMethodCall) {
                    qualifier = ((GrMethodCall)qualifier).getInvokedExpression();
                }
                if (qualifier instanceof GrReferenceExpression) {
                    GrExpression qqualifier = ((GrReferenceExpression)qualifier).getQualifierExpression();
                    if (qqualifier != null) {
                        Pair<PsiClassType, GrReferenceExpression> type1 = GdkMethodUtil.getPsiClassFromMetaClassReference(qqualifier);
                        if (type1 != null) {
                            return type1;
                        }
                    } else {
                        PsiType qtype = PsiImplUtil.getQualifierType((GrReferenceExpression)qualifier);
                        if (qtype instanceof PsiClassType && ((PsiClassType)qtype).resolve() != null) {
                            return Pair.create((Object)((PsiClassType)qtype), (Object)((GrReferenceExpression)qualifier));
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isMixinMethod(@NotNull PsiMethod method) {
        if (method == null) {
            GdkMethodUtil.$$$reportNull$$$0(8);
        }
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        PsiClass containingClass = method.getContainingClass();
        String name = method.getName();
        return "mixin".equals(name) && containingClass != null && "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName());
    }

    private static boolean isMetaClassMethod(@NotNull PsiMethod method) {
        if (method == null) {
            GdkMethodUtil.$$$reportNull$$$0(9);
        }
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        PsiClass containingClass = method.getContainingClass();
        String name = method.getName();
        return "getMetaClass".equals(name) && containingClass != null && method.getParameterList().isEmpty() ^ "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName());
    }

    private static boolean isMetaClass(PsiType qualifierType) {
        return qualifierType != null && qualifierType.equalsToText("groovy.lang.MetaClass");
    }

    private static boolean isClassRef(GrExpression mixinRef) {
        return mixinRef instanceof GrReferenceExpression && "class".equals(((GrReferenceExpression)mixinRef).getReferenceName());
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getPsiClassFromReference(@Nullable GrExpression ref) {
        if (ref == null) {
            return null;
        }
        PsiType type2 = ResolveUtil.unwrapClassType(ref.getType());
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        if (GdkMethodUtil.isClassRef(ref)) {
            ref = (GrExpression)((GrReferenceExpression)ref).getQualifier();
        }
        if (!(ref instanceof GrReferenceExpression)) {
            return null;
        }
        return Pair.create((Object)((PsiClassType)type2), (Object)((GrReferenceExpression)ref));
    }

    private static Pair<PsiClassType, GrReferenceExpression> getPsiClassFromMetaClassReference(@NotNull GrExpression expression) {
        PsiType type2;
        if (expression == null) {
            GdkMethodUtil.$$$reportNull$$$0(10);
        }
        if (!((type2 = expression.getType()) instanceof PsiClassType)) {
            return null;
        }
        GrReferenceExpression ref = expression instanceof GrReferenceExpression ? (GrReferenceExpression)expression : null;
        return Pair.create((Object)((PsiClassType)type2), (Object)ref);
    }

    public static boolean isCategoryMethod(@NotNull PsiMethod method, @Nullable PsiType qualifierType, @Nullable PsiElement place, @Nullable PsiSubstitutor substitutor) {
        if (method == null) {
            GdkMethodUtil.$$$reportNull$$$0(11);
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            return false;
        }
        if (qualifierType == null) {
            return true;
        }
        PsiType selfType = parameters[0].getType();
        if (selfType instanceof PsiPrimitiveType) {
            return false;
        }
        if (substitutor != null) {
            selfType = substitutor.substitute(selfType);
        }
        if (selfType instanceof PsiClassType && ((PsiClassType)selfType).rawType().equalsToText("java.lang.Class") && place instanceof GrReferenceExpression && ((GrReferenceExpression)place).resolve() instanceof PsiClass) {
            return TypesUtil.isAssignableByMethodCallConversion(selfType, TypesUtil.createJavaLangClassType(qualifierType, (PsiElement)method), (PsiElement)method);
        }
        return TypesUtil.isAssignableByMethodCallConversion(selfType, qualifierType, (PsiElement)method);
    }

    @Nullable
    public static PsiClassType getCategoryType(final @NotNull PsiClass categoryAnnotationOwner) {
        if (categoryAnnotationOwner == null) {
            GdkMethodUtil.$$$reportNull$$$0(12);
        }
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)categoryAnnotationOwner, (CachedValueProvider)new CachedValueProvider<PsiClassType>(){

            public CachedValueProvider.Result<PsiClassType> compute() {
                return CachedValueProvider.Result.create((Object)this.inferCategoryType(categoryAnnotationOwner), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }

            @Nullable
            private PsiClassType inferCategoryType(PsiClass aClass) {
                return (PsiClassType)RecursionManager.doPreventingRecursion((Object)aClass, (boolean)true, (Computable)((NullableComputable)() -> {
                    PsiModifierList modifierList = aClass.getModifierList();
                    if (modifierList == null) {
                        return null;
                    }
                    PsiAnnotation annotation = modifierList.findAnnotation("groovy.lang.Category");
                    if (annotation == null) {
                        return null;
                    }
                    PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
                    if (!(value instanceof GrReferenceExpression)) {
                        return null;
                    }
                    if ("class".equals(((GrReferenceExpression)value).getReferenceName())) {
                        value = (PsiAnnotationMemberValue)((GrReferenceExpression)value).getQualifier();
                    }
                    if (!(value instanceof GrReferenceExpression)) {
                        return null;
                    }
                    PsiElement resolved = ((GrReferenceExpression)value).resolve();
                    if (!(resolved instanceof PsiClass)) {
                        return null;
                    }
                    String className = ((PsiClass)resolved).getQualifiedName();
                    if (className == null) {
                        className = ((PsiClass)resolved).getName();
                    }
                    if (className == null) {
                        return null;
                    }
                    return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeByFQClassName(className, resolved.getResolveScope());
                }));
            }
        });
    }

    public static boolean isWithOrIdentity(@Nullable PsiElement element) {
        if (element instanceof PsiMethod && GdkMethodUtil.isWithName(((PsiMethod)element).getName())) {
            PsiClass containingClass;
            if (element instanceof GrGdkMethod) {
                element = ((GrGdkMethod)element).getStaticMethod();
            }
            if ((containingClass = ((PsiMethod)element).getContainingClass()) != null && "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GdkMethodUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryAnnotationOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GdkMethodUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processCategoryMethods";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSingleExpressionArg";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMixinMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMetaClassMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassFromMetaClassReference";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCategoryMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCategoryType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

