/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.typing.EmptyListLiteralType;

public class GrContainerTypeConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (targetType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(0);
        }
        if (actualType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(2);
        }
        if (currentPosition == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(3);
        }
        if (currentPosition == GrTypeConverter.ApplicableTo.ASSIGNMENT && TypesUtil.resolvesTo(targetType, "java.util.Set") && actualType instanceof EmptyListLiteralType) {
            return ConversionResult.OK;
        }
        if (PsiUtil.isCompileStatic(context)) {
            return GrContainerTypeConverter.isCSConvertible(targetType, actualType, context);
        }
        if (!GrContainerTypeConverter.isCollectionOrArray(targetType) || !GrContainerTypeConverter.isCollectionOrArray(actualType)) {
            return null;
        }
        PsiType lComponentType = GrContainerTypeConverter.extractComponentType(targetType);
        PsiType rComponentType = GrContainerTypeConverter.extractComponentType(actualType);
        if (lComponentType == null || rComponentType == null) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isAssignableByParameter(lComponentType, rComponentType, context)) {
            return ConversionResult.OK;
        }
        return null;
    }

    @Nullable
    private static ConversionResult isCSConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context) {
        if (targetType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(4);
        }
        if (actualType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(6);
        }
        if (targetType instanceof PsiArrayType && actualType instanceof PsiArrayType) {
            return TypesUtil.isAssignableByParameter(((PsiArrayType)targetType).getComponentType(), ((PsiArrayType)actualType).getComponentType(), context) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        return null;
    }

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        if (position == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(7);
        }
        return position != GrTypeConverter.ApplicableTo.METHOD_PARAMETER;
    }

    @Nullable
    private static PsiType extractComponentType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return ((PsiArrayType)type2).getComponentType();
        }
        return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Collection", (int)0, (boolean)false);
    }

    private static boolean isCollectionOrArray(PsiType type2) {
        return type2 instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrContainerTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertibleEx";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCSConvertible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

