/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.hierarchy;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubsHierarchy.StubHierarchyIndexer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrImportStatementStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public class GrStubIndexer
extends StubHierarchyIndexer {
    public int getVersion() {
        return 50;
    }

    public boolean handlesFile(@NotNull VirtualFile file) {
        if (file == null) {
            GrStubIndexer.$$$reportNull$$$0(0);
        }
        return file.getFileType() == GroovyFileType.GROOVY_FILE_TYPE;
    }

    @Nullable
    public IndexTree.Unit indexFile(@NotNull FileContent content) {
        if (content == null) {
            GrStubIndexer.$$$reportNull$$$0(1);
        }
        if (!GrStubIndexer.isNormalGroovyFile(((FileContentImpl)content).getPsiFileForPsiDependentIndex())) {
            return null;
        }
        Stub stubTree = StubTreeBuilder.buildStubTree((FileContent)content);
        if (!(stubTree instanceof GrFileStub)) {
            return null;
        }
        GrFileStub grFileStub = (GrFileStub)stubTree;
        new StubTree((PsiFileStub)grFileStub, false);
        String pid = "";
        ArrayList<IndexTree.ClassDecl> classList = new ArrayList<IndexTree.ClassDecl>();
        HashSet<String> usedNames = new HashSet<String>();
        for (Object el : grFileStub.getChildrenStubs()) {
            IndexTree.ClassDecl classDecl;
            GrPackageDefinitionStub packageStub;
            String pkgName;
            if (el instanceof GrPackageDefinitionStub && (pkgName = (packageStub = (GrPackageDefinitionStub)((Object)el)).getPackageName()) != null) {
                pid = GrStubIndexer.id(pkgName, false, null);
            }
            if (!(el instanceof GrTypeDefinitionStub) || (classDecl = GrStubIndexer.processClassDecl((GrTypeDefinitionStub)((Object)el), usedNames, false)) == null) continue;
            classList.add(classDecl);
        }
        ArrayList importList = new ArrayList();
        for (StubElement el : grFileStub.getChildrenStubs()) {
            if (!(el instanceof GrImportStatementStub)) continue;
            GrStubIndexer.processImport((GrImportStatementStub)el, importList, usedNames);
        }
        IndexTree.ClassDecl[] classes2 = classList.isEmpty() ? IndexTree.ClassDecl.EMPTY_ARRAY : classList.toArray(IndexTree.ClassDecl.EMPTY_ARRAY);
        IndexTree.Import[] imports2 = importList.isEmpty() ? IndexTree.Import.EMPTY_ARRAY : importList.toArray(IndexTree.Import.EMPTY_ARRAY);
        return new IndexTree.Unit(pid, 2, imports2, classes2);
    }

    private static boolean isNormalGroovyFile(PsiFile file) {
        return file instanceof GroovyFile && !GrStubIndexer.hasSpecialScriptType((GroovyFile)file);
    }

    private static boolean hasSpecialScriptType(GroovyFile file) {
        return file.isScript() && ContainerUtil.exists((Object[])GroovyScriptTypeDetector.EP_NAME.getExtensions(), detector -> detector.isSpecificScriptFile(file));
    }

    @Nullable
    private static IndexTree.Decl processMember(StubElement<?> el, Set<String> namesCache) {
        if (el instanceof GrTypeDefinitionStub) {
            return GrStubIndexer.processClassDecl((GrTypeDefinitionStub)el, namesCache, true);
        }
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        for (StubElement childElement : el.getChildrenStubs()) {
            IndexTree.Decl innerDef = GrStubIndexer.processMember(childElement, namesCache);
            if (innerDef == null) continue;
            innerList.add(innerDef);
        }
        return innerList.isEmpty() ? null : new IndexTree.MemberDecl(innerList.toArray(IndexTree.Decl.EMPTY_ARRAY));
    }

    @Nullable
    private static IndexTree.ClassDecl processClassDecl(GrTypeDefinitionStub classStub, Set<String> namesCache, boolean inner) {
        Object name;
        ArrayList<String> superList = new ArrayList<String>();
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        if (classStub.isAnonymous() && (name = classStub.getBaseClassName()) != null) {
            superList.add(GrStubIndexer.id((String)name, true, namesCache));
        }
        for (StubElement el : classStub.getChildrenStubs()) {
            IndexTree.Decl member;
            if (el instanceof GrReferenceListStub) {
                GrReferenceListStub refList = (GrReferenceListStub)el;
                if (el.getStubType() == GroovyStubElementTypes.IMPLEMENTS_CLAUSE || el.getStubType() == GroovyStubElementTypes.EXTENDS_CLAUSE) {
                    for (String extName : refList.getBaseClasses()) {
                        superList.add(GrStubIndexer.id(extName, true, namesCache));
                    }
                }
            }
            if ((member = GrStubIndexer.processMember(el, namesCache)) == null) continue;
            innerList.add(member);
        }
        int flags = GrStubIndexer.translateFlags(classStub);
        if (inner && !superList.isEmpty()) {
            flags |= 0x200;
        }
        String[] supers = superList.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(superList);
        IndexTree.Decl[] inners = innerList.isEmpty() ? IndexTree.Decl.EMPTY_ARRAY : innerList.toArray(IndexTree.Decl.EMPTY_ARRAY);
        return new IndexTree.ClassDecl(classStub.getStubId(), flags, classStub.getName(), supers, inners);
    }

    private static int translateFlags(GrTypeDefinitionStub classStub) {
        int flags = 0;
        flags = BitUtil.set((int)flags, (int)64, (boolean)classStub.isEnum());
        flags = BitUtil.set((int)flags, (int)32, (boolean)classStub.isAnnotationType());
        return flags;
    }

    private static void processImport(GrImportStatementStub imp, List<? super IndexTree.Import> imports2, Set<String> namesCache) {
        String fullName = imp.getFqn();
        if (fullName == null) {
            return;
        }
        if (imp.isOnDemand() || namesCache.contains(GrStubIndexer.shortName(fullName))) {
            imports2.add((IndexTree.Import)new IndexTree.Import(fullName, imp.isStatic(), imp.isOnDemand(), imp.getAliasName()));
        }
    }

    private static String id(String s, boolean cacheFirstId, Set<? super String> namesCache) {
        String id = PsiNameHelper.getQualifiedClassName((String)s, (boolean)true);
        if (cacheFirstId) {
            int index = id.indexOf(46);
            String firstId = index > 0 ? s.substring(0, index) : id;
            namesCache.add(firstId);
        }
        return id;
    }

    private static String shortName(String s) {
        int dotIndex = s.lastIndexOf(46);
        return dotIndex > 0 ? s.substring(dotIndex + 1) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/hierarchy/GrStubIndexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handlesFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

