/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReassignedLocalVarsChecker {
    @Nullable
    public static Boolean isReassignedVar(@NotNull GrReferenceExpression refExpr) {
        if (refExpr == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isCompileStatic(refExpr)) {
            return false;
        }
        if (refExpr.getQualifier() != null) {
            return false;
        }
        PsiElement resolved = refExpr.resolve();
        if (!PsiUtil.isLocalVariable(resolved)) {
            return false;
        }
        assert (resolved instanceof GrVariable);
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)resolved, () -> CachedValueProvider.Result.create((Object)GrReassignedLocalVarsChecker.isReassignedVarImpl((GrVariable)resolved), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isReassignedVarImpl(@NotNull GrVariable resolved) {
        GrControlFlowOwner variableScope;
        if (resolved == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(1);
        }
        if ((variableScope = (GrControlFlowOwner)PsiTreeUtil.getParentOfType((PsiElement)resolved, (Class[])new Class[]{GrCodeBlock.class, GroovyFile.class})) == null) {
            return false;
        }
        final String name = resolved.getName();
        final Ref isReassigned = Ref.create((Object)false);
        for (PsiElement scope = resolved.getParent().getNextSibling(); scope != null; scope = scope.getNextSibling()) {
            if (!(scope instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)scope).accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitClosure(@NotNull GrClosableBlock closure) {
                    if (closure == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(closure).contains(name)) {
                        isReassigned.set((Object)true);
                    }
                }

                @Override
                public void visitLambdaBody(@NotNull GrLambdaBody body) {
                    if (body == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(body).contains(name)) {
                        isReassigned.set((Object)true);
                    }
                }

                @Override
                public void visitElement(@NotNull GroovyPsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (((Boolean)isReassigned.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "closure";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "body";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReassignedLocalVarsChecker$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClosure";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaBody";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (((Boolean)isReassigned.get()).booleanValue()) break;
        }
        return (Boolean)isReassigned.get();
    }

    @Nullable
    public static PsiType getReassignedVarType(GrReferenceExpression refExpr, boolean honorCompileStatic) {
        if (honorCompileStatic && !PsiUtil.isCompileStatic(refExpr) || refExpr.getQualifier() != null) {
            return null;
        }
        PsiElement resolved = refExpr.resolve();
        if (!PsiUtil.isLocalVariable(resolved)) {
            return null;
        }
        assert (resolved instanceof GrVariable);
        return TypeInferenceHelper.getCurrentContext().getExpressionType((GrVariable)resolved, variable -> GrReassignedLocalVarsChecker.getLeastUpperBoundByVar(variable));
    }

    @Nullable
    private static PsiType getLeastUpperBoundByVar(@NotNull GrVariable var) {
        if (var == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(2);
        }
        return (PsiType)RecursionManager.doPreventingRecursion((Object)var, (boolean)false, (Computable)((NullableComputable)() -> {
            Collection all = ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).findAll();
            GrExpression initializer = var.getInitializerGroovy();
            if (initializer == null && all.isEmpty()) {
                return var.getDeclaredType();
            }
            PsiType result2 = initializer != null ? initializer.getType() : null;
            PsiManager manager = var.getManager();
            for (PsiReference reference : all) {
                PsiElement ref = reference.getElement();
                if (!(ref instanceof GrReferenceExpression) || !PsiUtil.isLValue((GrReferenceExpression)ref)) continue;
                result2 = TypesUtil.getLeastUpperBoundNullable(result2, TypeInferenceHelper.getInitializerTypeFor(ref), manager);
            }
            return result2;
        }));
    }

    @NotNull
    private static Set<String> getUsedVarsInsideBlock(@NotNull GroovyPsiElement element) {
        if (element == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(3);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            final HashSet result2 = ContainerUtil.newHashSet();
            element.acceptChildren(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitOpenBlock(@NotNull GrOpenBlock openBlock) {
                    if (openBlock == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    result2.addAll(GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(openBlock));
                }

                @Override
                public void visitClosure(@NotNull GrClosableBlock closure) {
                    if (closure == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    result2.addAll(GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(closure));
                }

                @Override
                public void visitLambdaBody(@NotNull GrLambdaBody body) {
                    if (body == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    result2.addAll(GrReassignedLocalVarsChecker.getUsedVarsInsideBlock(body));
                }

                @Override
                public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                    if (referenceExpression == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (referenceExpression.getQualifier() == null && referenceExpression.getReferenceName() != null) {
                        result2.add(referenceExpression.getReferenceName());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "openBlock";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "closure";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "body";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "referenceExpression";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReassignedLocalVarsChecker$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitOpenBlock";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClosure";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaBody";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{element});
        });
        if (set == null) {
            GrReassignedLocalVarsChecker.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReassignedLocalVarsChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReassignedLocalVarsChecker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedVarsInsideBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReassignedVar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReassignedVarImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLeastUpperBoundByVar";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVarsInsideBlock";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

