/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.NestedContextKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesReachingDefinitionsInstance;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.PartialContext;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeInferenceHelper {
    private static final ThreadLocal<InferenceContext> ourInferenceContext = new ThreadLocal();

    static <T> T doInference(@NotNull Map<String, PsiType> bindings, @NotNull Computable<? extends T> computation) {
        if (bindings == null) {
            TypeInferenceHelper.$$$reportNull$$$0(0);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            NestedContextKt.checkNestedContext();
        }
        return TypeInferenceHelper.withContext(new PartialContext(bindings), computation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withContext(@NotNull InferenceContext context, @NotNull Computable<? extends T> computation) {
        if (context == null) {
            TypeInferenceHelper.$$$reportNull$$$0(2);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(3);
        }
        InferenceContext previous = ourInferenceContext.get();
        ourInferenceContext.set(context);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            ourInferenceContext.set(previous);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static InferenceContext getCurrentContext() {
        InferenceContext context = ourInferenceContext.get();
        InferenceContext inferenceContext = context != null ? context : TypeInferenceHelper.getTopContext();
        if (inferenceContext == null) {
            TypeInferenceHelper.$$$reportNull$$$0(4);
        }
        return inferenceContext;
    }

    public static <T> T inTopContext(@NotNull Computable<? extends T> computation) {
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(5);
        }
        return TypeInferenceHelper.withContext(TypeInferenceHelper.getTopContext(), computation);
    }

    @NotNull
    @Contract(pure=true)
    public static InferenceContext getTopContext() {
        InferenceContext inferenceContext = InferenceContext.TOP_CONTEXT;
        if (inferenceContext == null) {
            TypeInferenceHelper.$$$reportNull$$$0(6);
        }
        return inferenceContext;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull GrReferenceExpression refExpr) {
        GrControlFlowOwner scope;
        if (refExpr == null) {
            TypeInferenceHelper.$$$reportNull$$$0(7);
        }
        if ((scope = ControlFlowUtils.findControlFlowOwner(refExpr)) == null) {
            return null;
        }
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        if (cache2 == null) {
            return null;
        }
        PsiElement resolve2 = refExpr.resolve();
        boolean mixinOnly = resolve2 instanceof GrField && PsiUtil.isCompileStatic(refExpr);
        String referenceName = refExpr.getReferenceName();
        if (referenceName == null) {
            return null;
        }
        ReadWriteVariableInstruction rwInstruction = ControlFlowUtils.findRWInstruction(refExpr, scope.getControlFlow());
        if (rwInstruction == null) {
            return null;
        }
        return cache2.getInferredType(referenceName, rwInstruction, mixinOnly);
    }

    @Nullable
    public static PsiType getInferredType(String referenceName, Instruction instruction, GrControlFlowOwner scope) {
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        return cache2 != null ? cache2.getInferredType(referenceName, instruction, false) : null;
    }

    @Nullable
    public static PsiType getVariableTypeInContext(@Nullable PsiElement context, @NotNull GrVariable variable) {
        if (variable == null) {
            TypeInferenceHelper.$$$reportNull$$$0(8);
        }
        if (context == null) {
            return variable.getType();
        }
        GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(context);
        if (scope == null) {
            return null;
        }
        Instruction nearest = ControlFlowUtils.findNearestInstruction(context, scope.getControlFlow());
        if (nearest == null) {
            return null;
        }
        boolean mixinOnly = variable instanceof GrField && PsiUtil.isCompileStatic(scope);
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        if (cache2 == null) {
            return null;
        }
        PsiType inferredType = cache2.getInferredType(variable.getName(), nearest, mixinOnly);
        return inferredType != null ? inferredType : variable.getType();
    }

    public static boolean isTooComplexTooAnalyze(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(9);
        }
        return TypeInferenceHelper.getInferenceCache(scope) == null;
    }

    @Nullable
    private static InferenceCache getInferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(10);
        }
        return (InferenceCache)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create((Object)TypeInferenceHelper.createInferenceCache(scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static InferenceCache createInferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(11);
        }
        TObjectIntHashMap<String> varIndexes = UtilKt.getVarIndexes(scope);
        List<DefinitionMap> defUse = TypeInferenceHelper.getDefUseMaps(scope.getControlFlow(), varIndexes);
        if (defUse == null) {
            return null;
        }
        return new InferenceCache(scope, varIndexes, defUse);
    }

    @Nullable
    private static List<DefinitionMap> getDefUseMaps(@NotNull Instruction[] flow, @NotNull TObjectIntHashMap<String> varIndexes) {
        if (flow == null) {
            TypeInferenceHelper.$$$reportNull$$$0(12);
        }
        if (varIndexes == null) {
            TypeInferenceHelper.$$$reportNull$$$0(13);
        }
        TypesReachingDefinitionsInstance dfaInstance = new TypesReachingDefinitionsInstance(flow, varIndexes);
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance, lattice);
        return engine.performDFAWithTimeout();
    }

    @Nullable
    public static PsiType getInitializerType(PsiElement element) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifierExpression() == null) {
            return TypeInferenceHelper.getInitializerTypeFor(element);
        }
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        return null;
    }

    @Nullable
    public static PsiType getInitializerTypeFor(PsiElement element) {
        GrTuple list;
        GrTupleAssignmentExpression assignment;
        PsiElement parent2 = PsiUtil.skipParentheses(element.getParent(), true);
        if (parent2 instanceof GrAssignmentExpression) {
            if (element instanceof GrIndexProperty) {
                GrExpression rvalue = ((GrAssignmentExpression)parent2).getRValue();
                return rvalue != null ? rvalue.getType() : null;
            }
            return ((GrAssignmentExpression)parent2).getType();
        }
        if (parent2 instanceof GrTuple && (assignment = (list = (GrTuple)parent2).getParent()) != null) {
            GrExpression rValue = assignment.getRValue();
            int idx = list.indexOf(element);
            if (idx >= 0 && rValue != null) {
                PsiType rType = rValue.getType();
                if (rType instanceof GrTupleType) {
                    List<PsiType> componentTypes = ((GrTupleType)rType).getComponentTypes();
                    if (idx < componentTypes.size()) {
                        return componentTypes.get(idx);
                    }
                    return null;
                }
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)rType, (boolean)false);
            }
        }
        if (parent2 instanceof GrUnaryExpression && TokenSets.POSTFIX_UNARY_OP_SET.contains(((GrUnaryExpression)parent2).getOperationTokenType())) {
            return ((GrUnaryExpression)parent2).getType();
        }
        return null;
    }

    @Nullable
    public static GrExpression getInitializerFor(GrExpression lValue) {
        PsiElement parent2 = lValue.getParent();
        if (parent2 instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent2).getRValue();
        }
        if (parent2 instanceof GrTuple) {
            GrExpression[] initializers;
            int i = ((GrTuple)parent2).indexOf(lValue);
            GrTupleAssignmentExpression grandParent = ((GrTuple)parent2).getParent();
            PsiUtil.LOG.assertTrue(grandParent != null);
            GrExpression rValue = grandParent.getRValue();
            if (rValue instanceof GrListOrMap && !((GrListOrMap)rValue).isMap() && i < (initializers = ((GrListOrMap)rValue).getInitializers()).length) {
                return initializers[i];
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varIndexes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withContext";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inTopContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeInContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTooComplexTooAnalyze";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createInferenceCache";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefUseMaps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

