/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.OrderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.FragmentVariableInfos;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunnerKt;

public class ReachingDefinitionsCollector {
    private ReachingDefinitionsCollector() {
    }

    @NotNull
    public static FragmentVariableInfos obtainVariableFlowInformation(@NotNull GrStatement first, @NotNull GrStatement last, @NotNull GrControlFlowOwner flowOwner, @NotNull Instruction[] flow) {
        String name;
        if (first == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(0);
        }
        if (last == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(1);
        }
        if (flowOwner == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(2);
        }
        if (flow == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(3);
        }
        DefinitionMap dfaResult = ReachingDefinitionsCollector.inferDfaResult(flowOwner, flow);
        LinkedHashSet<Integer> fragmentInstructions = ReachingDefinitionsCollector.getFragmentInstructions(first, last, flow);
        int[] postorder = OrderUtil.reversedPostOrder(flow);
        LinkedHashSet<Integer> reachableFromFragmentReads = ReachingDefinitionsCollector.getReachable(fragmentInstructions, flow, dfaResult, postorder);
        LinkedHashSet<Integer> fragmentReads = ReachingDefinitionsCollector.filterReads(fragmentInstructions, flow);
        final LinkedHashMap<String, VariableInfo> imap = new LinkedHashMap<String, VariableInfo>();
        final LinkedHashMap<String, VariableInfo> omap = new LinkedHashMap<String, VariableInfo>();
        PsiManager manager = first.getManager();
        for (Integer ref : fragmentReads) {
            ReadWriteVariableInstruction rwInstruction = (ReadWriteVariableInstruction)flow[ref];
            int[] defs = dfaResult.getDefinitions(ref);
            assert (defs != null);
            name = rwInstruction.getVariableName();
            if (ReachingDefinitionsCollector.allDefsInFragment(defs, fragmentInstructions) && !ReachingDefinitionsCollector.isDeclaredOutOf(rwInstruction.getElement(), name, flowOwner)) continue;
            ReachingDefinitionsCollector.addVariable(name, imap, manager, ReachingDefinitionsCollector.getType(rwInstruction.getElement()));
        }
        Set<Integer> outerBound = ReachingDefinitionsCollector.getFragmentOuterBound(fragmentInstructions, flow);
        for (Integer ref : reachableFromFragmentReads) {
            ReadWriteVariableInstruction rwInstruction = (ReadWriteVariableInstruction)flow[ref];
            name = rwInstruction.getVariableName();
            int[] defs = dfaResult.getDefinitions(ref);
            assert (defs != null);
            if (!ReachingDefinitionsCollector.anyDefInFragment(defs, fragmentInstructions)) continue;
            for (int insnNum : outerBound) {
                ReachingDefinitionsCollector.addVariable(name, omap, manager, ReachingDefinitionsCollector.getVariableTypeAt(flowOwner, flow[insnNum], name));
            }
            if (ReachingDefinitionsCollector.allProperDefsInFragment(defs, ref, fragmentInstructions, postorder)) continue;
            PsiType inputType = ReachingDefinitionsCollector.getType(rwInstruction.getElement());
            ReachingDefinitionsCollector.addVariable(name, imap, manager, inputType);
        }
        ReachingDefinitionsCollector.addClosureUsages(imap, omap, first, last, flowOwner);
        FragmentVariableInfos fragmentVariableInfos = new FragmentVariableInfos(){

            @Override
            public VariableInfo[] getInputVariableNames() {
                return imap.values().toArray(VariableInfo.EMPTY_ARRAY);
            }

            @Override
            public VariableInfo[] getOutputVariableNames() {
                return omap.values().toArray(VariableInfo.EMPTY_ARRAY);
            }
        };
        if (fragmentVariableInfos == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(4);
        }
        return fragmentVariableInfos;
    }

    private static PsiType getVariableTypeAt(GrControlFlowOwner flowOwner, Instruction instruction, String name) {
        GrVariable variable;
        PsiElement context = instruction.getElement();
        PsiType outputType = TypeInferenceHelper.getInferredType(name, instruction, flowOwner);
        if (outputType == null && (variable = ReachingDefinitionsCollector.resolveToLocalVariable(context, name)) != null) {
            outputType = variable.getDeclaredType();
        }
        return outputType;
    }

    @Nullable
    private static GrVariable resolveToLocalVariable(@Nullable PsiElement element, @NotNull String name) {
        if (name == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return null;
        }
        ElementResolveResult<GrVariable> result2 = GrReferenceResolveRunnerKt.resolveToLocalVariable(element, name);
        return result2 != null ? result2.getElement() : null;
    }

    private static boolean isDeclaredOutOf(@Nullable PsiElement element, @NotNull String name, @NotNull GrControlFlowOwner flowOwner) {
        if (name == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(6);
        }
        if (flowOwner == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(7);
        }
        if (element == null) {
            return false;
        }
        GrVariable variable = ReachingDefinitionsCollector.resolveToLocalVariable(element, name);
        if (variable == null) {
            return false;
        }
        return !PsiImplUtilKt.isDeclaredIn(variable, flowOwner);
    }

    @NotNull
    private static DefinitionMap inferDfaResult(@NotNull GrControlFlowOwner owner, @NotNull Instruction[] flow) {
        if (owner == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(8);
        }
        if (flow == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(9);
        }
        TObjectIntHashMap<String> varIndexes = UtilKt.getVarIndexes(owner);
        ReachingDefinitionsDfaInstance dfaInstance = new ReachingDefinitionsDfaInstance(flow, varIndexes);
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance, lattice);
        DefinitionMap definitionMap = ReachingDefinitionsCollector.postprocess(engine.performForceDFA(), flow, varIndexes);
        if (definitionMap == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(10);
        }
        return definitionMap;
    }

    private static void addClosureUsages(final Map<String, VariableInfo> imap, final Map<String, VariableInfo> omap, final GrStatement first, final GrStatement last, GrControlFlowOwner flowOwner) {
        flowOwner.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.addUsagesInClosure(imap, omap, closure, first, last);
                super.visitClosure(closure);
            }

            private void addUsagesInClosure(final Map<String, VariableInfo> imap2, final Map<String, VariableInfo> omap2, final GrClosableBlock closure, final GrStatement first2, final GrStatement last2) {
                closure.accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
                        if (refExpr == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (refExpr.isQualified()) {
                            return;
                        }
                        String name = refExpr.getReferenceName();
                        if (name == null) {
                            return;
                        }
                        GrVariable variable = ReachingDefinitionsCollector.resolveToLocalVariable(refExpr, name);
                        if (variable == null) {
                            return;
                        }
                        if (PsiImplUtilKt.isDeclaredIn(variable, closure)) {
                            return;
                        }
                        if (!(variable instanceof GrField)) {
                            if (!ReachingDefinitionsCollector.isInFragment(first2, last2, variable)) {
                                if (ReachingDefinitionsCollector.isInFragment(first2, last2, closure)) {
                                    ReachingDefinitionsCollector.addVariable(name, imap2, variable.getManager(), variable.getType());
                                }
                            } else if (!ReachingDefinitionsCollector.isInFragment(first2, last2, closure)) {
                                ReachingDefinitionsCollector.addVariable(name, omap2, variable.getManager(), variable.getType());
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$2$1", "visitReferenceExpression"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$2", "visitClosure"));
            }
        });
    }

    private static void addVariable(String name, Map<String, VariableInfo> map2, PsiManager manager, PsiType type2) {
        VariableInfoImpl info = (VariableInfoImpl)map2.get(name);
        if (info == null) {
            info = new VariableInfoImpl(name, manager);
            map2.put(name, info);
        }
        info.addSubtype(type2);
    }

    private static LinkedHashSet<Integer> filterReads(LinkedHashSet<Integer> instructions, Instruction[] flow) {
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>();
        for (Integer i : instructions) {
            Instruction instruction = flow[i];
            if (!ReachingDefinitionsCollector.isReadInsn(instruction)) continue;
            result2.add(i);
        }
        return result2;
    }

    private static boolean allDefsInFragment(int[] defs, LinkedHashSet<Integer> fragmentInstructions) {
        for (int def : defs) {
            if (fragmentInstructions.contains(def)) continue;
            return false;
        }
        return true;
    }

    private static boolean allProperDefsInFragment(int[] defs, int ref, LinkedHashSet<Integer> fragmentInstructions, int[] postorder) {
        for (int def : defs) {
            if (fragmentInstructions.contains(def) || postorder[def] >= postorder[ref]) continue;
            return false;
        }
        return true;
    }

    private static boolean anyDefInFragment(int[] defs, LinkedHashSet<Integer> fragmentInstructions) {
        for (int def : defs) {
            if (!fragmentInstructions.contains(def)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiType getType(PsiElement element) {
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        if (element instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)element).getType();
        }
        return null;
    }

    private static LinkedHashSet<Integer> getFragmentInstructions(GrStatement first, GrStatement last, Instruction[] flow) {
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>();
        for (Instruction instruction : flow) {
            if (!ReachingDefinitionsCollector.isInFragment(instruction, first, last)) continue;
            result2.add(instruction.num());
        }
        return result2;
    }

    private static boolean isInFragment(Instruction instruction, GrStatement first, GrStatement last) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            return false;
        }
        return ReachingDefinitionsCollector.isInFragment(first, last, element);
    }

    private static boolean isInFragment(GrStatement first, GrStatement last, PsiElement element) {
        PsiElement parent2 = first.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)parent2, (PsiElement)element, (boolean)true)) {
            return false;
        }
        PsiElement run = element;
        while (run.getParent() != parent2) {
            run = run.getParent();
        }
        return ReachingDefinitionsCollector.isBetween(first, last, run);
    }

    private static boolean isBetween(PsiElement first, PsiElement last, PsiElement run) {
        while (first != null && first != run) {
            first = first.getNextSibling();
        }
        if (first == null) {
            return false;
        }
        while (last != null && last != run) {
            last = last.getPrevSibling();
        }
        return last != null;
    }

    private static LinkedHashSet<Integer> getReachable(LinkedHashSet<Integer> fragmentInsns, Instruction[] flow, DefinitionMap dfaResult, int[] postorder) {
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>();
        block0: for (Instruction insn : flow) {
            int ref;
            int[] definitions;
            if (!ReachingDefinitionsCollector.isReadInsn(insn) || (definitions = dfaResult.getDefinitions(ref = insn.num())) == null) continue;
            for (int def : definitions) {
                if (!fragmentInsns.contains(def) || fragmentInsns.contains(ref) && (postorder[ref] >= postorder[def] || !ReachingDefinitionsCollector.checkPathIsOutsideOfFragment(def, ref, flow, fragmentInsns))) continue;
                result2.add(ref);
                continue block0;
            }
        }
        return result2;
    }

    private static Set<Integer> getFragmentOuterBound(@NotNull LinkedHashSet<Integer> fragmentInstructions, @NotNull Instruction[] flow) {
        if (fragmentInstructions == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(11);
        }
        if (flow == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(12);
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        for (Integer num : fragmentInstructions) {
            for (Instruction successor : flow[num].allSuccessors()) {
                if (fragmentInstructions.contains(successor.num())) continue;
                result2.add(num);
            }
        }
        return result2;
    }

    private static boolean checkPathIsOutsideOfFragment(int def, int ref, Instruction[] flow, LinkedHashSet<Integer> fragmentInsns) {
        Boolean path = ReachingDefinitionsCollector.findPath(flow[def], ref, fragmentInsns, false, new HashMap<Instruction, Boolean>());
        assert (path != null) : "def=" + def + ", ref=" + ref;
        return path;
    }

    @Nullable
    private static Boolean findPath(Instruction cur, int destination, LinkedHashSet<Integer> fragmentInsns, boolean wasOutside, HashMap<Instruction, Boolean> visited) {
        wasOutside = wasOutside || !fragmentInsns.contains(cur.num());
        visited.put(cur, null);
        Iterable<Instruction> instructions = cur.allSuccessors();
        boolean pathExists = false;
        for (Instruction i : instructions) {
            Boolean result2;
            if (i.num() == destination) {
                return wasOutside;
            }
            if (visited.containsKey(i)) {
                result2 = visited.get(i);
            } else {
                result2 = ReachingDefinitionsCollector.findPath(i, destination, fragmentInsns, wasOutside, visited);
                visited.put(i, result2);
            }
            if (result2 == null) continue;
            if (result2.booleanValue()) {
                visited.put(cur, true);
                return true;
            }
            pathExists = true;
        }
        if (pathExists) {
            visited.put(cur, false);
            return false;
        }
        visited.put(cur, null);
        return null;
    }

    private static boolean isReadInsn(Instruction insn) {
        return insn instanceof ReadWriteVariableInstruction && !((ReadWriteVariableInstruction)insn).isWrite();
    }

    private static String dumpDfaResult(ArrayList<TIntObjectHashMap<TIntHashSet>> dfaResult, ReachingDefinitionsDfaInstance dfa) {
        final StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < dfaResult.size(); ++i) {
            TIntObjectHashMap<TIntHashSet> map2 = dfaResult.get(i);
            buffer.append("At ").append(i).append(":\n");
            map2.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntHashSet>(){

                public boolean execute(int i, TIntHashSet defs) {
                    buffer.append(i).append(" -> ");
                    defs.forEach(i1 -> {
                        buffer.append(i1).append(" ");
                        return true;
                    });
                    return true;
                }
            });
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @NotNull
    private static DefinitionMap postprocess(@NotNull List<DefinitionMap> dfaResult, @NotNull Instruction[] flow, @NotNull TObjectIntHashMap<String> varIndexes) {
        if (dfaResult == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(13);
        }
        if (flow == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(14);
        }
        if (varIndexes == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(15);
        }
        DefinitionMap result2 = new DefinitionMap();
        for (int i = 0; i < flow.length; ++i) {
            ReadWriteVariableInstruction rwInsn;
            Instruction insn = flow[i];
            if (!(insn instanceof ReadWriteVariableInstruction) || (rwInsn = (ReadWriteVariableInstruction)insn).isWrite()) continue;
            int idx = varIndexes.get((Object)rwInsn.getVariableName());
            result2.copyFrom(dfaResult.get(i), idx, i);
        }
        DefinitionMap definitionMap = result2;
        if (definitionMap == null) {
            ReachingDefinitionsCollector.$$$reportNull$$$0(16);
        }
        return definitionMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowOwner";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 4: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentInstructions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaResult";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varIndexes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainVariableFlowInformation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inferDfaResult";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "postprocess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainVariableFlowInformation";
                break;
            }
            case 4: 
            case 10: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveToLocalVariable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredOutOf";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inferDfaResult";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentOuterBound";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "postprocess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VariableInfoImpl
    implements VariableInfo {
        @NotNull
        private final String myName;
        private final PsiManager myManager;
        @Nullable
        private PsiType myType;

        VariableInfoImpl(@NotNull String name, PsiManager manager) {
            if (name == null) {
                VariableInfoImpl.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myManager = manager;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                VariableInfoImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public PsiType getType() {
            if (this.myType instanceof PsiIntersectionType) {
                return ((PsiIntersectionType)this.myType).getConjuncts()[0];
            }
            return this.myType;
        }

        void addSubtype(PsiType t) {
            if (t != null) {
                if (this.myType == null) {
                    this.myType = t;
                } else if (!this.myType.isAssignableFrom(t)) {
                    this.myType = t.isAssignableFrom(this.myType) ? t : TypesUtil.getLeastUpperBound(this.myType, t, this.myManager);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$VariableInfoImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$VariableInfoImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

