/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrTryResourceList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AfterCallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.GotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.InstanceOfInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.PositiveGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrResolverPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ThrowingInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class ControlFlowBuilder
extends GroovyRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance(ControlFlowBuilder.class);
    private final List<InstructionImpl> myInstructions = new ArrayList<InstructionImpl>();
    private final Deque<InstructionImpl> myProcessingStack = new ArrayDeque<InstructionImpl>();
    private final PsiConstantEvaluationHelper myConstantEvaluator;
    private GroovyPsiElement myScope;
    private final Deque<ExceptionInfo> myCaughtExceptionInfos = new ArrayDeque<ExceptionInfo>();
    private FList<ConditionInstruction> myConditions = FList.emptyList();
    private int myFinallyCount;
    private InstructionImpl myHead;
    private List<Pair<InstructionImpl, GroovyPsiElement>> myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
    private int myInstructionNumber;
    private final GrControlFlowPolicy myPolicy;

    public ControlFlowBuilder(Project project) {
        this(project, GrResolverPolicy.getInstance());
    }

    public ControlFlowBuilder(Project project, GrControlFlowPolicy policy) {
        this.myPolicy = policy;
        this.myConstantEvaluator = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        GrStatement[] statements;
        if (block == null) {
            ControlFlowBuilder.$$$reportNull$$$0(0);
        }
        PsiElement parent2 = block.getParent();
        PsiElement lbrace = block.getLBrace();
        if (lbrace != null && parent2 instanceof GrMethod) {
            for (GrParameter parameter : ((GrMethod)parent2).getParameters()) {
                String parameterName = parameter.getName();
                if (!this.myPolicy.isVariableInitialized(parameter) || parameterName == null) continue;
                this.addNode(new ReadWriteVariableInstruction(parameterName, parameter, -1));
            }
        }
        super.visitOpenBlock(block);
        if (!(block.getParent() instanceof GrBlockStatement && block.getParent().getParent() instanceof GrLoopStatement || (statements = block.getStatements()).length <= 0)) {
            this.handlePossibleReturn(statements[statements.length - 1]);
        }
    }

    @Override
    public void visitExpressionLambdaBody(@NotNull GrExpressionLambdaBody body) {
        if (body == null) {
            ControlFlowBuilder.$$$reportNull$$$0(1);
        }
        this.addFunctionalExpressionParameters(body.getLambdaExpression());
        body.getExpression().accept(this);
    }

    @Override
    public void visitBlockLambdaBody(@NotNull GrBlockLambdaBody body) {
        if (body == null) {
            ControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.addFunctionalExpressionParameters(body.getLambdaExpression());
        this.addControlFlowInstructions(body);
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            ControlFlowBuilder.$$$reportNull$$$0(3);
        }
        super.visitFile(file);
        GrStatement[] statements = file.getStatements();
        if (statements.length > 0) {
            this.handlePossibleReturn(statements[statements.length - 1]);
        }
    }

    @Nullable
    private InstructionImpl handlePossibleReturn(@NotNull GrStatement possibleReturn) {
        if (possibleReturn == null) {
            ControlFlowBuilder.$$$reportNull$$$0(4);
        }
        if (possibleReturn instanceof GrExpression && ControlFlowBuilderUtil.isCertainlyReturnStatement(possibleReturn)) {
            return this.addNodeAndCheckPending(new MaybeReturnInstruction((GrExpression)possibleReturn));
        }
        return null;
    }

    public Instruction[] buildControlFlow(GroovyPsiElement scope) {
        if (scope instanceof GrLambdaExpression) {
            GrLambdaBody body = ((GrLambdaExpression)scope).getBody();
            return body != null ? body.getControlFlow() : Instruction.EMPTY_ARRAY;
        }
        this.myFinallyCount = 0;
        this.myInstructionNumber = 0;
        this.myScope = scope;
        this.startNode(null);
        if (scope instanceof GrClosableBlock) {
            this.addFunctionalExpressionParameters((GrFunctionalExpression)scope);
            this.addControlFlowInstructions((GrStatementOwner)scope);
        } else {
            scope.accept(this);
        }
        InstructionImpl end = this.startNode(null);
        this.checkPending(end);
        return ControlFlowBuilder.assertValidPsi(this.myInstructions.toArray(Instruction.EMPTY_ARRAY));
    }

    public static Instruction[] assertValidPsi(Instruction[] instructions) {
        return instructions;
    }

    private void addControlFlowInstructions(GrStatementOwner owner) {
        for (PsiElement child = owner.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(this);
        }
        GrStatement[] statements = owner.getStatements();
        if (statements.length > 0) {
            this.handlePossibleReturn(statements[statements.length - 1]);
        }
    }

    private void addFunctionalExpressionParameters(GrFunctionalExpression expression) {
        for (GrParameter parameter : expression.getAllParameters()) {
            String parameterName = parameter.getName();
            if (!this.myPolicy.isVariableInitialized(parameter) || parameterName == null) continue;
            this.addNode(new ReadWriteVariableInstruction(parameterName, parameter, -1));
        }
        PsiElement anchor = expression.getArrow();
        if (expression instanceof GrClosableBlock) {
            anchor = ((GrClosableBlock)expression).getLBrace();
        }
        this.addNode(new ReadWriteVariableInstruction("owner", anchor, -1));
    }

    private <T extends InstructionImpl> T addNode(T instruction) {
        instruction.setNumber(this.myInstructionNumber++);
        this.myInstructions.add(instruction);
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, instruction);
        }
        this.myHead = instruction;
        return instruction;
    }

    private <T extends InstructionImpl> T addNodeAndCheckPending(T i) {
        this.addNode(i);
        this.checkPending(i);
        return i;
    }

    private static void addEdge(InstructionImpl begin, InstructionImpl end) {
        begin.addSuccessor(end);
        end.addPredecessor(begin);
        if (!(begin instanceof MixinTypeInstruction)) {
            end.addNegationsFrom(begin);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        GrLambdaBody body;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(5);
        }
        if ((body = expression.getBody()) == null) {
            return;
        }
        ReadWriteVariableInstruction[] reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(body.getControlFlow(), false);
        this.addReadFromNestedControlFlow(expression, reads);
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            ControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (closure.getParent() instanceof GrStringInjection) {
            this.addFunctionalExpressionParameters(closure);
            super.visitClosure(closure);
            return;
        }
        ReadWriteVariableInstruction[] reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(closure.getControlFlow(), false);
        this.addReadFromNestedControlFlow(closure, reads);
    }

    private void addReadFromNestedControlFlow(@NotNull PsiElement anchor, @NotNull ReadWriteVariableInstruction[] reads) {
        if (anchor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(7);
        }
        if (reads == null) {
            ControlFlowBuilder.$$$reportNull$$$0(8);
        }
        for (ReadWriteVariableInstruction read : reads) {
            PsiElement element = read.getElement();
            if (element instanceof GrReferenceExpression && !this.myPolicy.isReferenceAccepted((GrReferenceExpression)element)) continue;
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(read.getVariableName(), anchor, 1));
        }
        this.addNodeAndCheckPending(new InstructionImpl(anchor));
    }

    @Override
    public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
        if (breakStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(9);
        }
        super.visitBreakStatement(breakStatement);
        GrStatement target = breakStatement.resolveLabel();
        if (target == null) {
            target = breakStatement.findTargetStatement();
        }
        if (target != null) {
            if (this.myHead != null) {
                this.addPendingEdge(target, this.myHead);
            }
            this.readdPendingEdge(target);
        }
        this.interruptFlow();
    }

    @Override
    public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
        InstructionImpl instruction;
        if (continueStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(10);
        }
        super.visitContinueStatement(continueStatement);
        GrStatement target = continueStatement.resolveLabel();
        if (target == null) {
            target = continueStatement.findTargetStatement();
        }
        if (target != null && (instruction = this.findInstruction(target)) != null) {
            if (this.myHead != null) {
                ControlFlowBuilder.addEdge(this.myHead, instruction);
            }
            this.checkPending(continueStatement, instruction);
        }
        this.interruptFlow();
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        if (returnStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(11);
        }
        boolean isNodeNeeded = this.myHead == null || this.myHead.getElement() != returnStatement;
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            value.accept(this);
        }
        if (isNodeNeeded) {
            InstructionImpl returnInstruction = this.startNode(returnStatement);
            this.addPendingEdge(null, this.myHead);
            this.finishNode(returnInstruction);
        } else {
            this.addPendingEdge(null, this.myHead);
        }
        this.interruptFlow();
    }

    @Override
    public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
        if (assertStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(12);
        }
        InstructionImpl assertInstruction = this.startNode(assertStatement);
        GrExpression assertion = assertStatement.getAssertion();
        if (assertion != null) {
            GrExpression errorMessage;
            assertion.accept(this);
            InstructionImpl positiveHead = this.myHead;
            List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(assertStatement);
            if (!negations.isEmpty()) {
                this.interruptFlow();
                this.reduceAllNegationsIntoInstruction(assertStatement, negations);
            }
            if ((errorMessage = assertStatement.getErrorMessage()) != null) {
                errorMessage.accept(this);
            }
            this.addNode(new ThrowingInstruction(assertStatement));
            PsiClassType type2 = TypesUtil.createTypeByFQClassName("java.lang.AssertionError", assertStatement);
            ExceptionInfo info = this.findCatch((PsiType)type2);
            if (info != null) {
                info.myThrowers.add(this.myHead);
            } else {
                this.addPendingEdge(null, this.myHead);
            }
            this.myHead = positiveHead;
        }
        this.finishNode(assertInstruction);
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        GrExpression exception;
        if (throwStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(13);
        }
        if ((exception = throwStatement.getException()) == null) {
            return;
        }
        exception.accept(this);
        ThrowingInstruction throwInstruction = new ThrowingInstruction(throwStatement);
        this.addNodeAndCheckPending(throwInstruction);
        this.interruptFlow();
        PsiType type2 = ControlFlowBuilder.getNominalTypeNoRecursion(exception);
        if (type2 != null) {
            ExceptionInfo info = this.findCatch(type2);
            if (info != null) {
                info.myThrowers.add(throwInstruction);
            } else {
                this.addPendingEdge(null, throwInstruction);
            }
        } else {
            this.addPendingEdge(null, throwInstruction);
        }
    }

    @Nullable
    private static PsiType getNominalTypeNoRecursion(@NotNull GrExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(14);
        }
        if (expression instanceof GrNewExpression) {
            return expression.getType();
        }
        if (expression instanceof GrReferenceExpression && ((GrReferenceExpression)expression).getQualifier() == null) {
            return ControlFlowBuilder.getTypeByRef((GrReferenceExpression)expression);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeByRef(@NotNull GrReferenceExpression invoked) {
        PsiElement resolved;
        if (invoked == null) {
            ControlFlowBuilder.$$$reportNull$$$0(15);
        }
        return (resolved = invoked.getStaticReference().resolve()) instanceof PsiVariable ? ((PsiVariable)resolved).getType() : null;
    }

    private void interruptFlow() {
        this.myHead = null;
    }

    @Nullable
    private ExceptionInfo findCatch(PsiType thrownType) {
        Iterator<ExceptionInfo> iterator2 = this.myCaughtExceptionInfos.descendingIterator();
        while (iterator2.hasNext()) {
            PsiType type2;
            ExceptionInfo info = iterator2.next();
            GrCatchClause clause = info.myClause;
            GrParameter parameter = clause.getParameter();
            if (parameter == null || !(type2 = parameter.getType()).isAssignableFrom(thrownType)) continue;
            return info;
        }
        return null;
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(16);
        }
        InstructionImpl instruction = this.startNode(labeledStatement);
        super.visitLabeledStatement(labeledStatement);
        this.finishNode(instruction);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        GrExpression rValue;
        String referenceName;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(17);
        }
        GrExpression lValue = expression.getLValue();
        if ((expression.isOperatorAssignment() || expression.getOperationTokenType() == GroovyElementTypes.T_ELVIS_ASSIGN) && lValue instanceof GrReferenceExpression && this.myPolicy.isReferenceAccepted((GrReferenceExpression)lValue) && (referenceName = ((GrReferenceExpression)lValue).getReferenceName()) != null) {
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(referenceName, lValue, 1));
        }
        if ((rValue = expression.getRValue()) != null) {
            rValue.accept(this);
        }
        lValue.accept(this);
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        GrExpression rValue;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(18);
        }
        if ((rValue = expression.getRValue()) != null) {
            rValue.accept(this);
        }
        expression.getLValue().accept(this);
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        GrExpression operand;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(19);
        }
        if ((operand = expression.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
        GrExpression operand;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(20);
        }
        if ((operand = expression.getOperand()) == null) {
            return;
        }
        if (expression.getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            operand.accept(this);
            this.visitCall(expression);
            return;
        }
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        ConditionInstruction cond = this.registerCondition(expression, false);
        this.addNodeAndCheckPending(cond);
        operand.accept(this);
        this.visitCall(expression);
        this.myConditions = conditionsBefore;
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        InstructionImpl head = this.myHead;
        this.addNodeAndCheckPending(new PositiveGotoInstruction(expression, cond));
        this.handlePossibleReturn(expression);
        this.addPendingEdge(expression, this.myHead);
        this.myHead = negations.isEmpty() ? head : this.reduceAllNegationsIntoInstruction(expression, negations);
    }

    @Nullable
    private InstructionImpl reduceAllNegationsIntoInstruction(GroovyPsiElement currentScope, List<? extends GotoInstruction> negations) {
        if (negations.size() > 1) {
            InstructionImpl instruction = this.addNode(new InstructionImpl(currentScope));
            for (GotoInstruction gotoInstruction : negations) {
                ControlFlowBuilder.addEdge(gotoInstruction, instruction);
            }
            return instruction;
        }
        if (negations.size() == 1) {
            GotoInstruction instruction = negations.get(0);
            this.myHead = instruction;
            return instruction;
        }
        return null;
    }

    private List<GotoInstruction> collectAndRemoveAllPendingNegations(GroovyPsiElement currentScope) {
        ArrayList<GotoInstruction> negations = new ArrayList<GotoInstruction>();
        Iterator<Pair<InstructionImpl, GroovyPsiElement>> iterator2 = this.myPending.iterator();
        while (iterator2.hasNext()) {
            Pair<InstructionImpl, GroovyPsiElement> pair = iterator2.next();
            InstructionImpl instruction = (InstructionImpl)pair.first;
            GroovyPsiElement scope = (GroovyPsiElement)pair.second;
            if (PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)currentScope, (boolean)true) || !(instruction instanceof GotoInstruction)) continue;
            negations.add((GotoInstruction)instruction);
            iterator2.remove();
        }
        return negations;
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(21);
        }
        expression.getOperand().accept(this);
        this.processInstanceOf(expression, expression.getNegationToken() != null);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
        if (refExpr == null) {
            ControlFlowBuilder.$$$reportNull$$$0(22);
        }
        super.visitReferenceExpression(refExpr);
        if (this.myPolicy.isReferenceAccepted(refExpr)) {
            String name = refExpr.getReferenceName();
            if (name == null) {
                return;
            }
            if (ControlFlowUtils.isIncOrDecOperand(refExpr)) {
                ReadWriteVariableInstruction i = new ReadWriteVariableInstruction(name, refExpr, 1);
                this.addNodeAndCheckPending(i);
                this.addNode(new ReadWriteVariableInstruction(name, refExpr, -1));
            } else {
                int type2 = PsiUtil.isLValue(refExpr) ? -1 : 1;
                this.addNodeAndCheckPending(new ReadWriteVariableInstruction(name, refExpr, type2));
            }
        }
        if (refExpr.isQualified() && !(refExpr.getParent() instanceof GrCall)) {
            this.visitCall(refExpr);
        }
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        if (call == null) {
            ControlFlowBuilder.$$$reportNull$$$0(23);
        }
        super.visitMethodCall(call);
        this.addNodeAndCheckPending(new ArgumentsInstruction(call));
        this.visitCall(call);
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (invocation == null) {
            ControlFlowBuilder.$$$reportNull$$$0(24);
        }
        super.visitConstructorInvocation(invocation);
        this.addNodeAndCheckPending(new ArgumentsInstruction(invocation));
        this.visitCall(invocation);
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        if (newExpression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(25);
        }
        super.visitNewExpression(newExpression);
        this.addNodeAndCheckPending(new ArgumentsInstruction(newExpression));
        this.visitCall(newExpression);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(26);
        }
        GrExpression left = expression.getLeftOperand();
        GrExpression right = expression.getRightOperand();
        IElementType opType = expression.getOperationTokenType();
        if (ControlFlowBuilderUtil.isInstanceOfBinary(expression)) {
            expression.getLeftOperand().accept(this);
            this.processInstanceOf(expression, ((GrInExpression)expression).getNegationToken() != null);
            return;
        }
        if (opType == GroovyElementTypes.T_EQ || opType == GroovyElementTypes.T_NEQ) {
            if (PsiUtilKt.isNullLiteral(right)) {
                left.accept(this);
                this.processInstanceOf(expression, opType == GroovyElementTypes.T_NEQ);
                return;
            }
            if (right != null && PsiUtilKt.isNullLiteral(left)) {
                right.accept(this);
                this.processInstanceOf(expression, opType == GroovyElementTypes.T_NEQ);
                return;
            }
        }
        if (opType != GroovyTokenTypes.mLOR && opType != GroovyTokenTypes.mLAND && opType != GroovyTokenTypes.kIN) {
            left.accept(this);
            if (right != null) {
                right.accept(this);
            }
            this.visitCall(expression);
            return;
        }
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        ConditionInstruction condition = this.registerCondition(expression, false);
        this.addNodeAndCheckPending(condition);
        left.accept(this);
        if (right == null) {
            return;
        }
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        this.visitCall(expression);
        if (opType == GroovyTokenTypes.mLAND) {
            InstructionImpl head = this.myHead;
            if (negations.isEmpty()) {
                this.addNode(new NegatingGotoInstruction(expression, condition));
                this.handlePossibleReturn(expression);
                this.addPendingEdge(expression, this.myHead);
            } else {
                for (GotoInstruction negation : negations) {
                    this.myHead = negation;
                    this.handlePossibleReturn(expression);
                    this.addPendingEdge(expression, this.myHead);
                }
            }
            this.myHead = head;
        } else {
            InstructionImpl instruction = this.addNodeAndCheckPending(new InstructionImpl(expression));
            this.handlePossibleReturn(expression);
            this.addPendingEdge(expression, this.myHead);
            this.myHead = instruction;
            InstructionImpl head = this.reduceAllNegationsIntoInstruction(expression, negations);
            if (head != null) {
                this.myHead = head;
            }
        }
        this.myConditions = conditionsBefore;
        right.accept(this);
    }

    private void processInstanceOf(GrExpression expression, boolean negated) {
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        ConditionInstruction cond = this.registerCondition(expression, negated);
        this.addNodeAndCheckPending(cond);
        this.addNode(new InstanceOfInstruction(expression, cond));
        NegatingGotoInstruction negation = new NegatingGotoInstruction(expression, cond);
        this.addNode(negation);
        InstructionImpl possibleReturn = this.handlePossibleReturn(expression);
        this.addPendingEdge(expression, possibleReturn != null ? possibleReturn : negation);
        this.myHead = cond;
        this.addNode(new InstanceOfInstruction(expression, cond));
        this.myConditions = conditionsBefore;
    }

    private void visitCall(GroovyPsiElement call) {
        if (this.myCaughtExceptionInfos.size() <= 0 && this.myFinallyCount <= 0) {
            return;
        }
        ThrowingInstruction instruction = new ThrowingInstruction(call);
        this.addNodeAndCheckPending(instruction);
        for (ExceptionInfo info : this.myCaughtExceptionInfos) {
            info.myThrowers.add(instruction);
        }
        if (this.myFinallyCount > 0) {
            this.addPendingEdge(null, instruction);
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(27);
        }
        InstructionImpl ifInstruction = this.startNode(ifStatement);
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        GrExpression condition = ifStatement.getCondition();
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        InstructionImpl conditionEnd = null;
        InstructionImpl thenEnd = null;
        InstructionImpl elseEnd = null;
        if (condition != null) {
            condition.accept(this);
            conditionEnd = this.myHead;
        }
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(ifStatement);
        if (thenBranch != null) {
            thenBranch.accept(this);
            this.handlePossibleReturn(thenBranch);
            thenEnd = this.myHead;
            this.interruptFlow();
            this.readdPendingEdge(ifStatement);
        }
        this.myHead = this.reduceAllNegationsIntoInstruction(ifStatement, negations);
        if (this.myHead == null && conditionEnd != null) {
            this.myHead = conditionEnd;
        }
        if (elseBranch != null) {
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
            elseEnd = this.myHead;
            this.interruptFlow();
        }
        if (!(thenBranch == null && elseBranch == null || thenEnd == null && elseEnd == null && elseBranch != null)) {
            IfEndInstruction end = new IfEndInstruction(ifStatement);
            this.addNode(end);
            if (thenEnd != null) {
                ControlFlowBuilder.addEdge(thenEnd, end);
            }
            if (elseEnd != null) {
                ControlFlowBuilder.addEdge(elseEnd, end);
            } else if (elseBranch == null) {
                // empty if block
            }
        }
        this.myConditions = conditionsBefore;
        this.finishNode(ifInstruction);
    }

    @NotNull
    private ConditionInstruction registerCondition(@NotNull PsiElement element, boolean negated) {
        if (element == null) {
            ControlFlowBuilder.$$$reportNull$$$0(28);
        }
        ConditionInstruction condition = new ConditionInstruction(element, negated, (Collection<ConditionInstruction>)this.myConditions);
        this.myConditions = this.myConditions.prepend((Object)condition);
        ConditionInstruction conditionInstruction = condition;
        if (conditionInstruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(29);
        }
        return conditionInstruction;
    }

    private void acceptNullable(@Nullable GroovyPsiElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (forStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(30);
        }
        GrForClause clause = forStatement.getClause();
        this.processForLoopInitializer(clause);
        InstructionImpl start = this.startNode(forStatement);
        this.addForLoopBreakingEdge(forStatement, clause);
        this.flushForeachLoopVariable(clause);
        GrStatement body = forStatement.getBody();
        if (body != null) {
            InstructionImpl bodyInstruction = this.startNode(body);
            body.accept(this);
            this.finishNode(bodyInstruction);
        }
        this.checkPending(start);
        if (clause instanceof GrTraditionalForClause) {
            this.acceptNullable(((GrTraditionalForClause)clause).getUpdate());
        }
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, start);
        }
        this.interruptFlow();
        this.finishNode(start);
    }

    private void processForLoopInitializer(@Nullable GrForClause clause) {
        GrCondition initializer = clause instanceof GrTraditionalForClause ? ((GrTraditionalForClause)clause).getInitialization() : (clause instanceof GrForInClause ? ((GrForInClause)clause).getIteratedExpression() : null);
        this.acceptNullable(initializer);
    }

    private void addForLoopBreakingEdge(GrForStatement forStatement, @Nullable GrForClause clause) {
        GrForStatement target;
        GroovyPsiElement groovyPsiElement = target = forStatement.getParent() instanceof GrLabeledStatement ? (GroovyPsiElement)forStatement.getParent() : forStatement;
        if (clause instanceof GrTraditionalForClause) {
            GrExpression condition = ((GrTraditionalForClause)clause).getCondition();
            if (condition != null) {
                condition.accept(this);
                if (!this.alwaysTrue(condition)) {
                    this.addPendingEdge(target, this.myHead);
                }
            }
        } else {
            this.addPendingEdge(target, this.myHead);
        }
    }

    private void flushForeachLoopVariable(@Nullable GrForClause clause) {
        GrVariable variable;
        if (clause instanceof GrForInClause && (variable = ((GrForInClause)clause).getDeclaredVariable()) != null && this.myPolicy.isVariableInitialized(variable)) {
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(variable.getName(), variable, -1));
        }
    }

    @NotNull
    private List<Pair<InstructionImpl, GroovyPsiElement>> collectCorrespondingPendingEdges(@Nullable PsiElement currentScope) {
        if (currentScope == null) {
            List<Pair<InstructionImpl, GroovyPsiElement>> result2 = this.myPending;
            this.myPending = ContainerUtil.newArrayList();
            List<Pair<InstructionImpl, GroovyPsiElement>> list = result2;
            if (list == null) {
                ControlFlowBuilder.$$$reportNull$$$0(31);
            }
            return list;
        }
        ArrayList targets = ContainerUtil.newArrayList();
        for (int i = this.myPending.size() - 1; i >= 0; --i) {
            Pair<InstructionImpl, GroovyPsiElement> pair = this.myPending.get(i);
            PsiElement scopeWhenToAdd = (PsiElement)pair.getSecond();
            if (scopeWhenToAdd == null) continue;
            if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)currentScope, (boolean)false)) break;
            targets.add(pair);
            this.myPending.remove(i);
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            ControlFlowBuilder.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private void checkPending(@NotNull InstructionImpl instruction) {
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(33);
        }
        PsiElement element = instruction.getElement();
        this.checkPending(element, instruction);
    }

    private void checkPending(@Nullable PsiElement currentScope, @NotNull InstructionImpl targetInstruction) {
        if (targetInstruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(34);
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> pendingEdges = this.collectCorrespondingPendingEdges(currentScope);
        for (Pair<InstructionImpl, GroovyPsiElement> pair : pendingEdges) {
            ControlFlowBuilder.addEdge((InstructionImpl)pair.getFirst(), targetInstruction);
        }
    }

    private void readdPendingEdge(@Nullable GroovyPsiElement newScope) {
        List<Pair<InstructionImpl, GroovyPsiElement>> targets = this.collectCorrespondingPendingEdges(newScope);
        for (Pair<InstructionImpl, GroovyPsiElement> target : targets) {
            this.addPendingEdge(newScope, (InstructionImpl)target.getFirst());
        }
    }

    private void addPendingEdge(@Nullable GroovyPsiElement scopeWhenAdded, InstructionImpl instruction) {
        int i;
        if (instruction == null) {
            return;
        }
        if (scopeWhenAdded != null) {
            Pair<InstructionImpl, GroovyPsiElement> pair;
            GroovyPsiElement currScope;
            for (i = 0; i < this.myPending.size() && ((currScope = (GroovyPsiElement)(pair = this.myPending.get(i)).getSecond()) == null || PsiTreeUtil.isAncestor((PsiElement)currScope, (PsiElement)scopeWhenAdded, (boolean)true)); ++i) {
            }
        }
        this.myPending.add(i, (Pair<InstructionImpl, GroovyPsiElement>)Pair.create((Object)instruction, (Object)scopeWhenAdded));
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
        GrStatement body;
        if (whileStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(35);
        }
        InstructionImpl instruction = this.startNode(whileStatement);
        GrExpression condition = whileStatement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if (!this.alwaysTrue(condition)) {
            this.addPendingEdge(whileStatement, this.myHead);
        }
        if ((body = whileStatement.getBody()) != null) {
            body.accept(this);
        }
        this.checkPending(instruction);
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, instruction);
        }
        this.interruptFlow();
        this.finishNode(instruction);
    }

    private boolean alwaysTrue(GroovyPsiElement condition) {
        return Boolean.TRUE.equals(this.myConstantEvaluator.computeConstantExpression((PsiElement)condition));
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        GrExpression condition;
        if (switchStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(36);
        }
        if ((condition = switchStatement.getCondition()) != null) {
            condition.accept(this);
        }
        InstructionImpl instruction = this.startNode(switchStatement);
        GrCaseSection[] sections = switchStatement.getCaseSections();
        if (!ControlFlowBuilder.containsAllCases(switchStatement)) {
            this.addPendingEdge(switchStatement, instruction);
        }
        for (GrCaseSection section : sections) {
            this.myHead = instruction;
            section.accept(this);
        }
        this.finishNode(instruction);
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(37);
        }
        GrExpression condition = expression.getCondition();
        GrExpression thenBranch = expression.getThenBranch();
        GrExpression elseBranch = expression.getElseBranch();
        condition.accept(this);
        InstructionImpl conditionEnd = this.myHead;
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        if (thenBranch != null) {
            thenBranch.accept(this);
            this.handlePossibleReturn(thenBranch);
            this.addPendingEdge(expression, this.myHead);
        }
        if (elseBranch != null) {
            InstructionImpl head = this.reduceAllNegationsIntoInstruction(expression, negations);
            this.myHead = head != null ? head : conditionEnd;
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
        }
    }

    @Override
    public void visitElvisExpression(@NotNull GrElvisExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(38);
        }
        GrExpression condition = expression.getCondition();
        GrExpression elseBranch = expression.getElseBranch();
        condition.accept(this);
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        InstructionImpl head = this.myHead;
        this.handlePossibleReturn(condition);
        this.addPendingEdge(expression, this.myHead);
        this.myHead = head;
        if (elseBranch != null) {
            head = this.reduceAllNegationsIntoInstruction(expression, negations);
            if (head != null) {
                this.myHead = head;
            }
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
        }
    }

    private static boolean containsAllCases(GrSwitchStatement statement) {
        PsiClass resolved;
        GrCaseSection[] sections;
        for (GrCaseSection section : sections = statement.getCaseSections()) {
            if (!section.isDefault()) continue;
            return true;
        }
        GrExpression condition = statement.getCondition();
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        PsiType type2 = TypesUtil.unboxPrimitiveTypeWrapper(ControlFlowBuilder.getNominalTypeNoRecursion(condition));
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiPrimitiveType) {
            if (PsiType.BOOLEAN.equals((Object)type2)) {
                return sections.length == 2;
            }
            if (PsiType.BYTE.equals((Object)type2) || PsiType.CHAR.equals((Object)type2)) {
                return sections.length == 128;
            }
            return false;
        }
        if (type2 instanceof PsiClassType && (resolved = ((PsiClassType)type2).resolve()) != null && resolved.isEnum()) {
            PsiField[] fields;
            int enumConstantCount = 0;
            for (PsiField field : fields = resolved.getFields()) {
                if (!(field instanceof PsiEnumConstant)) continue;
                ++enumConstantCount;
            }
            if (sections.length == enumConstantCount) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        int i;
        if (caseSection == null) {
            ControlFlowBuilder.$$$reportNull$$$0(39);
        }
        for (GrCaseLabel label : caseSection.getCaseLabels()) {
            GrExpression value = label.getValue();
            if (value == null) continue;
            value.accept(this);
        }
        GrStatement[] statements = caseSection.getStatements();
        for (i = statements.length - 1; i >= 0 && statements[i] instanceof GrBreakStatement; --i) {
        }
        for (int j = 0; j < statements.length; ++j) {
            GrStatement statement = statements[j];
            statement.accept(this);
            if (j != i) continue;
            this.handlePossibleReturn(statement);
        }
        if (this.myHead != null) {
            this.addPendingEdge(caseSection, this.myHead);
        }
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement tryCatchStatement) {
        GrTryResourceList resourceList;
        if (tryCatchStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(40);
        }
        GrOpenBlock tryBlock = tryCatchStatement.getTryBlock();
        GrCatchClause[] catchClauses = tryCatchStatement.getCatchClauses();
        GrFinallyClause finallyClause = tryCatchStatement.getFinallyClause();
        for (int i = catchClauses.length - 1; i >= 0; --i) {
            this.myCaughtExceptionInfos.push(new ExceptionInfo(catchClauses[i]));
        }
        if (finallyClause != null) {
            ++this.myFinallyCount;
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> oldPending = null;
        if (finallyClause != null) {
            oldPending = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        }
        if ((resourceList = tryCatchStatement.getResourceList()) != null) {
            resourceList.accept(this);
        }
        InstructionImpl tryBegin = this.startNode(tryBlock);
        if (tryBlock != null) {
            tryBlock.accept(this);
        }
        InstructionImpl tryEnd = this.myHead;
        this.finishNode(tryBegin);
        LinkedHashSet<Pair<InstructionImpl, GroovyPsiElement>> pendingAfterTry = new LinkedHashSet<Pair<InstructionImpl, GroovyPsiElement>>(this.myPending);
        List[] throwers = new List[catchClauses.length];
        for (int i = 0; i < catchClauses.length; ++i) {
            throwers[i] = this.myCaughtExceptionInfos.pop().myThrowers;
        }
        InstructionImpl[] catches = new InstructionImpl[catchClauses.length];
        for (int i = 0; i < catchClauses.length; ++i) {
            this.interruptFlow();
            InstructionImpl catchBeg = this.startNode(catchClauses[i]);
            for (InstructionImpl[] thrower : throwers[i]) {
                ControlFlowBuilder.addEdge((InstructionImpl)thrower, catchBeg);
            }
            GrParameter parameter = catchClauses[i].getParameter();
            if (parameter != null && this.myPolicy.isVariableInitialized(parameter)) {
                this.addNode(new ReadWriteVariableInstruction(parameter.getName(), parameter, -1));
            }
            catchClauses[i].accept(this);
            catches[i] = this.myHead;
            this.finishNode(catchBeg);
        }
        pendingAfterTry.addAll(this.myPending);
        this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>(pendingAfterTry);
        if (finallyClause != null) {
            --this.myFinallyCount;
            this.interruptFlow();
            InstructionImpl finallyInstruction = this.startNode(finallyClause, false);
            LinkedHashSet<AfterCallInstruction> postCalls = new LinkedHashSet<AfterCallInstruction>();
            List<Pair<InstructionImpl, GroovyPsiElement>> copy = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            for (Pair pair : copy) {
                postCalls.add(this.addCallNode(finallyInstruction, (GroovyPsiElement)pair.getSecond(), (InstructionImpl)pair.getFirst()));
            }
            if (tryEnd != null) {
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, tryEnd));
            }
            for (InstructionImpl catchEnd : catches) {
                if (catchEnd == null) continue;
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, catchEnd));
            }
            List<Pair<InstructionImpl, GroovyPsiElement>> pendingPostCalls = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            this.myHead = finallyInstruction;
            finallyClause.accept(this);
            ReturnInstruction returnInstruction = new ReturnInstruction(finallyClause);
            for (AfterCallInstruction postCall : postCalls) {
                postCall.setReturnInstruction(returnInstruction);
                ControlFlowBuilder.addEdge(returnInstruction, postCall);
            }
            this.addNodeAndCheckPending(returnInstruction);
            this.interruptFlow();
            this.finishNode(finallyInstruction);
            if (oldPending == null) {
                this.error();
            }
            oldPending.addAll(pendingPostCalls);
            this.myPending = oldPending;
        } else {
            if (tryEnd != null) {
                this.addPendingEdge(tryCatchStatement, tryEnd);
            }
            for (InstructionImpl catchEnd : catches) {
                this.addPendingEdge(tryBlock, catchEnd);
            }
        }
    }

    private void error() {
        this.error("broken control flow for a scope");
    }

    private void error(@NotNull String descr) {
        PsiFile file;
        if (descr == null) {
            ControlFlowBuilder.$$$reportNull$$$0(41);
        }
        String fileText = (file = this.myScope.getContainingFile()) != null ? file.getText() : null;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        String path = virtualFile == null ? null : virtualFile.getPresentableUrl();
        LOG.error(descr + this.myScope.getText(), new Attachment[]{new Attachment(path + "", fileText + "")});
    }

    private AfterCallInstruction addCallNode(InstructionImpl finallyInstruction, GroovyPsiElement scopeWhenAdded, InstructionImpl src) {
        this.interruptFlow();
        CallInstruction call = new CallInstruction(finallyInstruction);
        this.addNode(call);
        ControlFlowBuilder.addEdge(src, call);
        ControlFlowBuilder.addEdge(call, finallyInstruction);
        AfterCallInstruction afterCall = new AfterCallInstruction(call);
        this.addNode(afterCall);
        this.addPendingEdge(scopeWhenAdded, afterCall);
        return afterCall;
    }

    private InstructionImpl startNode(@Nullable GroovyPsiElement element) {
        return this.startNode(element, true);
    }

    private InstructionImpl startNode(@Nullable GroovyPsiElement element, boolean checkPending) {
        InstructionImpl instruction = new InstructionImpl(element);
        this.addNode(instruction);
        if (checkPending) {
            this.checkPending(instruction);
        }
        this.myProcessingStack.push(instruction);
        return instruction;
    }

    private void finishNode(InstructionImpl instruction) {
        InstructionImpl popped = this.myProcessingStack.pop();
        if (!instruction.equals(popped)) {
            String description = "popped  : " + popped.toString() + " : " + popped.hashCode() + ", " + popped.getClass() + "\nexpected: " + instruction.toString() + " : " + instruction.hashCode() + ", " + instruction.getClass() + "\nsame objects: " + (popped == instruction) + "\n";
            this.error(description);
        }
    }

    @Override
    public void visitField(@NotNull GrField field) {
        if (field == null) {
            ControlFlowBuilder.$$$reportNull$$$0(42);
        }
    }

    @Override
    public void visitParameter(@NotNull GrParameter parameter) {
        if (parameter == null) {
            ControlFlowBuilder.$$$reportNull$$$0(43);
        }
        if (parameter.getParent() instanceof GrForClause) {
            this.visitVariable(parameter);
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            ControlFlowBuilder.$$$reportNull$$$0(44);
        }
    }

    @Override
    public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
        if (initializer == null) {
            ControlFlowBuilder.$$$reportNull$$$0(45);
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            ControlFlowBuilder.$$$reportNull$$$0(46);
        }
        if (!(typeDefinition instanceof GrAnonymousClassDefinition)) {
            return;
        }
        Set<ReadWriteVariableInstruction> vars = ControlFlowBuilder.collectUsedVariableWithoutInitialization(typeDefinition);
        this.addReadFromNestedControlFlow(typeDefinition, vars.toArray(ReadWriteVariableInstruction.EMPTY_ARRAY));
    }

    private static Set<ReadWriteVariableInstruction> collectUsedVariableWithoutInitialization(GrTypeDefinition typeDefinition) {
        final LinkedHashSet vars = ContainerUtil.newLinkedHashSet();
        typeDefinition.acceptChildren(new GroovyRecursiveElementVisitor(){

            private void collectVars(Instruction[] flow) {
                ReadWriteVariableInstruction[] reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(flow, false);
                Collections.addAll(vars, reads);
            }

            @Override
            public void visitField(@NotNull GrField field) {
                GrExpression initializer;
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((initializer = field.getInitializerGroovy()) != null) {
                    Instruction[] flow = new ControlFlowBuilder(field.getProject()).buildControlFlow(initializer);
                    this.collectVars(flow);
                }
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                GrOpenBlock block;
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((block = method.getBlock()) != null) {
                    this.collectVars(block.getControlFlow());
                }
            }

            @Override
            public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(2);
                }
                GrOpenBlock block = initializer.getBlock();
                this.collectVars(block.getControlFlow());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return vars;
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            ControlFlowBuilder.$$$reportNull$$$0(47);
        }
        super.visitVariable(variable);
        if (this.myPolicy.isVariableInitialized(variable)) {
            ReadWriteVariableInstruction writeInst = new ReadWriteVariableInstruction(variable.getName(), variable, -1);
            this.addNodeAndCheckPending(writeInst);
        }
    }

    @Nullable
    private InstructionImpl findInstruction(PsiElement element) {
        for (InstructionImpl instruction : this.myInstructions) {
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            ControlFlowBuilder.$$$reportNull$$$0(48);
        }
        ProgressManager.checkCanceled();
        super.visitElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleReturn";
                break;
            }
            case 5: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reads";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continueStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertStatement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 28: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInstruction";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSection";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryCatchStatement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descr";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "registerCondition";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCorrespondingPendingEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitOpenBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionLambdaBody";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockLambdaBody";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handlePossibleReturn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitClosure";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addReadFromNestedControlFlow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitAssertStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNominalTypeNoRecursion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitTupleAssignmentExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitUnaryExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitInstanceofExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodCall";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitConstructorInvocation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitNewExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerCondition";
                break;
            }
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkPending";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitElvisExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitCaseSection";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitParameter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeDefinition";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitVariable";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExceptionInfo {
        final GrCatchClause myClause;
        final List<InstructionImpl> myThrowers = new ArrayList<InstructionImpl>();

        private ExceptionInfo(GrCatchClause clause) {
            this.myClause = clause;
        }
    }
}

