/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator;
import org.jetbrains.plugins.groovy.dsl.holders.NonCodeMembersHolder;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyDocInfoGenerator;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    private static final String LINE_SEPARATOR = "\n";
    @NonNls
    private static final String RETURN_TAG = "@return";
    @NonNls
    private static final String THROWS_TAG = "@throws";
    private static final String BODY_HTML = "</body></html>";

    private static PsiSubstitutor calcSubstitutor(PsiElement originalElement) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (originalElement instanceof GrReferenceExpression) {
            substitutor = ((GrReferenceExpression)originalElement).advancedResolve().getSubstitutor();
        }
        return substitutor;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof GrVariable || element instanceof GrImplicitVariable) {
            StringBuilder buffer = new StringBuilder();
            PsiVariable variable = (PsiVariable)element;
            if (originalElement instanceof GrVariableDeclaration && ((GrVariableDeclaration)originalElement).getVariables().length > 1) {
                for (GrVariable var : ((GrVariableDeclaration)originalElement).getVariables()) {
                    GroovyDocumentationProvider.generateVariableInfo(originalElement, buffer, var);
                    buffer.append("\n\n");
                }
            } else {
                GroovyDocumentationProvider.generateVariableInfo(originalElement, buffer, variable);
            }
            return buffer.toString();
        }
        if (element instanceof PsiMethod) {
            StringBuilder buffer = new StringBuilder();
            PsiMethod method = (PsiMethod)element;
            if (method instanceof GrGdkMethod) {
                buffer.append("[GDK] ");
            } else {
                String qName;
                PsiClass hisClass = method.getContainingClass();
                if (hisClass != null && (qName = hisClass.getQualifiedName()) != null) {
                    buffer.append(qName).append(LINE_SEPARATOR);
                }
            }
            PsiSubstitutor substitutor = GroovyDocumentationProvider.calcSubstitutor(originalElement);
            if (!method.isConstructor()) {
                PsiType substituted = substitutor.substitute(PsiUtil.getSmartReturnType(method));
                PsiImplUtil.appendTypeString(buffer, substituted, originalElement);
                buffer.append(" ");
            }
            buffer.append(method.getName()).append(" ");
            buffer.append("(");
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                if (parameter instanceof GrParameter) {
                    GroovyPresentationUtil.appendParameterPresentation((GrParameter)parameter, substitutor, TypePresentation.LINK, buffer);
                    continue;
                }
                PsiType type2 = parameter.getType();
                PsiImplUtil.appendTypeString(buffer, substitutor.substitute(type2), originalElement);
                buffer.append(" ");
                buffer.append(parameter.getName());
            }
            buffer.append(")");
            PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
            if (referencedTypes.length > 0) {
                buffer.append("\nthrows ");
                for (PsiClassType referencedType : referencedTypes) {
                    PsiImplUtil.appendTypeString(buffer, (PsiType)referencedType, originalElement);
                    buffer.append(", ");
                }
                buffer.delete(buffer.length() - 2, buffer.length());
            }
            return buffer.toString();
        }
        if (element instanceof GrTypeDefinition) {
            return GroovyDocumentationProvider.generateClassInfo((GrTypeDefinition)element);
        }
        return null;
    }

    private static void generateVariableInfo(PsiElement originalElement, StringBuilder buffer, PsiVariable variable) {
        if (variable instanceof PsiField) {
            PsiClass parentClass = ((PsiField)variable).getContainingClass();
            if (parentClass != null) {
                buffer.append(JavaDocUtil.getShortestClassName((PsiClass)parentClass, (PsiElement)variable));
                GroovyDocumentationProvider.newLine(buffer);
            }
            GroovyDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)variable);
        }
        PsiType type2 = variable instanceof GrVariable ? ((GrVariable)variable).getDeclaredType() : variable.getType();
        PsiImplUtil.appendTypeString(buffer, GroovyDocumentationProvider.calcSubstitutor(originalElement).substitute(type2), originalElement);
        buffer.append(" ");
        buffer.append(variable.getName());
        if (variable instanceof GrVariable) {
            PsiReference ref;
            GroovyDocumentationProvider.newLine(buffer);
            while (originalElement != null && ((ref = originalElement.getReference()) == null || ref.resolve() == null)) {
                originalElement = originalElement.getParent();
            }
            if (originalElement != null) {
                GroovyDocumentationProvider.appendInferredType(originalElement, (GrVariable)variable, buffer);
            }
        }
    }

    private static void appendInferredType(PsiElement originalElement, GrVariable variable, StringBuilder buffer) {
        PsiType inferredType = null;
        if (PsiImplUtil.isWhiteSpaceOrNls(originalElement)) {
            originalElement = PsiTreeUtil.prevLeaf((PsiElement)originalElement);
        }
        if (originalElement != null && originalElement.getNode().getElementType() == GroovyTokenTypes.mIDENT) {
            originalElement = originalElement.getParent();
        }
        if (originalElement instanceof GrReferenceExpression) {
            inferredType = ((GrReferenceExpression)originalElement).getType();
        } else if (originalElement instanceof GrVariableDeclaration) {
            inferredType = variable.getTypeGroovy();
        } else if (originalElement instanceof GrVariable) {
            inferredType = ((GrVariable)originalElement).getTypeGroovy();
        }
        if (inferredType != null) {
            buffer.append("[inferred type] ");
            GroovyDocumentationProvider.appendTypeString(buffer, inferredType, originalElement);
        } else {
            buffer.append("[cannot infer type]");
        }
    }

    private static void generateModifiers(StringBuilder buffer, PsiModifierListOwner element) {
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)element, (int)16384);
        if (!modifiers.isEmpty()) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
    }

    private static void newLine(StringBuilder buffer) {
        buffer.append(LINE_SEPARATOR);
    }

    private static String generateClassInfo(PsiClass aClass) {
        StringBuilder buffer = new StringBuilder();
        GroovyFile file = (GroovyFile)aClass.getContainingFile();
        String packageName = file.getPackageName();
        if (!packageName.isEmpty()) {
            buffer.append(packageName).append(LINE_SEPARATOR);
        }
        String classString = aClass.isInterface() ? "interface" : (aClass instanceof PsiTypeParameter ? "type parameter" : (aClass.isEnum() ? "enum" : "class"));
        buffer.append(classString).append(" ").append(aClass.getName());
        JavaDocumentationProvider.generateTypeParameters((PsiTypeParameterListOwner)aClass, (StringBuilder)buffer);
        JavaDocumentationProvider.writeExtends((PsiClass)aClass, (StringBuilder)buffer, (PsiClassType[])aClass.getExtendsListTypes());
        JavaDocumentationProvider.writeImplements((PsiClass)aClass, (StringBuilder)buffer, (PsiClassType[])aClass.getImplementsListTypes());
        return buffer.toString();
    }

    public static void appendTypeString(@NotNull StringBuilder buffer, @Nullable PsiType type2, PsiElement context) {
        if (buffer == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (type2 instanceof GrTraitType) {
            GroovyDocumentationProvider.generateTraitType(buffer, (GrTraitType)type2, context);
        } else if (type2 != null) {
            JavaDocInfoGenerator.generateType((StringBuilder)buffer, (PsiType)type2, (PsiElement)context);
        } else {
            buffer.append("def");
        }
    }

    private static void generateTraitType(@NotNull StringBuilder buffer, @NotNull GrTraitType type2, PsiElement context) {
        if (buffer == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(2);
        }
        GroovyDocumentationProvider.appendTypeString(buffer, type2.getExprType(), context);
        buffer.append(" as ");
        for (PsiType traitType : type2.getTraitTypes()) {
            GroovyDocumentationProvider.appendTypeString(buffer, traitType, context);
            buffer.append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        List list;
        ArrayList<String> result2 = new ArrayList<String>();
        PsiElement docElement = GroovyDocumentationProvider.getDocumentationElement(element, originalElement);
        if (docElement != null) {
            ContainerUtil.addIfNotNull(result2, (Object)docElement.getUserData(NonCodeMembersHolder.DOCUMENTATION_URL));
        }
        if ((list = JavaDocumentationProvider.getExternalJavaDocUrl((PsiElement)element)) != null) {
            result2.addAll(list);
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String gdslDoc;
        if (element instanceof CustomMembersGenerator.GdslNamedParameter) {
            CustomMembersGenerator.GdslNamedParameter parameter = (CustomMembersGenerator.GdslNamedParameter)element;
            String result2 = "<pre><b>" + parameter.getName() + "</b>";
            if (parameter.myParameterTypeText != null) {
                result2 = result2 + ": " + parameter.myParameterTypeText;
            }
            result2 = result2 + "</pre>";
            if (parameter.docString != null) {
                result2 = result2 + "<p>" + parameter.docString;
            }
            return result2;
        }
        if (element instanceof GrReferenceExpression) {
            return GroovyDocumentationProvider.getMethodCandidateInfo((GrReferenceExpression)element);
        }
        if ((element = GroovyDocumentationProvider.getDocumentationElement(element, originalElement)) == null) {
            return null;
        }
        String standard = GroovyDocumentationProvider.generateExternalJavaDoc(element);
        if (element instanceof GrVariable && ((GrVariable)element).getDeclaredType() == null && standard != null) {
            String truncated = StringUtil.trimEnd((String)standard, (String)BODY_HTML);
            StringBuilder buffer = new StringBuilder(truncated);
            buffer.append("<p>");
            if (originalElement != null) {
                GroovyDocumentationProvider.appendInferredType(originalElement, (GrVariable)element, buffer);
            } else if (element.getParent() instanceof GrVariableDeclaration) {
                GroovyDocumentationProvider.appendInferredType(element.getParent(), (GrVariable)element, buffer);
            }
            if (!truncated.equals(standard)) {
                buffer.append(BODY_HTML);
            }
            standard = buffer.toString();
        }
        if ((gdslDoc = (String)element.getUserData(NonCodeMembersHolder.DOCUMENTATION)) != null) {
            if (standard != null) {
                String truncated = StringUtil.trimEnd((String)standard, (String)BODY_HTML);
                String appended = truncated + "<p>" + gdslDoc;
                if (truncated.equals(standard)) {
                    return appended;
                }
                return appended + BODY_HTML;
            }
            return gdslDoc;
        }
        return standard;
    }

    @Nullable
    protected static String generateExternalJavaDoc(@NotNull PsiElement element) {
        if (element == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(3);
        }
        GroovyDocInfoGenerator generator = new GroovyDocInfoGenerator(element);
        return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)element, (JavaDocInfoGenerator)generator);
    }

    private static PsiElement getDocumentationElement(PsiElement element, PsiElement originalElement) {
        PsiElement navigationElement;
        GrDocComment doc;
        if (element instanceof GrGdkMethod) {
            element = ((GrGdkMethod)element).getStaticMethod();
        }
        if ((doc = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)originalElement, GrDocComment.class)) != null) {
            element = GrDocCommentUtil.findDocOwner(doc);
        }
        if (element instanceof GrLightVariable && (navigationElement = element.getNavigationElement()) != null) {
            element = navigationElement;
            if (element.getContainingFile() instanceof PsiCompiledFile && (navigationElement = element.getNavigationElement()) != null) {
                element = navigationElement;
            }
            if (element instanceof GrAccessorMethod) {
                element = ((GrAccessorMethod)element).getProperty();
            }
        }
        if (element instanceof GrPropertyForCompletion) {
            element = ((GrPropertyForCompletion)element).getOriginalAccessor();
        }
        return element;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        return JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element, (Project)project, docUrls);
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    private static String getMethodCandidateInfo(GrReferenceExpression expr) {
        GroovyResolveResult[] candidates = expr.multiResolve(false);
        String text = expr.getText();
        if (candidates.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (GroovyResolveResult candidate : candidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod)) continue;
                String str = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)candidate.getSubstitutor(), (int)259, (int)2);
                GroovyDocumentationProvider.createElementLink(sb, element, str);
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{text, sb});
        }
        return CodeInsightBundle.message((String)"javadoc.candidates.not.found", (Object[])new Object[]{text});
    }

    private static void createElementLink(@NonNls StringBuilder sb, PsiElement element, String str) {
        sb.append("&nbsp;&nbsp;<a href=\"psi_element://");
        sb.append(JavaDocUtil.getReferenceText((Project)element.getProject(), (PsiElement)element));
        sb.append("\">");
        sb.append(str);
        sb.append("</a>");
        sb.append("<br>");
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof GroovyResolveResult) {
            return ((GroovyResolveResult)object).getElement();
        }
        if (object instanceof NamedArgumentDescriptor) {
            return ((NamedArgumentDescriptor)object).getNavigationElement();
        }
        if (object instanceof GrPropertyForCompletion) {
            return ((GrPropertyForCompletion)((Object)object)).getOriginalAccessor();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    public PsiComment findExistingDocComment(PsiComment contextElement) {
        GrDocCommentOwner owner;
        if (contextElement instanceof GrDocComment && (owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextElement)) != null) {
            return owner.getDocComment();
        }
        return null;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        if (startPoint == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(4);
        }
        for (PsiElement e = startPoint; e != null; e = e.getParent()) {
            if (!(e instanceof GrDocCommentOwner)) continue;
            return Pair.create((Object)e, (Object)((GrDocCommentOwner)e).getDocComment());
        }
        return null;
    }

    public String generateDocumentationContentStub(PsiComment contextComment) {
        PsiTypeParameterList typeParameterList;
        if (!(contextComment instanceof GrDocComment)) {
            return null;
        }
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextComment);
        if (owner == null) {
            return null;
        }
        Project project = contextComment.getProject();
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)LanguageCommenters.INSTANCE.forLanguage(owner.getLanguage());
        StringBuilder builder = new StringBuilder();
        if (owner instanceof GrMethod) {
            PsiClassType[] references;
            GrMethod method = (GrMethod)owner;
            JavaDocumentationProvider.generateParametersTakingDocFromSuperMethods((StringBuilder)builder, (CodeDocumentationAwareCommenter)commenter, (PsiMethod)method);
            PsiType returnType2 = method.getInferredReturnType();
            if ((returnType2 != null || method.getModifierList().hasModifierProperty("def")) && !PsiType.VOID.equals((Object)returnType2)) {
                builder.append(CodeDocumentationUtil.createDocCommentLine((String)RETURN_TAG, (PsiFile)contextComment.getContainingFile(), (CodeDocumentationAwareCommenter)commenter));
                builder.append(LINE_SEPARATOR);
            }
            for (PsiClassType reference : references = method.getThrowsList().getReferencedTypes()) {
                builder.append(CodeDocumentationUtil.createDocCommentLine((String)THROWS_TAG, (PsiFile)contextComment.getContainingFile(), (CodeDocumentationAwareCommenter)commenter));
                builder.append(reference.getClassName());
                builder.append(LINE_SEPARATOR);
            }
        } else if (owner instanceof GrTypeDefinition && (typeParameterList = ((PsiClass)owner).getTypeParameterList()) != null) {
            JavaDocumentationProvider.createTypeParamsListComment((StringBuilder)builder, (CodeDocumentationAwareCommenter)commenter, (PsiTypeParameterList)typeParameterList);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/documentation/GroovyDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendTypeString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTraitType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateExternalJavaDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

