/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.KotlinUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.HighlightingKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.DefaultConstructor;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a9\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\"\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a2\u0010\u0016\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0017\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0018"}, d2={"argumentsString", "", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "generateCastFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "argumentList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrArgumentList;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;Ljava/util/List;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrArgumentList;)[Lcom/intellij/codeInspection/LocalQuickFix;", "highlightAmbiguousMethod", "", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "highlightCannotApplyError", "invokedText", "typesString", "highlightInapplicableMethod", "highlightUnknownArgs", "intellij.groovy.psi"})
public final class HighlightingKt {
    public static final void highlightUnknownArgs(@NotNull HighlightSink $receiver, @NotNull PsiElement highlightElement) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        $receiver.registerProblem(highlightElement, ProblemHighlightType.WEAK_WARNING, GroovyBundle.message("cannot.infer.argument.types", new Object[0]), new LocalQuickFix[0]);
    }

    public static final void highlightCannotApplyError(@NotNull HighlightSink $receiver, @NotNull String invokedText, @NotNull String typesString, @NotNull PsiElement highlightElement) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)invokedText, (String)"invokedText");
        Intrinsics.checkParameterIsNotNull((Object)typesString, (String)"typesString");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        $receiver.registerError(highlightElement, GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString), new LocalQuickFix[0]);
    }

    public static final void highlightAmbiguousMethod(@NotNull HighlightSink $receiver, @NotNull PsiElement highlightElement) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        $receiver.registerError(highlightElement, GroovyBundle.message("constructor.call.is.ambiguous", new Object[0]), new LocalQuickFix[0]);
    }

    public static final void highlightInapplicableMethod(@NotNull HighlightSink $receiver, @NotNull GroovyMethodResult result2, @NotNull List<? extends Argument> arguments2, @Nullable GrArgumentList argumentList, @NotNull PsiElement highlightElement) {
        PsiClass psiClass;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"result.element");
        PsiMethod method = psiMethod;
        if (method instanceof GrGdkMethod) {
            PsiMethod psiMethod2 = ((GrGdkMethod)method).getStaticMethod();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"method.staticMethod");
            psiClass = psiMethod2.getContainingClass();
        } else {
            psiClass = method.getContainingClass();
        }
        PsiClass containingClass = psiClass;
        String argumentString = HighlightingKt.argumentsString(arguments2);
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (containingClass == null) {
            HighlightingKt.highlightCannotApplyError($receiver, methodName, argumentString, highlightElement);
            return;
        }
        String message = null;
        if (method instanceof DefaultConstructor) {
            String string2 = GroovyBundle.message("cannot.apply.default.constructor", methodName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message(\"cannot.apply.de\u2026constructor\", methodName)");
            message = string2;
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            PsiClassType psiClassType = factory.createType(containingClass, result2.getSubstitutor());
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"factory.createType(conta\u2026lass, result.substitutor)");
            PsiClassType containingType = psiClassType;
            String string3 = containingType.getInternalCanonicalText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"containingType.internalCanonicalText");
            String canonicalText = string3;
            if (method.isConstructor()) {
                String string4 = GroovyBundle.message("cannot.apply.constructor", methodName, canonicalText, argumentString);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"message(\"cannot.apply.co\u2026icalText, argumentString)");
                message = string4;
            } else {
                String string5 = GroovyBundle.message("cannot.apply.method1", methodName, canonicalText, argumentString);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"message(\"cannot.apply.me\u2026icalText, argumentString)");
                message = string5;
            }
        }
        LocalQuickFix[] fixes = HighlightingKt.generateCastFixes(result2, arguments2, argumentList);
        $receiver.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR, message, Arrays.copyOf(fixes, fixes.length));
    }

    private static final String argumentsString(List<? extends Argument> arguments2) {
        return CollectionsKt.joinToString$default((Iterable)arguments2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)argumentsString.1.INSTANCE, (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final LocalQuickFix[] generateCastFixes(GroovyMethodResult result2, List<? extends Argument> arguments2, GrArgumentList argumentList) {
        Collection<PsiType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        GrSignature grSignature = GrClosureSignatureUtil.createSignature(result2.getElement(), result2.getSubstitutor());
        Intrinsics.checkExpressionValueIsNotNull((Object)grSignature, (String)"createSignature(result.e\u2026ment, result.substitutor)");
        GrSignature signature = grSignature;
        Iterable iterable = arguments2;
        GrSignature grSignature2 = signature;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            PsiType psiType = ((Argument)receiver).getType();
            collection.add(psiType);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
        LocalQuickFix[] localQuickFixArray = GroovyTypeCheckVisitorHelper.genCastFixes(grSignature2, (PsiType[])KotlinUtils.toArray((Collection)collection2, (Object[])PsiType.EMPTY_ARRAY), argumentList);
        Intrinsics.checkExpressionValueIsNotNull((Object)localQuickFixArray, (String)"GroovyTypeCheckVisitorHe\u2026PTY_ARRAY), argumentList)");
        return localQuickFixArray;
    }
}

