/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.gpath;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyMapPutCanBeKeyedAccessInspection
extends BaseInspection {
    private final ReplaceWithPropertyAccessFix fix = new ReplaceWithPropertyAccessFix();

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Call to Map.put can be keyed access" == null) {
            GroovyMapPutCanBeKeyedAccessInspection.$$$reportNull$$$0(0);
        }
        return "Call to Map.put can be keyed access";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to '#ref' can be keyed access #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyMapPutCanBeKeyedAccessInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyMapPutCanBeKeyedAccessInspection.$$$reportNull$$$0(2);
        }
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            if (grMethodCallExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(grMethodCallExpression);
            GrArgumentList args = grMethodCallExpression.getArgumentList();
            if (args.getExpressionArguments().length != 2) {
                return;
            }
            if (PsiImplUtil.hasNamedArguments(args)) {
                return;
            }
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            String name = referenceExpression.getReferenceName();
            if (!"put".equals(name)) {
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || PsiUtil.isThisOrSuperRef(qualifier)) {
                return;
            }
            if (referenceExpression.getDotTokenType() == GroovyTokenTypes.mOPTIONAL_DOT) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethodCallExpression", "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection$Visitor", "visitMethodCallExpression"));
        }
    }

    private static class ReplaceWithPropertyAccessFix
    extends GroovyFix {
        private ReplaceWithPropertyAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with keyed access" == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(0);
            }
            return "Replace with keyed access";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(2);
            }
            PsiElement referenceName = descriptor2.getPsiElement();
            GrReferenceExpression invokedExpression = (GrReferenceExpression)referenceName.getParent();
            GrMethodCallExpression callExpression = (GrMethodCallExpression)invokedExpression.getParent();
            GrArgumentList argumentList = callExpression.getArgumentList();
            GrExpression[] args = argumentList.getExpressionArguments();
            ReplaceWithPropertyAccessFix.replaceExpression(callExpression, invokedExpression.getQualifierExpression().getText() + '[' + args[0].getText() + "]=" + args[1].getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection$ReplaceWithPropertyAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection$ReplaceWithPropertyAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

