/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyResultOfObjectAllocationIgnoredInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Result of object allocation ignored" == null) {
            GroovyResultOfObjectAllocationIgnoredInspection.$$$reportNull$$$0(0);
        }
        return "Result of object allocation ignored";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Result of <code>new #ref" + (args[0].equals(new Integer(0)) ? "()" : "[]") + "</code> is ignored #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyResultOfObjectAllocationIgnoredInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyResultOfObjectAllocationIgnoredInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression newExpression) {
            if (newExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(newExpression);
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            PsiElement parent2 = newExpression.getParent();
            if (parent2 instanceof GrCodeBlock || parent2 instanceof GroovyFile) {
                if ((parent2 instanceof GrOpenBlock || parent2 instanceof GrClosableBlock) && ControlFlowUtils.openBlockCompletesWithStatement((GrCodeBlock)parent2, newExpression)) {
                    return;
                }
                this.registerError((PsiElement)refElement, newExpression.getArrayCount());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyResultOfObjectAllocationIgnoredInspection$Visitor", "visitNewExpression"));
        }
    }
}

