/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateFieldFromConstructorLabelFix
extends GroovyFix {
    private final CreateFieldFix myFix;
    private final SmartPsiElementPointer<GrNamedArgument> myNamedArgumentPointer;

    public CreateFieldFromConstructorLabelFix(@NotNull GrTypeDefinition targetClass, @NotNull GrNamedArgument namedArgument) {
        if (targetClass == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(0);
        }
        if (namedArgument == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(1);
        }
        this.myFix = new CreateFieldFix(targetClass);
        this.myNamedArgumentPointer = PointersKt.createSmartPointer((PsiElement)namedArgument);
    }

    @Nullable
    private String getFieldName() {
        GrNamedArgument namedArgument = (GrNamedArgument)this.myNamedArgumentPointer.getElement();
        if (namedArgument == null) {
            return null;
        }
        GrArgumentLabel label = namedArgument.getLabel();
        assert (label != null);
        return label.getName();
    }

    private static TypeConstraint[] calculateTypeConstrains(@NotNull GrNamedArgument namedArgument) {
        if (namedArgument == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(2);
        }
        GrExpression expression = namedArgument.getExpression();
        PsiType type2 = null;
        if (expression != null) {
            type2 = expression.getType();
        }
        if (type2 != null) {
            return new TypeConstraint[]{SupertypeConstraint.create(type2, type2)};
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("create.field.from.usage", this.getFieldName());
        if (string == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Create field" == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(4);
        }
        return "Create field";
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        GrNamedArgument namedArgument;
        if (project == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(6);
        }
        if ((namedArgument = (GrNamedArgument)this.myNamedArgumentPointer.getElement()) == null) {
            return;
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            return;
        }
        this.myFix.doFix(project, ArrayUtil.EMPTY_STRING_ARRAY, fieldName, CreateFieldFromConstructorLabelFix.calculateTypeConstrains(namedArgument), namedArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgument";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeConstrains";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

