/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J0\u0010\u000f\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J%\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ConvertLambdaToClosureAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "lambda", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;)V", "myLambda", "Lcom/intellij/psi/SmartPsiElementPointer;", "appendElements", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "start", "Lcom/intellij/psi/PsiElement;", "stop", "appendTextBetween", "text", "", "left", "right", "closureText", "getFamilyName", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.groovy.psi"})
public final class ConvertLambdaToClosureAction
implements IntentionAction {
    private final SmartPsiElementPointer<GrLambdaExpression> myLambda;

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("action.convert.lambda.to.closure", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"action.convert.lambda.to.closure\")");
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.myLambda.getElement() != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GrLambdaExpression grLambdaExpression = (GrLambdaExpression)this.myLambda.getElement();
        if (grLambdaExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grLambdaExpression, (String)"myLambda.element ?: return");
        GrLambdaExpression lambda2 = grLambdaExpression;
        String string = this.closureText(lambda2);
        if (string == null) {
            return;
        }
        String closureText = string;
        GrClosableBlock grClosableBlock = GroovyPsiElementFactory.getInstance(project).createClosureFromText(closureText);
        Intrinsics.checkExpressionValueIsNotNull((Object)grClosableBlock, (String)"GroovyPsiElementFactory.\u2026sureFromText(closureText)");
        GrClosableBlock closure = grClosableBlock;
        lambda2.replaceWithExpression(closure, false);
    }

    private final String closureText(GrLambdaExpression lambda2) {
        GrParameterList grParameterList = lambda2.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)grParameterList, (String)"lambda.parameterList");
        GrParameterList parameterList = grParameterList;
        GrLambdaBody grLambdaBody = lambda2.getBody();
        if (grLambdaBody == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grLambdaBody, (String)"lambda.body ?: return null");
        GrLambdaBody body = grLambdaBody;
        StringBuilder closureText = new StringBuilder();
        closureText.append("{");
        if (parameterList.getParametersCount() != 0) {
            String string = parameterList.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parameterList.text");
            this.appendTextBetween(closureText, string, parameterList.getLParen(), parameterList.getRParen());
        }
        this.appendElements(closureText, parameterList, body);
        if (body instanceof GrBlockLambdaBody) {
            String string = ((GrBlockLambdaBody)body).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body.text");
            this.appendTextBetween(closureText, string, ((GrBlockLambdaBody)body).getLBrace(), ((GrBlockLambdaBody)body).getRBrace());
        } else {
            closureText.append(body.getText());
        }
        closureText.append("}");
        return closureText.toString();
    }

    private final void appendTextBetween(StringBuilder builder, String text, PsiElement left, PsiElement right) {
        PsiElement psiElement = left;
        int start = psiElement != null ? psiElement.getTextLength() : 0;
        PsiElement psiElement2 = right;
        int end = text.length() - (psiElement2 != null ? psiElement2.getTextLength() : 0);
        builder.append(text, start, end);
    }

    private final void appendElements(StringBuilder builder, PsiElement start, PsiElement stop) {
        for (PsiElement current = start.getNextSibling(); current != null && current != stop; current = current.getNextSibling()) {
            builder.append(current.getText());
        }
    }

    public ConvertLambdaToClosureAction(@NotNull GrLambdaExpression lambda2) {
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        this.myLambda = PointersKt.createSmartPointer$default((PsiElement)lambda2, null, (int)1, null);
    }
}

