/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator18;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator25;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator30;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre17;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre18;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre23;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotatorPre30;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyVersionAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.groovy.psi"})
public final class GroovyVersionAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (!(element instanceof GroovyPsiElement)) {
            return;
        }
        GroovyConfigUtils config = GroovyConfigUtils.getInstance();
        String string = config.getSDKVersion(element);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.getSDKVersion(element)");
        String version = string;
        if (Intrinsics.areEqual((Object)version, (Object)"<no version>")) {
            return;
        }
        if (version.compareTo("1.7") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre17(holder, version));
        }
        if (version.compareTo("1.8") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre18(holder, version));
        } else {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator18(holder));
        }
        if (version.compareTo("2.3") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre23(holder, version));
        }
        if (version.compareTo("2.5") >= 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator25(holder));
        }
        if (version.compareTo("3.0") < 0) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotatorPre30(holder));
        } else {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator30(holder));
        }
    }
}

