/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrAnnotatorImpl
implements Annotator {
    private static final ThreadLocal<GroovyStaticTypeCheckVisitor> myTypeCheckVisitorThreadLocal = ThreadLocal.withInitial(() -> new GroovyStaticTypeCheckVisitor());

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            GrAnnotatorImpl.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GrAnnotatorImpl.$$$reportNull$$$0(1);
        }
        if (FileIndexFacade.getInstance((Project)element.getProject()).isInLibrarySource(element.getContainingFile().getVirtualFile())) {
            return;
        }
        if (element instanceof GroovyPsiElement) {
            GroovyPsiElement grElement = (GroovyPsiElement)element;
            grElement.accept(new GroovyAnnotator(holder));
            if (PsiUtil.isCompileStatic(grElement)) {
                GroovyStaticTypeCheckVisitor typeCheckVisitor = myTypeCheckVisitorThreadLocal.get();
                assert (typeCheckVisitor != null);
                typeCheckVisitor.accept(grElement, holder);
            }
        } else if (element instanceof PsiComment) {
            String text = element.getText();
            if (text.startsWith("/*") && !text.endsWith("*/")) {
                TextRange range = element.getTextRange();
                holder.createErrorAnnotation(TextRange.create((int)(range.getEndOffset() - 1), (int)range.getEndOffset()), GroovyBundle.message("doc.end.expected", new Object[0]));
            }
        } else {
            GrField field;
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GrMethod) {
                if (element.equals(((GrMethod)parent2).getNameIdentifierGroovy()) && ((GrMethod)parent2).getReturnTypeElementGroovy() == null) {
                    GroovyAnnotator.checkMethodReturnType((GrMethod)parent2, element, holder);
                }
            } else if (parent2 instanceof GrField && element.equals((field = (GrField)parent2).getNameIdentifierGroovy())) {
                GrAccessorMethod[] getters;
                for (GrAccessorMethod getter : getters = field.getGetters()) {
                    GroovyAnnotator.checkMethodReturnType(getter, field.getNameIdentifierGroovy(), holder);
                }
                GrAccessorMethod setter = field.getSetter();
                if (setter != null) {
                    GroovyAnnotator.checkMethodReturnType(setter, field.getNameIdentifierGroovy(), holder);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

