/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.mozilla.javascript;

import java.util.EnumMap;
import org.gradle.internal.impldep.org.mozilla.javascript.BaseFunction;
import org.gradle.internal.impldep.org.mozilla.javascript.Context;
import org.gradle.internal.impldep.org.mozilla.javascript.Function;
import org.gradle.internal.impldep.org.mozilla.javascript.IdScriptableObject;
import org.gradle.internal.impldep.org.mozilla.javascript.ScriptRuntime;
import org.gradle.internal.impldep.org.mozilla.javascript.Scriptable;
import org.gradle.internal.impldep.org.mozilla.javascript.ScriptableObject;

public class TopLevel
extends IdScriptableObject {
    static final long serialVersionUID = -4648046356662472260L;
    private EnumMap<Builtins, BaseFunction> ctors;

    public String getClassName() {
        return "global";
    }

    public void cacheBuiltins() {
        this.ctors = new EnumMap(Builtins.class);
        for (Builtins builtin : Builtins.values()) {
            Object value = ScriptableObject.getProperty((Scriptable)this, builtin.name());
            if (!(value instanceof BaseFunction)) continue;
            this.ctors.put(builtin, (BaseFunction)value);
        }
    }

    public static Function getBuiltinCtor(Context cx, Scriptable scope, Builtins type) {
        BaseFunction result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinCtor(type)) != null) {
            return result;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type.name());
    }

    public static Scriptable getBuiltinPrototype(Scriptable scope, Builtins type) {
        Scriptable result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinPrototype(type)) != null) {
            return result;
        }
        return ScriptableObject.getClassPrototype(scope, type.name());
    }

    public BaseFunction getBuiltinCtor(Builtins type) {
        return this.ctors != null ? this.ctors.get((Object)type) : null;
    }

    public Scriptable getBuiltinPrototype(Builtins type) {
        BaseFunction func = this.getBuiltinCtor(type);
        Object proto = func != null ? func.getPrototypeProperty() : null;
        return proto instanceof Scriptable ? (Scriptable)proto : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Builtins {
        Object,
        Array,
        Function,
        String,
        Number,
        Boolean,
        RegExp,
        Error;

    }
}

