/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical;

import org.gradle.internal.impldep.org.junit.platform.commons.util.BlacklistedExceptions;
import org.gradle.internal.impldep.org.junit.platform.engine.EngineExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.engine.ExecutionRequest;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.TestExecutionResult;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ExecutionTracker;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.Node;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.SingleTestExecutor;

class HierarchicalTestExecutor<C extends EngineExecutionContext> {
    private static final SingleTestExecutor singleTestExecutor = new SingleTestExecutor();
    private final TestDescriptor rootTestDescriptor;
    private final EngineExecutionListener listener;
    private final C rootContext;
    private static final Node noOpNode = new Node(){};

    HierarchicalTestExecutor(ExecutionRequest request, C rootContext) {
        this.rootTestDescriptor = request.getRootTestDescriptor();
        this.listener = request.getEngineExecutionListener();
        this.rootContext = rootContext;
    }

    void execute() {
        this.execute(this.rootTestDescriptor, this.rootContext, new ExecutionTracker());
    }

    private void execute(TestDescriptor testDescriptor, C parentContext, ExecutionTracker tracker) {
        C preparedContext;
        Node<C> node = this.asNode(testDescriptor);
        tracker.markExecuted(testDescriptor);
        try {
            preparedContext = node.prepare(parentContext);
            Node.SkipResult skipResult = node.shouldBeSkipped(preparedContext);
            if (skipResult.isSkipped()) {
                this.listener.executionSkipped(testDescriptor, skipResult.getReason().orElse("<unknown>"));
                return;
            }
        }
        catch (Throwable throwable) {
            BlacklistedExceptions.rethrowIfBlacklisted(throwable);
            this.listener.executionStarted(testDescriptor);
            this.listener.executionFinished(testDescriptor, TestExecutionResult.failed(throwable));
            return;
        }
        this.listener.executionStarted(testDescriptor);
        TestExecutionResult result = singleTestExecutor.executeSafely(() -> {
            EngineExecutionContext context = preparedContext;
            try {
                EngineExecutionContext contextForDynamicChildren = context = node.before(context);
                EngineExecutionContext contextForStaticChildren = context = node.execute(context, dynamicTestDescriptor -> {
                    this.listener.dynamicTestRegistered(dynamicTestDescriptor);
                    this.execute(dynamicTestDescriptor, contextForDynamicChildren, tracker);
                });
                testDescriptor.getChildren().stream().filter(child -> !tracker.wasAlreadyExecuted((TestDescriptor)child)).forEach(child -> this.execute((TestDescriptor)child, (C)contextForStaticChildren, tracker));
            }
            finally {
                node.after(context);
            }
        });
        this.listener.executionFinished(testDescriptor, result);
    }

    private Node<C> asNode(TestDescriptor testDescriptor) {
        return testDescriptor instanceof Node ? (Node)((Object)testDescriptor) : noOpNode;
    }
}

